/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.simulation;

import edu.cmu.tetrad.simulation.HsimRobustCompare;
import java.io.PrintWriter;
import java.util.List;
import org.apache.commons.math3.util.FastMath;

public class HsimCompareRepeat {
    public static void main(String ... args) {
        boolean count = true;
        int numVars = 20;
        double edgesPerNode = 1.1;
        int numCases = 200;
        double penaltyDiscount = 1.0;
        int resimSize = 3;
        int repeat = 10;
        double gAdjRecallTotal = 0.0;
        double gAdjPrecisionTotal = 0.0;
        double gOrRecallTotal = 0.0;
        double gOrPrecisionTotal = 0.0;
        double fAdjRecallTotal = 0.0;
        double fAdjPrecisionTotal = 0.0;
        double fOrRecallTotal = 0.0;
        double fOrPrecisionTotal = 0.0;
        double hAdjRecallTotal = 0.0;
        double hAdjPrecisionTotal = 0.0;
        double hOrRecallTotal = 0.0;
        double hOrPrecisionTotal = 0.0;
        double fSE_ART = 0.0;
        double fSE_APT = 0.0;
        double fSE_ORT = 0.0;
        double fSE_OPT = 0.0;
        double hSE_ART = 0.0;
        double hSE_APT = 0.0;
        double hSE_ORT = 0.0;
        double hSE_OPT = 0.0;
        int fOrPrecCountCorrection = 0;
        int gOrPrecCountCorrection = 0;
        int fSE_OPT_CountCorrection = 0;
        int hSE_OPT_CountCorrection = 0;
        for (int i = 0; i < 1; ++i) {
            List<double[]> allErrors = HsimRobustCompare.run(20, 1.1, 200, 1.0, 3, 10, false);
            gAdjRecallTotal += allErrors.get(0)[1];
            gAdjPrecisionTotal += allErrors.get(0)[2];
            gOrRecallTotal += allErrors.get(0)[3];
            if (Double.isNaN(allErrors.get(0)[4])) {
                ++gOrPrecCountCorrection;
            } else {
                gOrPrecisionTotal += allErrors.get(0)[4];
            }
            fAdjRecallTotal += allErrors.get(1)[1];
            fAdjPrecisionTotal += allErrors.get(1)[2];
            fOrRecallTotal += allErrors.get(1)[3];
            if (Double.isNaN(allErrors.get(1)[4])) {
                ++fOrPrecCountCorrection;
            } else {
                fOrPrecisionTotal += allErrors.get(1)[4];
            }
            hAdjRecallTotal += allErrors.get(2)[1];
            hAdjPrecisionTotal += allErrors.get(2)[2];
            hOrRecallTotal += allErrors.get(2)[3];
            hOrPrecisionTotal += allErrors.get(2)[4];
            fSE_ART += (allErrors.get(0)[1] - allErrors.get(1)[1]) * (allErrors.get(0)[1] - allErrors.get(1)[1]);
            fSE_APT += (allErrors.get(0)[2] - allErrors.get(1)[2]) * (allErrors.get(0)[2] - allErrors.get(1)[2]);
            fSE_ORT += (allErrors.get(0)[3] - allErrors.get(1)[3]) * (allErrors.get(0)[3] - allErrors.get(1)[3]);
            if (Double.isNaN(allErrors.get(0)[4]) || Double.isNaN(allErrors.get(1)[4])) {
                ++fSE_OPT_CountCorrection;
            } else {
                fSE_OPT += (allErrors.get(0)[4] - allErrors.get(1)[4]) * (allErrors.get(0)[4] - allErrors.get(1)[4]);
            }
            hSE_ART += (allErrors.get(0)[1] - allErrors.get(2)[1]) * (allErrors.get(0)[1] - allErrors.get(2)[1]);
            hSE_APT += (allErrors.get(0)[2] - allErrors.get(2)[2]) * (allErrors.get(0)[2] - allErrors.get(2)[2]);
            hSE_ORT += (allErrors.get(0)[3] - allErrors.get(2)[3]) * (allErrors.get(0)[3] - allErrors.get(2)[3]);
            if (Double.isNaN(allErrors.get(0)[4])) {
                ++hSE_OPT_CountCorrection;
                continue;
            }
            hSE_OPT += (allErrors.get(0)[4] - allErrors.get(2)[4]) * (allErrors.get(0)[4] - allErrors.get(2)[4]);
        }
        double gAdjRecall = gAdjRecallTotal / 1.0;
        double gAdjPrecision = gAdjPrecisionTotal / 1.0;
        double gOrRecall = gOrRecallTotal / 1.0;
        double gOrPrecision = gOrPrecisionTotal / (double)(1 - gOrPrecCountCorrection);
        double fAdjRecall = fAdjRecallTotal / 1.0;
        double fAdjPrecision = fAdjPrecisionTotal / 1.0;
        double fOrRecall = fOrRecallTotal / 1.0;
        double fOrPrecision = fOrPrecisionTotal / (double)(1 - fOrPrecCountCorrection);
        double hAdjRecall = hAdjRecallTotal / 1.0;
        double hAdjPrecision = hAdjPrecisionTotal / 1.0;
        double hOrRecall = hOrRecallTotal / 1.0;
        double hOrPrecision = hOrPrecisionTotal / 1.0;
        System.out.println(" ");
        String GE = "G errors: AR=" + gAdjRecall + " AP=" + gAdjPrecision + " OR=" + gOrRecall + " OP=" + gOrPrecision;
        String FE = "F errors: AR=" + fAdjRecall + " AP=" + fAdjPrecision + " OR=" + fOrRecall + " OP=" + fOrPrecision;
        String HE = "H errors: AR=" + hAdjRecall + " AP=" + hAdjPrecision + " OR=" + hOrRecall + " OP=" + hOrPrecision;
        System.out.println(GE);
        System.out.println(FE);
        System.out.println(HE);
        System.out.println(" ");
        double fgDifAR = fAdjRecall - gAdjRecall;
        double fgDifAP = fAdjPrecision - gAdjPrecision;
        double fgDifOR = fOrRecall - gOrRecall;
        double fgDifOP = fOrPrecision - gOrPrecision;
        double hgDifAR = hAdjRecall - gAdjRecall;
        double hgDifAP = hAdjPrecision - gAdjPrecision;
        double hgDifOR = hOrRecall - gOrRecall;
        double hgDifOP = hOrPrecision - gOrPrecision;
        String FD = "FG differences: AR=" + fgDifAR + " AP=" + fgDifAP + " OR=" + fgDifOR + " OP=" + fgDifOP;
        String HD = "HG differences: AR=" + hgDifAR + " AP=" + hgDifAP + " OR=" + hgDifOR + " OP=" + hgDifOP;
        System.out.println(FD);
        System.out.println(HD);
        System.out.println(" ");
        double hfDifDifAR = FastMath.abs(fgDifAR) - FastMath.abs(hgDifAR);
        double hfDifDifAP = FastMath.abs(fgDifAP) - FastMath.abs(hgDifAP);
        double hfDifDifOR = FastMath.abs(fgDifOR) - FastMath.abs(hgDifOR);
        double hfDifDifOP = FastMath.abs(fgDifOP) - FastMath.abs(hgDifOP);
        String AFH = "Absolute F-H: AR=" + hfDifDifAR + " AP=" + hfDifDifAP + " OR=" + hfDifDifOR + " OP=" + hfDifDifOP;
        System.out.println(AFH);
        System.out.println(" ");
        double fMSE_AR = fSE_ART / 1.0;
        double fMSE_AP = fSE_APT / 1.0;
        double fMSE_OR = fSE_ORT / 1.0;
        double fMSE_OP = fSE_OPT / (double)(1 - fSE_OPT_CountCorrection);
        double hMSE_AR = hSE_ART / 1.0;
        double hMSE_AP = hSE_APT / 1.0;
        double hMSE_OR = hSE_ORT / 1.0;
        double hMSE_OP = hSE_OPT / (double)(1 - hSE_OPT_CountCorrection);
        String FMSE = "F-MSE: AR=" + fMSE_AR + " AP=" + fMSE_AP + " OR=" + fMSE_OR + " OP=" + fMSE_OP;
        String HMSE = "H-MSE: AR=" + hMSE_AR + " AP=" + hMSE_AP + " OR=" + hMSE_OR + " OP=" + hMSE_OP;
        System.out.println(FMSE);
        System.out.println(HMSE);
        String nl = System.getProperty("line.separator");
        String resultsLog = GE + nl + FE + nl + HE + nl + nl + FD + nl + HD + nl + AFH + nl + nl + FMSE + nl + HMSE;
        String paramsLog = "count = 1, numVars = 20, edgesPerNode = 1.1, numCases = 200, resimSize = 3, repeat = 10";
        try {
            PrintWriter writer = new PrintWriter("HsimCR-c1-v20-s200-rs3-r10.txt", "UTF-8");
            writer.println("count = 1, numVars = 20, edgesPerNode = 1.1, numCases = 200, resimSize = 3, repeat = 10" + nl + nl + resultsLog);
            writer.close();
        }
        catch (Exception IOException2) {
            IOException2.printStackTrace();
        }
    }
}

