/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.simulation;

import edu.cmu.tetrad.bayes.BayesPm;
import edu.cmu.tetrad.bayes.DirichletBayesIm;
import edu.cmu.tetrad.bayes.DirichletEstimator;
import edu.cmu.tetrad.bayes.MlBayesIm;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphTransforms;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.RandomGraph;
import edu.cmu.tetrad.search.Fges;
import edu.cmu.tetrad.search.score.BdeuScore;
import edu.cmu.tetrad.simulation.HsimRepeatAutoRun;
import edu.cmu.tetrad.simulation.HsimUtils;
import edu.cmu.tetrad.util.RandomUtil;
import java.util.ArrayList;
import java.util.List;

public class HsimRobustCompare {
    public static List<double[]> run(int numVars, double edgesPerNode, int numCases, double penaltyDiscount, int resimSize, int repeat, boolean verbose) {
        RandomUtil.getInstance().setSeed(1450184147770L);
        int delimiter = 44;
        int numEdges = (int)((double)numVars * edgesPerNode);
        ArrayList<Node> vars = new ArrayList<Node>();
        double[] oErrors = new double[5];
        double[] hsimErrors = new double[5];
        double[] simErrors = new double[5];
        ArrayList<double[]> output = new ArrayList<double[]>();
        for (int i = 0; i < numVars; ++i) {
            vars.add(new ContinuousVariable("X" + i));
        }
        Graph odag = RandomGraph.randomGraphRandomForwardEdges(vars, 0, numEdges, 30, 15, 15, false, true);
        BayesPm bayesPm = new BayesPm(odag, 2, 2);
        MlBayesIm bayesIm = new MlBayesIm(bayesPm, 1);
        DataSet oData = bayesIm.simulateData(numCases, false);
        BdeuScore oscore = new BdeuScore(oData);
        Fges fges = new Fges(oscore);
        fges.setVerbose(false);
        Graph oGraphOut = fges.search();
        if (verbose) {
            System.out.println(oGraphOut);
        }
        oErrors = new double[5];
        oErrors = HsimUtils.errorEval(oGraphOut, odag);
        if (verbose) {
            System.out.println(oErrors[0] + " " + oErrors[1] + " " + oErrors[2] + " " + oErrors[3] + " " + oErrors[4]);
        }
        Graph fgesDag = GraphTransforms.dagFromCPDAG(oGraphOut, null);
        Dag fgesdag2 = new Dag(fgesDag);
        BayesPm simBayesPm = new BayesPm(fgesdag2, bayesPm);
        DirichletBayesIm simIM = DirichletBayesIm.symmetricDirichletIm(simBayesPm, 1.0);
        DirichletEstimator simEstimator = new DirichletEstimator();
        DirichletBayesIm fittedIM = DirichletEstimator.estimate(simIM, oData);
        DataSet simData = fittedIM.simulateData(numCases, false);
        HsimRepeatAutoRun study = new HsimRepeatAutoRun(oData);
        hsimErrors = study.run(resimSize, repeat);
        BdeuScore simscore = new BdeuScore(simData);
        Fges simfges = new Fges(simscore);
        simfges.setVerbose(false);
        Graph simGraphOut = simfges.search();
        simErrors = HsimUtils.errorEval(simGraphOut, fgesdag2);
        if (verbose) {
            System.out.println("Original erors are: " + oErrors[0] + " " + oErrors[1] + " " + oErrors[2] + " " + oErrors[3] + " " + oErrors[4]);
        }
        if (verbose) {
            System.out.println("Full resim errors are: " + simErrors[0] + " " + simErrors[1] + " " + simErrors[2] + " " + simErrors[3] + " " + simErrors[4]);
        }
        if (verbose) {
            System.out.println("HSim errors are: " + hsimErrors[0] + " " + hsimErrors[1] + " " + hsimErrors[2] + " " + hsimErrors[3] + " " + hsimErrors[4]);
        }
        output.add(oErrors);
        output.add(simErrors);
        output.add(hsimErrors);
        return output;
    }
}

