/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.simulation;

import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataWriter;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphTransforms;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.Fges;
import edu.cmu.tetrad.search.score.SemBicScore;
import edu.cmu.tetrad.search.utils.GraphSearchUtils;
import edu.cmu.tetrad.simulation.Hsim;
import edu.cmu.tetrad.util.DataConvertUtils;
import edu.cmu.tetrad.util.DelimiterUtils;
import edu.pitt.dbmi.data.reader.tabular.VerticalDiscreteTabularDatasetFileReader;
import java.io.FileWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;

public class HsimRun {
    public static void run(String readfilename, String filenameOut, char delimiter, String[] resimNodeNames, boolean verbose) {
        String workingDirectory = System.getProperty("user.dir");
        System.out.println(workingDirectory);
        try {
            Path dataFile = Paths.get(readfilename, new String[0]);
            VerticalDiscreteTabularDatasetFileReader dataReader = new VerticalDiscreteTabularDatasetFileReader(dataFile, DelimiterUtils.toDelimiter(delimiter));
            DataSet dataSet = (DataSet)DataConvertUtils.toDataModel(dataReader.readInData());
            System.out.println("cols: " + dataSet.getNumColumns() + " rows: " + dataSet.getNumRows());
            double penaltyDiscount = 2.0;
            SemBicScore score = new SemBicScore(new CovarianceMatrix(dataSet));
            score.setPenaltyDiscount(2.0);
            Fges fges = new Fges(score);
            fges.setVerbose(false);
            Graph estGraph = fges.search();
            System.out.println(estGraph);
            EdgeListGraph estCPDAG = new EdgeListGraph(estGraph);
            Graph estGraphDAG = GraphTransforms.dagFromCPDAG(estCPDAG, null);
            Dag estDAG = new Dag(estGraphDAG);
            HashSet<Node> simnodes = new HashSet<Node>();
            for (String resimNodeName : resimNodeNames) {
                Node thisNode = estDAG.getNode(resimNodeName);
                simnodes.add(thisNode);
            }
            Hsim hsim = new Hsim(estDAG, simnodes, dataSet);
            DataSet newDataSet = hsim.hybridsimulate();
            DataWriter.writeRectangularData(newDataSet, new FileWriter(filenameOut), delimiter);
            Path dataFileOut = Paths.get(filenameOut, new String[0]);
            VerticalDiscreteTabularDatasetFileReader dataReaderOut = new VerticalDiscreteTabularDatasetFileReader(dataFileOut, DelimiterUtils.toDelimiter(delimiter));
            DataSet dataSetOut = (DataSet)DataConvertUtils.toDataModel(dataReaderOut.readInData());
            SemBicScore _score = new SemBicScore(new CovarianceMatrix(dataSetOut));
            _score.setPenaltyDiscount(2.0);
            Fges fgesOut = new Fges(_score);
            fgesOut.setVerbose(false);
            Graph estGraphOut = fgesOut.search();
            System.out.println(estGraphOut);
            GraphSearchUtils.graphComparison(estGraph, estGraphOut, System.out);
        }
        catch (Exception IOException2) {
            IOException2.printStackTrace();
        }
    }
}

