/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.simulation;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Node;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.math3.util.FastMath;

public class Vicinity {
    private final int xLow;
    private final int xHigh;
    private final int yLow;
    private final int yHigh;
    private final int zLow;
    private final int zHigh;
    private final double xDist;
    private final double yDist;
    private final double zDist;
    private final DataSet locationMap;
    private final Map<List<Integer>, Set<Edge>> Coords1 = new HashMap<List<Integer>, Set<Edge>>();
    private final Map<List<Integer>, Set<Edge>> Coords2 = new HashMap<List<Integer>, Set<Edge>>();

    public Vicinity(List<Edge> edges, DataSet locationMap, int xLow, int xHigh, int yLow, int yHigh, int zLow, int zHigh, double xDist, double yDist, double zDist) {
        this.xLow = xLow;
        this.xHigh = xHigh;
        this.yLow = yLow;
        this.yHigh = yHigh;
        this.zLow = zLow;
        this.zHigh = zHigh;
        this.xDist = xDist;
        this.yDist = yDist;
        this.zDist = zDist;
        this.locationMap = locationMap;
        for (Edge edge : edges) {
            this.add(this.Coords1, edge, Arrays.asList(this.getX(edge.getNode1(), locationMap), this.getY(edge.getNode1(), locationMap), this.getZ(edge.getNode1(), locationMap)));
            this.add(this.Coords2, edge, Arrays.asList(this.getX(edge.getNode2(), locationMap), this.getY(edge.getNode2(), locationMap), this.getZ(edge.getNode2(), locationMap)));
        }
    }

    public List<Edge> getVicinity(Edge edge, int chunk) {
        int baserange = edge.isDirected() ? this.findRangeD(edge, chunk) : this.findRangeU(edge, chunk);
        int range = (int)FastMath.ceil(FastMath.sqrt(3.0) * (double)baserange);
        return this.findEdges(edge, range);
    }

    private int findRangeU(Edge edge, int chunksize) {
        HashSet<Edge> edges = new HashSet<Edge>();
        int range = -chunksize;
        while (edges.isEmpty()) {
            int z;
            int y;
            int x;
            HashSet node1edges1 = new HashSet();
            HashSet node1edges2 = new HashSet();
            int xrange = (int)FastMath.ceil((double)(range += chunksize) / this.xDist);
            int yrange = (int)FastMath.ceil((double)range / this.yDist);
            int zrange = (int)FastMath.ceil((double)range / this.zDist);
            for (int x2 = this.getX(edge.getNode1(), this.locationMap) - xrange; x2 <= this.getX(edge.getNode1(), this.locationMap) + xrange; ++x2) {
                for (int y2 = this.getY(edge.getNode1(), this.locationMap) - yrange; y2 <= this.getY(edge.getNode1(), this.locationMap) + yrange; ++y2) {
                    for (int z2 = this.getZ(edge.getNode1(), this.locationMap) - zrange; z2 <= this.getZ(edge.getNode1(), this.locationMap) + zrange; ++z2) {
                        if (x2 < this.xLow || x2 > this.xHigh || y2 < this.yLow || y2 > this.yHigh || z2 < this.zLow || z2 > this.zHigh) continue;
                        if (this.Coords1.get(Arrays.asList(x2, y2, z2)) != null) {
                            node1edges1.addAll(this.Coords1.get(Arrays.asList(x2, y2, z2)));
                        }
                        if (this.Coords2.get(Arrays.asList(x2, y2, z2)) == null) continue;
                        node1edges2.addAll(this.Coords2.get(Arrays.asList(x2, y2, z2)));
                    }
                }
            }
            int x2 = this.getX(edge.getNode2(), this.locationMap);
            int y2 = this.getY(edge.getNode2(), this.locationMap);
            int z2 = this.getZ(edge.getNode2(), this.locationMap);
            if (!node1edges1.isEmpty()) {
                for (Edge edge11 : node1edges1) {
                    x = this.getX(edge11.getNode2(), this.locationMap);
                    y = this.getY(edge11.getNode2(), this.locationMap);
                    z = this.getZ(edge11.getNode2(), this.locationMap);
                    if (x < x2 - xrange || x > x2 + xrange || y < y2 - yrange || y > y2 + yrange || z < z2 - zrange || z > z2 + zrange) continue;
                    edges.add(edge11);
                }
            }
            if (node1edges2.isEmpty()) continue;
            for (Edge edge12 : node1edges2) {
                x = this.getX(edge12.getNode1(), this.locationMap);
                y = this.getY(edge12.getNode1(), this.locationMap);
                z = this.getZ(edge12.getNode1(), this.locationMap);
                if (x < x2 - xrange || x > x2 + xrange || y < y2 - yrange || y > y2 + yrange || z < z2 - zrange || z > z2 + zrange) continue;
                edges.add(edge12);
            }
        }
        return range;
    }

    private int findRangeD(Edge edge, int chunksize) {
        HashSet<Edge> edges = new HashSet<Edge>();
        int range = -chunksize;
        while (edges.isEmpty()) {
            int z;
            int y;
            int x;
            int xrange = (int)FastMath.ceil((double)(range += chunksize) / this.xDist);
            int yrange = (int)FastMath.ceil((double)range / this.yDist);
            int zrange = (int)FastMath.ceil((double)range / this.zDist);
            HashSet node1edges1 = new HashSet();
            HashSet node1edges2 = new HashSet();
            for (int x2 = this.getX(edge.getNode1(), this.locationMap) - xrange; x2 <= this.getX(edge.getNode1(), this.locationMap) + xrange; ++x2) {
                for (int y2 = this.getY(edge.getNode1(), this.locationMap) - yrange; y2 <= this.getY(edge.getNode1(), this.locationMap) + yrange; ++y2) {
                    for (int z2 = this.getZ(edge.getNode1(), this.locationMap) - zrange; z2 <= this.getZ(edge.getNode1(), this.locationMap) + zrange; ++z2) {
                        if (x2 < this.xLow || x2 > this.xHigh || y2 < this.yLow || y2 > this.yHigh || z2 < this.zLow || z2 > this.zHigh) continue;
                        if (this.Coords1.get(Arrays.asList(x2, y2, z2)) != null) {
                            node1edges1.addAll(this.Coords1.get(Arrays.asList(x2, y2, z2)));
                        }
                        if (this.Coords2.get(Arrays.asList(x2, y2, z2)) == null) continue;
                        node1edges2.addAll(this.Coords2.get(Arrays.asList(x2, y2, z2)));
                    }
                }
            }
            if (!node1edges2.isEmpty()) {
                ArrayList edges12 = new ArrayList(node1edges2);
                for (Edge thisedge : edges12) {
                    if (!thisedge.isDirected()) continue;
                    node1edges2.remove(thisedge);
                }
            }
            int x2 = this.getX(edge.getNode2(), this.locationMap);
            int y2 = this.getY(edge.getNode2(), this.locationMap);
            int z2 = this.getZ(edge.getNode2(), this.locationMap);
            if (!node1edges1.isEmpty()) {
                for (Edge edge11 : node1edges1) {
                    x = this.getX(edge11.getNode2(), this.locationMap);
                    y = this.getY(edge11.getNode2(), this.locationMap);
                    z = this.getZ(edge11.getNode2(), this.locationMap);
                    if (x < x2 - xrange || x > x2 + xrange || y < y2 - yrange || y > y2 + yrange || z < z2 - zrange || z > z2 + zrange) continue;
                    edges.add(edge11);
                }
            }
            if (node1edges2.isEmpty()) continue;
            for (Edge edge12 : node1edges2) {
                x = this.getX(edge12.getNode1(), this.locationMap);
                y = this.getY(edge12.getNode1(), this.locationMap);
                z = this.getZ(edge12.getNode1(), this.locationMap);
                if (x < x2 - xrange || x > x2 + xrange || y < y2 - yrange || y > y2 + yrange || z < z2 - zrange || z > z2 + zrange) continue;
                edges.add(edge12);
            }
        }
        return range;
    }

    private List<Edge> findEdges(Edge edge, int range) {
        int z;
        int y;
        int x;
        HashSet<Edge> edges = new HashSet<Edge>();
        int xrange = (int)FastMath.ceil((double)range / this.xDist);
        int yrange = (int)FastMath.ceil((double)range / this.yDist);
        int zrange = (int)FastMath.ceil((double)range / this.zDist);
        HashSet node1edges1 = new HashSet();
        HashSet node1edges2 = new HashSet();
        for (int x2 = this.getX(edge.getNode1(), this.locationMap) - xrange; x2 <= this.getX(edge.getNode1(), this.locationMap) + xrange; ++x2) {
            for (int y2 = this.getY(edge.getNode1(), this.locationMap) - yrange; y2 <= this.getY(edge.getNode1(), this.locationMap) + yrange; ++y2) {
                for (int z2 = this.getZ(edge.getNode1(), this.locationMap) - zrange; z2 <= this.getZ(edge.getNode1(), this.locationMap) + zrange; ++z2) {
                    if (x2 < this.xLow || x2 > this.xHigh || y2 < this.yLow || y2 > this.yHigh || z2 < this.zLow || z2 > this.zHigh) continue;
                    if (this.Coords1.get(Arrays.asList(x2, y2, z2)) != null) {
                        node1edges1.addAll(this.Coords1.get(Arrays.asList(x2, y2, z2)));
                    }
                    if (this.Coords2.get(Arrays.asList(x2, y2, z2)) == null) continue;
                    node1edges2.addAll(this.Coords2.get(Arrays.asList(x2, y2, z2)));
                }
            }
        }
        int x2 = this.getX(edge.getNode2(), this.locationMap);
        int y2 = this.getY(edge.getNode2(), this.locationMap);
        int z2 = this.getZ(edge.getNode2(), this.locationMap);
        if (!node1edges1.isEmpty()) {
            for (Edge edge11 : node1edges1) {
                x = this.getX(edge11.getNode2(), this.locationMap);
                y = this.getY(edge11.getNode2(), this.locationMap);
                z = this.getZ(edge11.getNode2(), this.locationMap);
                if (x < x2 - xrange || x > x2 + xrange || y < y2 - yrange || y > y2 + yrange || z < z2 - zrange || z > z2 + zrange) continue;
                edges.add(edge11);
            }
        }
        if (!node1edges2.isEmpty()) {
            for (Edge edge12 : node1edges2) {
                x = this.getX(edge12.getNode1(), this.locationMap);
                y = this.getY(edge12.getNode1(), this.locationMap);
                z = this.getZ(edge12.getNode1(), this.locationMap);
                if (x < x2 - xrange || x > x2 + xrange || y < y2 - yrange || y > y2 + yrange || z < z2 - zrange || z > z2 + zrange) continue;
                edges.add(edge12);
            }
        }
        return new ArrayList<Edge>(edges);
    }

    private void add(Map<List<Integer>, Set<Edge>> Coords, Edge edge, List<Integer> x) {
        Set<Edge> edges = Coords.get(x);
        if (edges == null) {
            edges = new HashSet<Edge>();
            Coords.put(x, edges);
        }
        Coords.get(x).add(edge);
    }

    private int getX(Node node, DataSet locationMap) {
        return (int)locationMap.getDouble(0, locationMap.getColumn(node));
    }

    private int getY(Node node, DataSet locationMap) {
        return (int)locationMap.getDouble(1, locationMap.getColumn(node));
    }

    private int getZ(Node node, DataSet locationMap) {
        return (int)locationMap.getDouble(2, locationMap.getColumn(node));
    }
}

