/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.stat.correlation;

import edu.cmu.tetrad.stat.correlation.RealCovariance;

public class RealCovarianceMatrix
implements RealCovariance {
    private final double[][] data;
    private final int numOfRows;
    private final int numOfCols;

    public RealCovarianceMatrix(double[][] data) {
        this.data = data;
        this.numOfRows = data.length;
        this.numOfCols = data[0].length;
    }

    private double[] computeMeans() {
        double[] mean = new double[this.numOfCols];
        for (int col = 0; col < this.numOfCols; ++col) {
            double sum = 0.0;
            for (int row = 0; row < this.numOfRows; ++row) {
                sum += this.data[row][col];
            }
            mean[col] = sum / (double)this.numOfRows;
        }
        return mean;
    }

    @Override
    public double[] computeLowerTriangle(boolean biasCorrected) {
        double[] covarianceMatrix = new double[this.numOfCols * (this.numOfCols + 1) / 2];
        double[] mean = this.computeMeans();
        int index = 0;
        for (int col = 0; col < this.numOfCols; ++col) {
            for (int col2 = 0; col2 < col; ++col2) {
                double variance = 0.0;
                for (int row = 0; row < this.numOfRows; ++row) {
                    variance += ((this.data[row][col] - mean[col]) * (this.data[row][col2] - mean[col2]) - variance) / (double)(row + 1);
                }
                covarianceMatrix[index++] = biasCorrected ? variance * ((double)this.numOfRows / (double)(this.numOfRows - 1)) : variance;
            }
            double variance = 0.0;
            for (int row = 0; row < this.numOfRows; ++row) {
                variance += ((this.data[row][col] - mean[col]) * (this.data[row][col] - mean[col]) - variance) / (double)(row + 1);
            }
            covarianceMatrix[index++] = biasCorrected ? variance * ((double)this.numOfRows / (double)(this.numOfRows - 1)) : variance;
        }
        return covarianceMatrix;
    }

    @Override
    public double[][] compute(boolean biasCorrected) {
        double[][] covarianceMatrix = new double[this.numOfCols][this.numOfCols];
        double[] mean = this.computeMeans();
        for (int col = 0; col < this.numOfCols; ++col) {
            for (int col2 = 0; col2 < col; ++col2) {
                double variance = 0.0;
                for (int row = 0; row < this.numOfRows; ++row) {
                    variance += ((this.data[row][col] - mean[col]) * (this.data[row][col2] - mean[col2]) - variance) / (double)(row + 1);
                }
                covarianceMatrix[col][col2] = variance = biasCorrected ? variance * ((double)this.numOfRows / (double)(this.numOfRows - 1)) : variance;
                covarianceMatrix[col2][col] = variance;
            }
            double variance = 0.0;
            for (int row = 0; row < this.numOfRows; ++row) {
                variance += ((this.data[row][col] - mean[col]) * (this.data[row][col] - mean[col]) - variance) / (double)(row + 1);
            }
            covarianceMatrix[col][col] = biasCorrected ? variance * ((double)this.numOfRows / (double)(this.numOfRows - 1)) : variance;
        }
        return covarianceMatrix;
    }
}

