/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.study.examples.conditions;

import edu.cmu.tetrad.algcomparison.Comparison;
import edu.cmu.tetrad.algcomparison.algorithm.Algorithms;
import edu.cmu.tetrad.algcomparison.algorithm.oracle.cpdag.Fges;
import edu.cmu.tetrad.algcomparison.graph.RandomForward;
import edu.cmu.tetrad.algcomparison.score.SemBicScore;
import edu.cmu.tetrad.algcomparison.simulation.SemSimulation;
import edu.cmu.tetrad.algcomparison.simulation.Simulations;
import edu.cmu.tetrad.algcomparison.statistic.AdjacencyPrecision;
import edu.cmu.tetrad.algcomparison.statistic.AdjacencyRecall;
import edu.cmu.tetrad.algcomparison.statistic.ArrowheadPrecision;
import edu.cmu.tetrad.algcomparison.statistic.ArrowheadPrecisionCommonEdges;
import edu.cmu.tetrad.algcomparison.statistic.ArrowheadRecall;
import edu.cmu.tetrad.algcomparison.statistic.ArrowheadRecallCommonEdges;
import edu.cmu.tetrad.algcomparison.statistic.ElapsedCpuTime;
import edu.cmu.tetrad.algcomparison.statistic.F1All;
import edu.cmu.tetrad.algcomparison.statistic.GraphExactlyRight;
import edu.cmu.tetrad.algcomparison.statistic.NumberOfEdgesEst;
import edu.cmu.tetrad.algcomparison.statistic.ParameterColumn;
import edu.cmu.tetrad.algcomparison.statistic.Statistics;
import edu.cmu.tetrad.algcomparison.statistic.TailPrecision;
import edu.cmu.tetrad.algcomparison.statistic.TailRecall;
import edu.cmu.tetrad.util.Parameters;

public class ExampleCompareSimulation {
    public static void main(String ... args) {
        Parameters parameters = new Parameters();
        parameters.set("numRuns", (Object)20);
        parameters.set("differentGraphs", (Object)true);
        parameters.set("sampleSize", 1000, 100000);
        parameters.set("numMeasures", (Object)20);
        parameters.set("numLatents", (Object)0);
        parameters.set("avgDegree", (Object)4);
        parameters.set("maxDegree", (Object)1000);
        parameters.set("maxIndegree", (Object)1000);
        parameters.set("maxOutdegree", (Object)1000);
        parameters.set("connected", (Object)false);
        parameters.set("coefLow", (Object)0.1);
        parameters.set("coefHigh", (Object)0.6);
        parameters.set("varLow", (Object)1);
        parameters.set("varHigh", (Object)3);
        parameters.set("verbose", (Object)false);
        parameters.set("coefSymmetric", (Object)false);
        parameters.set("percentDiscrete", (Object)0);
        parameters.set("numCategories", (Object)3);
        parameters.set("differentGraphs", (Object)true);
        parameters.set("intervalBetweenShocks", (Object)100);
        parameters.set("intervalBetweenRecordings", (Object)100);
        parameters.set("fisherEpsilon", (Object)1.0E-5);
        parameters.set("randomizeColumns", (Object)true);
        parameters.set("alpha", (Object)0.01);
        parameters.set("depth", (Object)-1);
        parameters.set("useMaxPOrientationHeuristic", (Object)false);
        parameters.set("symmetricFirstStep", (Object)true);
        parameters.set("faithfulnessAssumed", (Object)false);
        parameters.set("maxPOrientationMaxPathLength", (Object)3);
        parameters.set("verbose", (Object)false);
        parameters.set("maxDegree", (Object)100);
        parameters.set("penaltyDiscount", (Object)1);
        parameters.set("structurePrior", (Object)0);
        parameters.set("alpha", (Object)0.01);
        parameters.set("stableFAS", (Object)true);
        parameters.set("concurrentFAS", (Object)true);
        parameters.set("colliderDiscoveryRule", 2, 3);
        Statistics statistics = new Statistics();
        statistics.add(new ParameterColumn("sampleSize"));
        statistics.add(new ParameterColumn("thresholdAlpha"));
        statistics.add(new ParameterColumn("penaltyDiscount"));
        statistics.add(new NumberOfEdgesEst());
        statistics.add(new AdjacencyPrecision());
        statistics.add(new AdjacencyRecall());
        statistics.add(new ArrowheadPrecision());
        statistics.add(new ArrowheadRecall());
        statistics.add(new ArrowheadPrecisionCommonEdges());
        statistics.add(new ArrowheadRecallCommonEdges());
        statistics.add(new F1All());
        statistics.add(new ElapsedCpuTime());
        statistics.add(new TailPrecision());
        statistics.add(new TailRecall());
        statistics.add(new GraphExactlyRight());
        statistics.setWeight("AP", 1.0);
        statistics.setWeight("AR", 1.0);
        statistics.setWeight("AHP", 1.0);
        statistics.setWeight("AHR", 1.0);
        Algorithms algorithms = new Algorithms();
        algorithms.add(new Fges(new SemBicScore()));
        Simulations simulations = new Simulations();
        simulations.add(new SemSimulation(new RandomForward()));
        Comparison comparison = new Comparison();
        comparison.setShowAlgorithmIndices(false);
        comparison.setShowSimulationIndices(false);
        comparison.setSortByUtility(false);
        comparison.setShowUtilities(false);
        comparison.setComparisonGraph(Comparison.ComparisonGraph.CPDAG_of_the_true_DAG);
        comparison.compareFromSimulations("comparisonJoe", simulations, algorithms, statistics, parameters);
    }
}

