/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.study.examples.conditions;

import edu.cmu.tetrad.algcomparison.Comparison;
import edu.cmu.tetrad.algcomparison.algorithm.Algorithms;
import edu.cmu.tetrad.algcomparison.algorithm.oracle.cpdag.Fges;
import edu.cmu.tetrad.algcomparison.algorithm.oracle.cpdag.Pc;
import edu.cmu.tetrad.algcomparison.graph.RandomForward;
import edu.cmu.tetrad.algcomparison.independence.ChiSquare;
import edu.cmu.tetrad.algcomparison.independence.Gsquare;
import edu.cmu.tetrad.algcomparison.score.BdeuScore;
import edu.cmu.tetrad.algcomparison.score.ConditionalGaussianBicScore;
import edu.cmu.tetrad.algcomparison.score.DiscreteBicScore;
import edu.cmu.tetrad.algcomparison.simulation.BayesNetSimulation;
import edu.cmu.tetrad.algcomparison.simulation.Simulations;
import edu.cmu.tetrad.algcomparison.statistic.AdjacencyPrecision;
import edu.cmu.tetrad.algcomparison.statistic.AdjacencyRecall;
import edu.cmu.tetrad.algcomparison.statistic.ArrowheadPrecision;
import edu.cmu.tetrad.algcomparison.statistic.ArrowheadPrecisionCommonEdges;
import edu.cmu.tetrad.algcomparison.statistic.ArrowheadRecall;
import edu.cmu.tetrad.algcomparison.statistic.ParameterColumn;
import edu.cmu.tetrad.algcomparison.statistic.Statistics;
import edu.cmu.tetrad.algcomparison.statistic.StructuralHammingDistance;
import edu.cmu.tetrad.util.Parameters;

public class ExampleCompareSimulationDiscrete {
    public static void main(String ... args) {
        Parameters parameters = new Parameters();
        int sampleSize = 5000;
        parameters.set("numRuns", (Object)10);
        parameters.set("numMeasures", 10, 20);
        parameters.set("avgDegree", 2, 4);
        parameters.set("sampleSize", (Object)5000);
        parameters.set("minCategories", (Object)3);
        parameters.set("maxCategories", (Object)3);
        parameters.set("differentGraphs", (Object)true);
        parameters.set("alpha", 0.05, 0.01, 0.001);
        parameters.set("conflictRule", (Object)3);
        parameters.set("maxDegree", (Object)100);
        parameters.set("samplePrior", 1, 5, 10, 15, 20, 25, 30, 50, 80, 100);
        parameters.set("structurePrior", 1, 2, 3, 4, 5);
        parameters.set("discretize", (Object)true);
        Statistics statistics = new Statistics();
        statistics.add(new ParameterColumn("numMeasures"));
        statistics.add(new ParameterColumn("avgDegree"));
        statistics.add(new ParameterColumn("sampleSize"));
        statistics.add(new ParameterColumn("colliderDiscoveryRule"));
        statistics.add(new ParameterColumn("samplePrior"));
        statistics.add(new ParameterColumn("structurePrior"));
        statistics.add(new ParameterColumn("discretize"));
        statistics.add(new ParameterColumn("alpha"));
        statistics.add(new AdjacencyPrecision());
        statistics.add(new AdjacencyRecall());
        statistics.add(new ArrowheadPrecision());
        statistics.add(new ArrowheadPrecisionCommonEdges());
        statistics.add(new ArrowheadRecall());
        statistics.add(new StructuralHammingDistance());
        statistics.setWeight("SHD", 1.0);
        Algorithms algorithms = new Algorithms();
        algorithms.add(new Pc(new ChiSquare()));
        algorithms.add(new Pc(new Gsquare()));
        algorithms.add(new Fges(new BdeuScore()));
        algorithms.add(new Fges(new DiscreteBicScore()));
        algorithms.add(new Fges(new ConditionalGaussianBicScore()));
        Simulations simulations = new Simulations();
        simulations.add(new BayesNetSimulation(new RandomForward()));
        Comparison comparison = new Comparison();
        comparison.setShowAlgorithmIndices(true);
        comparison.setShowSimulationIndices(true);
        comparison.setSortByUtility(true);
        comparison.setComparisonGraph(Comparison.ComparisonGraph.CPDAG_of_the_true_DAG);
        comparison.compareFromSimulations("comparison.discrete.study", simulations, "comparison_all_5000", algorithms, statistics, parameters);
    }
}

