/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.study.gene.tetrad.gene.algorithm.akutsu;

import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.NumberFormatUtil;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.NumberFormat;
import java.util.StringTokenizer;
import org.apache.commons.math3.util.FastMath;

public class LTestSsys1 {
    public static void main(String[] argv) {
        FileInputStream s;
        String fileName = argv[0];
        int ngenes = 5;
        int ntimes = 400;
        int nrecords = 5;
        int nchips = 4;
        double[][] cases = new double[4][2004];
        try {
            s = new FileInputStream(fileName);
        }
        catch (IOException e) {
            System.out.println("Cannot open file " + fileName);
            return;
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(s));
        for (int k = 0; k < 5; ++k) {
            try {
                StringTokenizer st = new StringTokenizer(in.readLine());
                if (k == 0) continue;
                for (int j = 0; j < 2000; ++j) {
                    cases[k - 1][j] = Double.parseDouble(st.nextToken("\t"));
                }
                continue;
            }
            catch (IOException e) {
                System.out.println("Read error in " + fileName);
                return;
            }
        }
        double[][] gene = new double[400][5];
        double[][] deriv = new double[400][5];
        double[] sum = new double[5];
        double baseLevel = 15.0;
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        double min = 1000.0;
        for (int j = 0; j < 400; ++j) {
            for (int g = 0; g < 5; ++g) {
                int icol = j * 5 + g;
                sum[g] = 0.0;
                for (int c = 0; c < 4; ++c) {
                    int n = g;
                    sum[n] = sum[n] + cases[c][icol];
                }
                gene[j][g] = sum[g];
                if (gene[j][g] < min) {
                    min = gene[j][g];
                }
                if (j == 0) continue;
                deriv[j][g] = (gene[j][g] - gene[j - 1][g]) / 10.0;
            }
        }
        System.out.println("minimum value = " + min);
        for (int g = 0; g < 5; ++g) {
            System.out.println("For gene " + g);
            int k = 5;
            ChoiceGenerator cg = new ChoiceGenerator(5, 5);
            int[] regs = new int[5];
            while ((regs = cg.next()) != null) {
                System.out.println("Sets of 5 regulators are:");
                System.out.println(regs[0] + " " + regs[1] + " " + regs[2] + " " + regs[3] + " " + regs[4]);
                for (int t = 1; t < 400; ++t) {
                    String g0 = nf.format(FastMath.log(gene[t][regs[0]] + 15.0));
                    String g1 = nf.format(FastMath.log(gene[t][regs[1]] + 15.0));
                    String g2 = nf.format(FastMath.log(gene[t][regs[2]] + 15.0));
                    String g3 = nf.format(FastMath.log(gene[t][regs[3]] + 15.0));
                    String g4 = nf.format(FastMath.log(gene[t][regs[4]] + 15.0));
                    if (deriv[t][g] > 0.35) {
                        System.out.println("lnamlnb+" + g0 + "gmh0+" + g1 + "gmh1+" + g2 + "gmh2+" + g3 + "gmh3+" + g4 + "gmh4 > 0");
                        continue;
                    }
                    if (!(deriv[t][g] < -0.35)) continue;
                    System.out.println("lnamlnb+" + g0 + "gmh0+" + g1 + "gmh1+" + g2 + "gmh2+" + g3 + "gmh3+" + g4 + "gmh4 < 0");
                }
            }
        }
    }
}

