/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.study.gene.tetrad.gene.algorithm.biolingua;

import edu.cmu.tetrad.study.gene.tetrad.gene.algorithm.biolingua.BiolinguaDigraph;
import edu.cmu.tetrad.study.gene.tetrad.gene.algorithm.util.SymMatrixF;
import org.apache.commons.math3.util.FastMath;

public class Biolingua {
    private static final float ALMOST_ZERO = 1.0E-5f;
    private static final float SIGNIF_LEVEL = 0.05f;
    private static float bitsAnnotat = 0.1f;
    private static float bitsErrors = 3.0f;
    private static float bitsLinks = 4.0f;
    private static float bitsPredic = 3.0f;
    private static int nvars;
    private static BiolinguaDigraph g;
    private static SymMatrixF cm;
    private static SymMatrixF sm;
    private static int[] path;
    private static boolean[] visited;
    private static boolean cycle;
    private static int targetParent;
    private static float emtempG;
    private static float emCurrentModel;
    private static float em1StepBest;
    private static int bestEnode1;
    private static int bestEnode2;
    private static int bestChange;
    private static int pos;
    private static int neg;

    private Biolingua() {
    }

    public static synchronized BiolinguaDigraph BiolinguaAlgorithm(SymMatrixF correlMatrix, BiolinguaDigraph initGraph) {
        float ka = 0.1f;
        float ke = 3.0f;
        float kl = 4.0f;
        float kp = 3.0f;
        return Biolingua.doBiolinguaAlgorithm(correlMatrix, null, initGraph, 0.1f, 3.0f, 4.0f, 3.0f);
    }

    public static synchronized BiolinguaDigraph BiolinguaAlgorithm(SymMatrixF correlMatrix, BiolinguaDigraph initGraph, float vBitsAnnotat, float vBitsErrors, float vbitsLinks, float vBitsPredic) {
        return Biolingua.doBiolinguaAlgorithm(correlMatrix, null, initGraph, vbitsLinks, vBitsPredic, vBitsAnnotat, vBitsErrors);
    }

    public static synchronized BiolinguaDigraph BiolinguaAlgorithm(SymMatrixF correlMatrix, SymMatrixF signifMatrix, BiolinguaDigraph initGraph, float vBitsAnnotat, float vBitsErrors, float vbitsLinks, float vBitsPredic) {
        return Biolingua.doBiolinguaAlgorithm(correlMatrix, signifMatrix, initGraph, vbitsLinks, vBitsPredic, vBitsAnnotat, vBitsErrors);
    }

    private static BiolinguaDigraph doBiolinguaAlgorithm(SymMatrixF correlMatrix, SymMatrixF signifMatrix, BiolinguaDigraph initGraph, float vBitsAnnotat, float vBitsErrors, float vbitsLinks, float vBitsPredic) {
        nvars = correlMatrix.getSize();
        bitsAnnotat = vBitsAnnotat;
        bitsErrors = vBitsErrors;
        bitsLinks = vbitsLinks;
        bitsPredic = vBitsPredic;
        if (nvars != initGraph.getSize()) {
            throw new IllegalArgumentException("Incompatible # vars.: " + nvars + " in Correl.Matrix, " + initGraph.getSize() + " in initial graph.");
        }
        if (signifMatrix != null && signifMatrix.getSize() != nvars) {
            throw new IllegalArgumentException("Incompatible # vars.: " + nvars + " in Correl.Matrix, " + signifMatrix.getSize() + " in Significance Matrix.");
        }
        path = new int[nvars];
        visited = new boolean[nvars];
        g = new BiolinguaDigraph(initGraph);
        cm = correlMatrix;
        sm = signifMatrix;
        emCurrentModel = 0.0f;
        em1StepBest = 0.0f;
        bestEnode1 = 0;
        bestEnode2 = 0;
        bestChange = 0;
        emCurrentModel = Biolingua.evalCurrentModel();
        if (cycle) {
            throw new IllegalArgumentException("Starting graph has a cycle");
        }
        System.out.println("Initial eval metric = " + emCurrentModel);
        while (true) {
            em1StepBest = emCurrentModel;
            for (int vi = 0; vi < nvars; ++vi) {
                for (int vj = 0; vj < nvars; ++vj) {
                    if (vi == vj) continue;
                    int origState = (int)g.getEdge(vi, vj);
                    for (int state = -1; state <= 1; ++state) {
                        if (state == origState) continue;
                        g.setEdge(vi, vj, state);
                        emtempG = Biolingua.evalCurrentModel();
                        if (cycle || !(emtempG < em1StepBest)) continue;
                        bestEnode1 = vi;
                        bestEnode2 = vj;
                        bestChange = state;
                        em1StepBest = emtempG;
                    }
                    g.setEdge(vi, vj, origState);
                }
            }
            if (em1StepBest >= emCurrentModel) break;
            g.setEdge(bestEnode1, bestEnode2, bestChange);
            emCurrentModel = em1StepBest;
            System.out.println("Best eval metric so far = " + emCurrentModel);
        }
        g.setGraphName("Biolingua result");
        return g;
    }

    private static float evalCurrentModel() {
        int annotations = 0;
        int predictions = 0;
        int errors = 0;
        cycle = false;
        for (int i = 0; i < nvars; ++i) {
            Biolingua.visited[i] = false;
        }
        for (int vi = 0; vi < nvars; ++vi) {
            for (int vj = 0; vj < nvars; ++vj) {
                if (vi == vj) continue;
                targetParent = vi;
                pos = 0;
                neg = 0;
                Biolingua.findPaths(vj, 0);
                if (cycle) {
                    return -1.0f;
                }
                if (pos + neg > 0) {
                    int correlMSign;
                    if (pos > 0 && neg > 0) {
                        ++annotations;
                    }
                    int predictedSign = pos == neg ? 0 : (pos > neg ? 1 : -1);
                    float correlValue = cm.getValue(vi, vj);
                    if (sm != null && sm.getValue(vi, vj) > 0.05f) {
                        correlValue = 0.0f;
                    }
                    int n = Biolingua.isZero(correlValue) ? 0 : (correlMSign = correlValue > 0.0f ? 1 : -1);
                    if (correlMSign == predictedSign) {
                        ++predictions;
                        continue;
                    }
                    ++errors;
                    continue;
                }
                if (Biolingua.isZero(cm.getValue(vi, vj))) continue;
                ++errors;
            }
        }
        int nEdges = g.getNumEdges();
        return bitsLinks * (float)nEdges + bitsAnnotat * (float)annotations + bitsErrors * (float)errors - bitsPredic * (float)predictions;
    }

    private static void findPaths(int vj, int pathLen) {
        if (visited[vj]) {
            cycle = true;
            return;
        }
        Biolingua.path[pathLen] = vj;
        if (vj == targetParent) {
            if (g.isParent(path[0], targetParent)) {
                cycle = true;
                return;
            }
            int negEdges = 0;
            for (int i = 1; i <= pathLen; ++i) {
                if (!(g.getEdge(path[i], path[i - 1]) < 0.0)) continue;
                ++negEdges;
            }
            if (negEdges % 2 == 0) {
                ++pos;
            } else {
                ++neg;
            }
        } else {
            int[] parent = g.getParents(vj);
            Biolingua.visited[vj] = true;
            int np = parent.length;
            for (int i : parent) {
                Biolingua.findPaths(i, pathLen + 1);
                if (!cycle) continue;
                return;
            }
            Biolingua.visited[vj] = false;
        }
    }

    private static boolean isZero(float x) {
        return FastMath.abs(x) <= 1.0E-5f;
    }
}

