/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.study.gene.tetrad.gene.algorithm.biolingua;

import edu.cmu.tetrad.study.gene.tetrad.gene.algorithm.biolingua.Digraph;
import edu.cmu.tetrad.study.gene.tetrad.gene.algorithm.util.OutputGraph;
import java.io.IOException;

public class BiolinguaDigraph
extends Digraph
implements OutputGraph {
    public BiolinguaDigraph(String gName, int n) {
        super(gName, n);
    }

    public BiolinguaDigraph(String fname) throws IOException {
        super(fname);
    }

    public BiolinguaDigraph(BiolinguaDigraph digraph) {
        this("Clone_of_[" + digraph + "]", digraph.nNodes);
        for (int i = 0; i < digraph.nNodes; ++i) {
            this.nodeNames[i] = digraph.nodeNames[i];
            for (int j = 0; j < i; ++j) {
                this.setEdge(i, j, digraph.getEdge(i, j));
            }
        }
    }

    @Override
    public Object clone() {
        BiolinguaDigraph g2 = new BiolinguaDigraph("Clone_of_[" + this.graphName + "]", this.nNodes);
        for (int i = 0; i < this.nNodes; ++i) {
            g2.nodeNames[i] = this.nodeNames[i];
            for (int j = 0; j < i; ++j) {
                g2.setEdge(i, j, this.getEdge(i, j));
            }
        }
        return g2;
    }

    public boolean isParent(int p, int c) {
        return this.getEdges().getDoubleValue(p, c) != 0.0;
    }

    public String strOfParents(int i) {
        int[] ap = this.getParents(i);
        String s = "";
        for (int anAp : ap) {
            s = s + " " + anAp;
        }
        return s;
    }

    @Override
    public int[] getLags(int i) {
        return null;
    }

    @Override
    public String toString() {
        String s = this.getClass().getName() + " " + this.graphName + "\n" + this.nNodes + "\t// <-- Total # nodes\n// " + this.getNumEdges() + "\t// <-- Total # edges\n";
        s = s + "\n// Node names:\n";
        for (int i = 0; i < this.nNodes; ++i) {
            s = s + this.getNodeName(i);
            s = s + "\t// #" + i + " \tParents = {" + this.strOfParents(i) + " }\n";
        }
        s = s + "\n// edges:\n";
        s = s + this.EdgesToString();
        return s;
    }
}

