/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.study.gene.tetrad.gene.algorithm.biolingua;

import edu.cmu.tetrad.study.gene.tetrad.gene.algorithm.biolingua.Biolingua;
import edu.cmu.tetrad.study.gene.tetrad.gene.algorithm.biolingua.BiolinguaDigraph;
import edu.cmu.tetrad.study.gene.tetrad.gene.algorithm.util.SymMatrixF;

public class BiolinguaRunner {
    static final String dashes = "===================================================================\n";
    static final String welcomeMsg = "\n===================================================================\nedu.cmu.gene.algorithm.biolingua.BiolinguaRunner.java    IHMC-UWF    rsaavedr@ai.uwf.edu    Jan/2002\nRuns the Biolingua algorithm\n===================================================================\n";
    static String mfname = "ltm.txt";
    static String gfname = "g.txt";
    static float ka = 0.1f;
    static float ke = 3.0f;
    static float kl = 4.0f;
    static float kp = 3.0f;

    static void usageInfo(boolean welcome) {
        if (welcome) {
            System.out.println("\n\n===================================================================\nedu.cmu.gene.algorithm.biolingua.BiolinguaRunner.java    IHMC-UWF    rsaavedr@ai.uwf.edu    Jan/2002\nRuns the Biolingua algorithm\n===================================================================\n\n");
        }
        System.out.println("\nUsage  : java edu.cmu.gene.algorithm.biolingua.BiolinguaRunner [parameters]\n\nParameters:\n    -mfile    Name of file containing the Correlation Matrix       (def=cm.txt)\n    -gfile    Name of File containing the initial Graph            (def=g.txt)\n    -ka#      Coefficient for Annotations in eval. metric function (def=.1)\n    -ke#      Coefficient for Errors      in eval. metric function (def=3)\n    -kl#      Coefficient for Links       in eval. metric function (def=4)\n    -kp#      Coefficient for Predictions in eval. metric function (def=3)\n\nExample: java edu.cmu.gene.algorithm.biolingua.BiolinguaRunner  -mcm.txt  -gg.txt  -ka.1  -ke3  -kl4  -kp3\n\n  Runs biolingua with the correlation matrix in file cm.txt, starting search\n  from graph in file g.txt, and using coefficients .1, 3, 4, and 3.");
    }

    static void bailout(String errorMsg, int exitCode) {
        String highlight = "***************************************************************";
        BiolinguaRunner.usageInfo(false);
        System.out.println("***************************************************************\nError: " + errorMsg);
        System.out.println("See program parameters above");
        System.out.println("***************************************************************");
        System.exit(exitCode);
    }

    public static void main(String[] args) {
        if (args.length > 0 && args[0].equals("/?")) {
            BiolinguaRunner.usageInfo(true);
            System.exit(0);
        }
        for (String arg : args) {
            String varg = arg.toLowerCase();
            try {
                if (varg.startsWith("-m")) {
                    mfname = varg.substring(2);
                    continue;
                }
                if (varg.startsWith("-g")) {
                    gfname = varg.substring(2);
                    continue;
                }
                if (varg.startsWith("-ka")) {
                    ka = Float.parseFloat(varg.substring(3));
                    continue;
                }
                if (varg.startsWith("-ke")) {
                    ke = Float.parseFloat(varg.substring(3));
                    continue;
                }
                if (varg.startsWith("-kl")) {
                    kl = Float.parseFloat(varg.substring(3));
                    continue;
                }
                if (varg.startsWith("-kp")) {
                    kp = Float.parseFloat(varg.substring(3));
                    continue;
                }
                BiolinguaRunner.bailout("Unrecognized parameter  " + arg, 2);
            }
            catch (Exception xcp) {
                BiolinguaRunner.bailout("Unable to parse value from parameter  " + arg, 1);
            }
        }
        try {
            SymMatrixF cm = new SymMatrixF(mfname);
            BiolinguaDigraph g = new BiolinguaDigraph(gfname);
            System.out.println(welcomeMsg);
            System.out.println("Inputs:");
            System.out.println("**** ka = " + ka);
            System.out.println("**** ke = " + ke);
            System.out.println("**** kl = " + kl);
            System.out.println("**** kp = " + kp);
            System.out.println("**** Correlation matrix:\n" + cm);
            System.out.println("**** Initial graph:\n" + g);
            System.out.println("Running Biolingua");
            BiolinguaDigraph result = Biolingua.BiolinguaAlgorithm(cm, g, ka, ke, kl, kp);
            System.out.println("\nFinal Graph:\n" + result);
        }
        catch (Exception xcp) {
            System.out.println("Watch out!!!!  There was an exception:");
            xcp.printStackTrace();
        }
    }
}

