/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.study.gene.tetrad.gene.algorithm.ideker;

import edu.cmu.tetrad.util.ChoiceGenerator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

public class ItkPredictorSearch {
    int ngenes;
    int nrows;
    String[] names;
    int[][] expression;

    public ItkPredictorSearch(int ngenes, int[][] expression, String[] names) {
        this.ngenes = ngenes;
        this.expression = expression;
        this.names = names;
        this.nrows = expression.length;
    }

    public void predictor(int gene) {
        SortedSet[] minCover;
        int[] rows;
        SortedSet[][] S = new TreeSet[this.nrows][this.nrows];
        Gene[] G = new Gene[this.ngenes];
        System.out.println("For gene " + this.names[gene] + ":");
        for (int i = 0; i < this.nrows; ++i) {
            for (int j = 0; j < this.nrows; ++j) {
                S[i][j] = new TreeSet();
            }
        }
        for (int k = 0; k < this.ngenes; ++k) {
            G[k] = new Gene(k);
        }
        ChoiceGenerator cg = new ChoiceGenerator(this.ngenes, 2);
        while ((rows = cg.next()) != null) {
            if (this.expression[rows[0]][gene] == -1 || this.expression[rows[0]][gene] == 2 || this.expression[rows[1]][gene] == -1 || this.expression[rows[1]][gene] == 2 || !this.differByPerturbation(gene, rows[0], rows[1])) continue;
            for (int gother = 0; gother < this.ngenes; ++gother) {
                if (gother == gene || !this.differByPerturbation(gother, rows[0], rows[1])) continue;
                S[rows[0]][rows[1]].add(G[gother]);
            }
            System.out.print("sem" + rows[0] + rows[1] + " = ");
            for (Object o : S[rows[0]][rows[1]]) {
                System.out.print(((Gene)o).getIndex());
            }
            System.out.println();
        }
        int sum = 0;
        for (int i = 0; i < this.nrows; ++i) {
            for (int j = 0; j < this.nrows; ++j) {
                sum += S[i][j].size();
            }
        }
        if (sum == 0) {
            System.out.println("Insufficient perturbations for gene " + this.names[gene]);
            System.out.println();
            return;
        }
        System.out.println("Smin:");
        for (SortedSet aMinCover : minCover = this.minCoveringSet(S)) {
            this.display(aMinCover);
            this.inferFunction(gene, aMinCover);
        }
        System.out.println();
    }

    public SortedSet[] minCoveringSet(SortedSet[][] sets) {
        int i;
        TreeSet union = new TreeSet();
        for (SortedSet[] set : sets) {
            for (int j = 0; j < sets[0].length; ++j) {
                union.addAll(set[j]);
            }
        }
        int total = union.size();
        int sizePowerSet = 1;
        for (int i2 = 0; i2 < total; ++i2) {
            sizePowerSet *= 2;
        }
        Gene[] geneArray = new Gene[total];
        int k = 0;
        Iterator j = union.iterator();
        while (j.hasNext()) {
            Gene anUnion;
            geneArray[k] = anUnion = (Gene)j.next();
            ++k;
        }
        int[] indexArray = new int[total];
        for (int i3 = 0; i3 < total; ++i3) {
            indexArray[i3] = geneArray[i3].getIndex();
        }
        int[] sizes = new int[sizePowerSet];
        boolean[] covers = new boolean[sizePowerSet];
        sizes[0] = 0;
        covers[0] = false;
        int minSize = 100;
        for (int subSetIndex = 1; subSetIndex < sizePowerSet; ++subSetIndex) {
            byte[] bool = this.booleanRepresentation(subSetIndex, total);
            TreeSet<Gene> subSet = new TreeSet<Gene>();
            for (i = 0; i < total; ++i) {
                if (bool[i] != 1) continue;
                subSet.add(geneArray[i]);
            }
            sizes[subSetIndex] = subSet.size();
            if (sizes[subSetIndex] > minSize) continue;
            covers[subSetIndex] = true;
            for (SortedSet[] set : sets) {
                for (int j2 = 0; j2 < sets[0].length; ++j2) {
                    if (set[j2].isEmpty() || this.covered(set[j2], subSet)) continue;
                    covers[subSetIndex] = false;
                }
            }
            if (!covers[subSetIndex] || sizes[subSetIndex] >= minSize) continue;
            minSize = sizes[subSetIndex];
        }
        int numCoveringSets = 0;
        for (int i4 = 0; i4 < sizePowerSet; ++i4) {
            if (sizes[i4] != minSize || !covers[i4]) continue;
            ++numCoveringSets;
        }
        SortedSet[] coveringSets = new SortedSet[numCoveringSets];
        int number = 0;
        for (i = 0; i < sizePowerSet; ++i) {
            if (sizes[i] != minSize || !covers[i]) continue;
            byte[] bool = this.booleanRepresentation(i, total);
            TreeSet<Gene> subSet = new TreeSet<Gene>();
            for (int j3 = 0; j3 < total; ++j3) {
                if (bool[j3] != 1) continue;
                subSet.add(geneArray[j3]);
            }
            coveringSets[number] = subSet;
            ++number;
        }
        return coveringSets;
    }

    public void inferFunction(int g, SortedSet<Gene> s) {
        int n = s.size();
        int[] ss = new int[n];
        int c = 0;
        for (Gene value : s) {
            ss[c] = value.getIndex();
            ++c;
        }
        int twoToN = 1;
        for (int i = 0; i < n; ++i) {
            twoToN *= 2;
        }
        int[] f = new int[twoToN];
        for (int i = 0; i < twoToN; ++i) {
            f[i] = 9;
        }
        for (Gene value1 : s) {
            System.out.print(this.names[value1.getIndex()] + " ");
        }
        System.out.println("f");
        for (int i = twoToN - 1; i >= 0; --i) {
            byte[] b = this.booleanRepresentation(i, n);
            block5: for (int j = 0; j < this.nrows; ++j) {
                if (this.expression[j][g] == -1 || this.expression[j][g] == 2) continue;
                for (int k = 0; k < n; ++k) {
                    if (this.differExpressions(this.expression[j][ss[k]], b[k])) continue block5;
                }
                f[i] = this.expression[j][g];
            }
            for (int k = 0; k < n; ++k) {
                System.out.print(b[k] + "  ");
            }
            System.out.println(f[i]);
        }
    }

    public boolean covered(SortedSet<Gene> a, SortedSet<Gene> b) {
        boolean result = false;
        for (Gene anA : a) {
            if (!b.contains(anA)) continue;
            result = true;
            return result;
        }
        return result;
    }

    public void display(SortedSet<Gene> s) {
        for (Gene value : s) {
            System.out.print(value.getIndex() + " ");
        }
        System.out.println();
    }

    public boolean differByPerturbation(int gene, int p0, int p1) {
        return !(this.expression[p0][gene] == this.expression[p1][gene] || this.expression[p0][gene] == -1 && this.expression[p1][gene] == 0 || this.expression[p1][gene] == -1 && this.expression[p0][gene] == 0 || this.expression[p0][gene] * this.expression[p1][gene] == 2);
    }

    public boolean differExpressions(int e1, int e2) {
        return true;
    }

    public byte[] booleanRepresentation(int ind, int n) {
        int i;
        byte[] rep = new byte[n];
        for (i = 0; i < n; ++i) {
            rep[i] = 0;
        }
        for (i = 0; i < n; ++i) {
            int rem = ind % 2;
            if (rem == 1) {
                rep[n - i - 1] = 1;
                --ind;
            }
            ind /= 2;
        }
        return rep;
    }

    public static class Gene
    implements Comparable {
        int gene;

        public Gene(int gene) {
            this.gene = gene;
        }

        public int getIndex() {
            return this.gene;
        }

        public int compareTo(Object o) {
            int ret = this.gene < ((Gene)o).getIndex() ? -1 : (this.gene == ((Gene)o).getIndex() ? 0 : 1);
            return ret;
        }
    }
}

