/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.study.gene.tetrad.gene.algorithm.reveal;

import edu.cmu.tetrad.study.gene.tetrad.gene.algorithm.reveal.RevealEvaluator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestRevealEvaluator
extends TestCase {
    private static final int ngenes = 6;
    private static final int ntimes = 9;
    private static final int[][] cases = new int[9][6];
    private static final double TOLERANCE = 1.0E-6;

    public TestRevealEvaluator(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite((Class<?>)TestRevealEvaluator.class);
    }

    public void testLiangFigure6() {
        int[] a = new int[]{0, 0, 0, 0, 1, 1, 1, 1};
        int[] b = new int[]{0, 0, 1, 1, 0, 0, 1, 1};
        int[] c = new int[]{0, 1, 0, 1, 0, 1, 0, 1};
        int[] ap = new int[]{0, 0, 1, 1, 0, 0, 1, 1};
        int[] bp = new int[]{0, 1, 0, 1, 1, 1, 1, 1};
        int[] cp = new int[]{0, 0, 0, 1, 0, 1, 1, 1};
        for (int i = 0; i < 8; ++i) {
            TestRevealEvaluator.cases[i][0] = a[i];
            TestRevealEvaluator.cases[i][1] = b[i];
            TestRevealEvaluator.cases[i][2] = c[i];
            TestRevealEvaluator.cases[i + 1][3] = ap[i];
            TestRevealEvaluator.cases[i + 1][4] = bp[i];
            TestRevealEvaluator.cases[i + 1][5] = cp[i];
        }
        TestRevealEvaluator.cases[8][0] = 0;
        TestRevealEvaluator.cases[8][1] = 0;
        TestRevealEvaluator.cases[8][2] = 0;
        TestRevealEvaluator.cases[0][3] = 0;
        TestRevealEvaluator.cases[0][4] = 0;
        TestRevealEvaluator.cases[0][5] = 0;
        RevealEvaluator re = new RevealEvaluator(cases);
        double rea = re.entropy(a);
        TestCase.assertEquals(1.0, rea, 1.0E-6);
        System.out.println("H(a) = " + rea);
        double reb = re.entropy(b);
        TestCase.assertEquals(1.0, reb, 1.0E-6);
        System.out.println("H(b) = " + reb);
        double rec = re.entropy(c);
        TestCase.assertEquals(1.0, rec, 1.0E-6);
        System.out.println("H(c) = " + rec);
        double reab = re.jointEntropy(a, b);
        TestCase.assertEquals(2.0, reab, 1.0E-6);
        System.out.println("H(a,b) = " + reab);
        double reap = re.entropy(ap);
        TestCase.assertEquals(1.0, reap, 1.0E-6);
        System.out.println("H(ap) = " + reap);
        double rebp = re.entropy(bp);
        TestCase.assertEquals(0.8112781244591328, rebp, 1.0E-6);
        System.out.println("H(bp) = " + rebp);
        double recp = re.entropy(cp);
        TestCase.assertEquals(1.0, recp, 1.0E-6);
        System.out.println("H(cp) = " + recp);
        double reapa = re.jointEntropy(ap, a);
        TestCase.assertEquals(2.0, reapa, 1.0E-6);
        System.out.println("H(ap, a) = " + reapa);
        double rebpb = re.jointEntropy(bp, b);
        TestCase.assertEquals(1.8112781244591327, rebpb, 1.0E-6);
        System.out.println("H(bp, b) = " + rebpb);
        double recpb = re.jointEntropy(cp, b);
        TestCase.assertEquals(1.8112781244591327, recpb, 1.0E-6);
        System.out.println("H(cp, b) = " + recpb);
        int[][] ab = new int[2][8];
        for (int i = 0; i < 8; ++i) {
            ab[0][i] = a[i];
            ab[1][i] = b[i];
        }
        double rebpab = re.jointEntropy(bp, ab);
        TestCase.assertEquals(2.5, rebpab, 1.0E-6);
        System.out.println("H(bp, a, b) = " + rebpab);
        double recpab = re.jointEntropy(cp, ab);
        TestCase.assertEquals(2.5, recpab, 1.0E-6);
        System.out.println("H(cp, a, b) = " + recpab);
        int[][] abc = new int[3][8];
        for (int i = 0; i < 8; ++i) {
            abc[0][i] = a[i];
            abc[1][i] = b[i];
            abc[2][i] = c[i];
        }
        double recpabc = re.jointEntropy(cp, abc);
        TestCase.assertEquals(3.0, recpabc, 1.0E-6);
        System.out.println("H(cp, a, b, c) = " + recpabc);
        int[] p = new int[]{0};
        double rembpa = re.mutualInformation(4, p, 1);
        TestCase.assertEquals(0.31127812445913294, rembpa, 1.0E-6);
        System.out.println("M(Bp, A) = " + rembpa);
        int[] pp = new int[]{0, 1};
        double rmcpab = re.mutualInformation(5, pp, 1);
        TestCase.assertEquals(0.5, rmcpab, 1.0E-6);
        System.out.println("M(Cp, [A,B]) = " + rmcpab);
        int[] ppp = new int[]{0, 1, 2};
        double rmcpabc = re.mutualInformation(5, ppp, 1);
        TestCase.assertEquals(1.0, rmcpabc, 1.0E-6);
        System.out.println("M(Cp, [A,B,C]) = " + rmcpabc);
    }
}

