/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.study.gene.tetrad.gene.algorithm.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;

public abstract class BasicGraph {
    protected String graphName;
    protected int nNodes;
    protected String[] nodeNames;
    protected int nEdges;

    protected BasicGraph() {
    }

    public BasicGraph(String gName, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Invalid # nodes " + n);
        }
        this.graphName = gName;
        this.nNodes = n;
        this.nEdges = 0;
        this.nodeNames = new String[n];
        for (int i = 0; i < n; ++i) {
            this.nodeNames[i] = "Node" + i;
        }
        this.initializeEdges();
    }

    public BasicGraph(String fname) throws IOException {
        File f = new File(fname);
        BufferedReader in = new BufferedReader(new FileReader(f));
        StreamTokenizer strmTok = new StreamTokenizer(in);
        strmTok.slashStarComments(true);
        strmTok.slashSlashComments(true);
        strmTok.parseNumbers();
        strmTok.wordChars(95, 95);
        int nt = strmTok.nextToken();
        if (strmTok.sval == null || !strmTok.sval.toUpperCase().contains("GRAPH")) {
            throw new IllegalArgumentException("First token does not contain 'GRAPH': " + strmTok.sval);
        }
        nt = strmTok.nextToken();
        this.graphName = strmTok.sval;
        nt = strmTok.nextToken();
        if (nt != -2) {
            throw new IllegalArgumentException("Expecting # of nodes in graph instead of: " + strmTok.sval);
        }
        this.nNodes = (int)strmTok.nval;
        if (this.nNodes <= 0) {
            throw new IllegalArgumentException("Invalid # nodes " + this.nNodes);
        }
        this.nodeNames = new String[this.nNodes];
        for (int i = 0; i < this.nNodes; ++i) {
            nt = strmTok.nextToken();
            this.nodeNames[i] = strmTok.sval;
        }
        this.initializeEdges();
        while ((nt = strmTok.nextToken()) != -1) {
            int node_i = (int)strmTok.nval;
            nt = strmTok.nextToken();
            int node_j = (int)strmTok.nval;
            nt = strmTok.nextToken();
            double edgeValue = strmTok.nval;
            this.setEdge(node_i, node_j, edgeValue);
        }
        in.close();
    }

    public String getGraphName() {
        return this.graphName;
    }

    public void setGraphName(String newName) {
        this.graphName = newName;
    }

    public int getSize() {
        return this.nNodes;
    }

    public void setNodeName(int i, String nodeName) {
        if (i < 0 || i > this.nNodes - 1) {
            this.badNodeIndex(i);
        }
        this.nodeNames[i] = nodeName;
    }

    public String getNodeName(int i) {
        if (i < 0 || i > this.nNodes - 1) {
            this.badNodeIndex(i);
        }
        return this.nodeNames[i];
    }

    public int getNumEdges() {
        return this.nEdges;
    }

    public String toString() {
        StringBuilder s = new StringBuilder(this.getClass().getName() + " " + this.graphName + "\n" + this.nNodes + " // <-- Total # nodes\n");
        s.append("\n// Node names:\n");
        for (int i = 0; i < this.nNodes; ++i) {
            s.append(this.getNodeName(i)).append("\t// # ").append(i).append("\n");
        }
        s.append("\n// edges:\n").append(this.EdgesToString());
        return s.toString();
    }

    protected void badNodeIndex(int i) {
        throw new IllegalArgumentException("Bad node index " + i + " for Graph with " + this.nNodes + " nodes");
    }

    public abstract Object clone();

    protected abstract void initializeEdges();

    public abstract void setEdge(int var1, int var2, double var3);

    public abstract double getEdge(int var1, int var2);

    public abstract String EdgesToString();
}

