/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.study.gene.tetrad.gene.algorithm.util;

import edu.cmu.tetrad.study.gene.tetrad.gene.algorithm.util.BasicLTMatrix;
import java.io.IOException;

public class LTMatrixF
extends BasicLTMatrix {
    protected float[] A;

    public LTMatrixF(String mname, int nrows) {
        super(mname, nrows);
    }

    public LTMatrixF(String fname) throws IOException {
        super(fname);
    }

    @Override
    protected void initMatrixStorage() {
        this.A = new float[this.n * (this.n + 1) / 2];
    }

    @Override
    public void setDoubleValue(int r, int c, double x) {
        this.setValue(r, c, x);
    }

    public void setValue(int r, int c, double x) {
        if (x < -3.4028234663852886E38 || x > 3.4028234663852886E38) {
            throw new IllegalArgumentException("Double " + x + " cannot be stored as a float");
        }
        this.setValue(r, c, (float)x);
    }

    public void setValue(int r, int c, float x) {
        if (r < c) {
            this.upperTriangXcp(r, c);
        }
        if (r >= this.n || c >= this.n || r < 0 || c < 0) {
            this.badIndexXcp(r, c);
        }
        this.A[r * (r + 1) / 2 + c] = x;
    }

    @Override
    public double getDoubleValue(int r, int c) {
        if (r >= this.n || c >= this.n || r < 0 || c < 0) {
            this.badIndexXcp(r, c);
        }
        return r >= c ? (double)this.A[r * (r + 1) / 2 + c] : 0.0;
    }

    public float getValue(int r, int c) {
        if (r >= this.n || c >= this.n || r < 0 || c < 0) {
            this.badIndexXcp(r, c);
        }
        return r >= c ? this.A[r * (r + 1) / 2 + c] : 0.0f;
    }

    @Override
    public void setAllValuesToZero() {
        for (int i = 0; i < this.A.length; ++i) {
            this.A[i] = 0.0f;
        }
    }

    private void upperTriangXcp(int r, int c) {
        throw new IllegalArgumentException("Trying to set a value in (" + r + "," + c + ") -> Upper Triangular region ");
    }
}

