/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.study.gene.tetrad.gene.graph;

import edu.cmu.tetrad.study.gene.tetrad.gene.history.BasicLagGraph;
import edu.cmu.tetrad.study.gene.tetrad.gene.history.LagGraph;
import edu.cmu.tetrad.study.gene.tetrad.gene.history.LaggedEdge;
import edu.cmu.tetrad.study.gene.tetrad.gene.history.LaggedFactor;
import edu.cmu.tetrad.util.NamingProtocol;
import edu.cmu.tetrad.util.PointXy;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;

public class ActiveLagGraph
implements LagGraph {
    private static final long serialVersionUID = 23L;
    private final LagGraph lagGraph = new BasicLagGraph();
    private transient PropertyChangeSupport propertyChangeManager;

    public static ActiveLagGraph serializableInstance() {
        return new ActiveLagGraph();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.getPropertyChangeManager().addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.getPropertyChangeManager().removePropertyChangeListener(l);
    }

    @Override
    public void addEdge(String factor, LaggedFactor laggedFactor) {
        if (!this.existsEdge(factor, laggedFactor)) {
            try {
                if (laggedFactor.getLag() > this.getMaxLagAllowable()) {
                    this.setMaxLagAllowable(laggedFactor.getLag());
                }
                this.lagGraph.addEdge(factor, laggedFactor);
                this.getPropertyChangeManager().firePropertyChange("edgeAdded", null, new LaggedEdge(factor, laggedFactor));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void addFactor(String factor) {
        if (!NamingProtocol.isLegalName(factor)) {
            throw new IllegalArgumentException(NamingProtocol.getProtocolDescription());
        }
        if (!this.existsFactor(factor)) {
            try {
                this.lagGraph.addFactor(factor);
                this.getPropertyChangeManager().firePropertyChange("nodeAdded", null, factor);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void removeEdge(String factor, LaggedFactor laggedFactor) {
        if (this.existsEdge(factor, laggedFactor)) {
            try {
                this.lagGraph.removeEdge(factor, laggedFactor);
                this.getPropertyChangeManager().firePropertyChange("edgeRemoved", new LaggedEdge(factor, laggedFactor), null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void removeFactor(String factor) {
        try {
            this.lagGraph.removeFactor(factor);
            this.getPropertyChangeManager().firePropertyChange("nodeRemoved", factor, null);
            ArrayList<LaggedFactor> toDelete = new ArrayList<LaggedFactor>();
            SortedSet<String> factors = this.getFactors();
            for (String value : factors) {
                SortedSet<LaggedFactor> parents = this.lagGraph.getParents(value);
                for (LaggedFactor laggedFactor : parents) {
                    if (!laggedFactor.getFactor().equals(factor)) continue;
                    toDelete.add(laggedFactor);
                }
                for (Object e : toDelete) {
                    this.removeEdge(value, (LaggedFactor)e);
                }
                toDelete.clear();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void renameFactor(String oldName, String newName) {
        try {
            this.lagGraph.renameFactor(oldName, newName);
            this.getPropertyChangeManager().firePropertyChange("factorRenamed", oldName, newName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private PropertyChangeSupport getPropertyChangeManager() {
        if (this.propertyChangeManager == null) {
            this.propertyChangeManager = new PropertyChangeSupport(this);
        }
        return this.propertyChangeManager;
    }

    @Override
    public void clearEdges() {
        this.lagGraph.clearEdges();
    }

    @Override
    public boolean existsFactor(String factor) {
        return this.lagGraph.existsFactor(factor);
    }

    @Override
    public boolean existsEdge(String factor, LaggedFactor laggedFactor) {
        return this.lagGraph.existsEdge(factor, laggedFactor);
    }

    @Override
    public SortedSet<LaggedFactor> getParents(String factor) {
        return this.lagGraph.getParents(factor);
    }

    @Override
    public int getMaxLagAllowable() {
        return this.lagGraph.getMaxLagAllowable();
    }

    @Override
    public void setMaxLagAllowable(int maxLagAllowable) {
        if (maxLagAllowable >= this.getMaxLag()) {
            this.lagGraph.setMaxLagAllowable(maxLagAllowable);
            this.lagGraph.setMaxLagAllowable(maxLagAllowable);
            this.getPropertyChangeManager().firePropertyChange("maxLagAllowable", null, (Object)this.getMaxLagAllowable());
        }
    }

    @Override
    public int getMaxLag() {
        return this.lagGraph.getMaxLag();
    }

    public SortedMap getConnectivity() {
        return this.lagGraph.getConnectivity();
    }

    @Override
    public int getNumFactors() {
        return this.lagGraph.getNumFactors();
    }

    @Override
    public SortedSet<String> getFactors() {
        return this.lagGraph.getFactors();
    }

    @Override
    public void addFactors(String base, int numFactors) {
        this.lagGraph.addFactors(base, numFactors);
    }

    @Override
    public void setLocation(String factor, PointXy point) {
        this.lagGraph.setLocation(factor, point);
    }

    @Override
    public PointXy getLocation(String factor) {
        return this.lagGraph.getLocation(factor);
    }

    @Override
    public Map getLocations() {
        return this.lagGraph.getLocations();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.lagGraph == null) {
            throw new NullPointerException();
        }
    }
}

