/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.study.gene.tetrad.gene.history;

import edu.cmu.tetrad.study.gene.tetrad.gene.history.BooleanGlassFunction;
import edu.cmu.tetrad.study.gene.tetrad.gene.history.IndexedLagGraph;
import edu.cmu.tetrad.study.gene.tetrad.gene.history.Initializer;
import edu.cmu.tetrad.study.gene.tetrad.gene.history.UpdateFunction;
import edu.cmu.tetrad.util.dist.Normal;
import java.io.IOException;
import java.io.ObjectInputStream;

public class BasalInitializer
implements Initializer {
    private static final long serialVersionUID = 23L;
    private final UpdateFunction updateFunction;
    private final double basalExpression;
    private final double initStDev;

    public BasalInitializer(UpdateFunction updateFunction, double basalExpression, double initStDev) {
        if (updateFunction == null) {
            throw new NullPointerException("Update function must not be null");
        }
        if (initStDev <= 0.0) {
            throw new IllegalArgumentException("The initialization standard deviation must be positive");
        }
        this.updateFunction = updateFunction;
        this.basalExpression = basalExpression;
        this.initStDev = initStDev;
    }

    public static BasalInitializer serializableInstance() {
        return new BasalInitializer(BooleanGlassFunction.serializableInstance(), 0.0, 1.0);
    }

    @Override
    public void initialize(double[][] history) {
        Normal initDistribution = new Normal(this.basalExpression, this.initStDev);
        for (int j = 0; j < history[0].length; ++j) {
            IndexedLagGraph connectivity = this.updateFunction.getIndexedLagGraph();
            history[0][j] = connectivity.getNumParents(j) == 0 ? this.basalExpression : initDistribution.nextRandom();
        }
        for (int i = 1; i < history.length; ++i) {
            System.arraycopy(history[0], 0, history[i], 0, history[0].length);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.updateFunction == null) {
            throw new NullPointerException();
        }
        if (this.initStDev <= 0.0) {
            throw new IllegalStateException();
        }
    }
}

