/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.study.gene.tetrad.gene.history;

import edu.cmu.tetrad.util.TetradSerializable;
import edu.cmu.tetrad.util.dist.Normal;
import java.io.IOException;
import java.io.ObjectInputStream;

public class DishModel
implements TetradSerializable {
    private static final long serialVersionUID = 23L;
    private final double[] dishBumps;
    private int dishNumber;
    private double dishBumpStDev = 10.0;

    public DishModel(int numDishes, double dishBumpStDev) {
        if (numDishes < 1) {
            throw new IllegalArgumentException("There must be at least one dish");
        }
        if (dishBumpStDev < 0.0) {
            throw new IllegalArgumentException("The stdev must be non-negative");
        }
        this.dishBumps = new double[numDishes];
        this.setDishBumpStDev(dishBumpStDev);
        Normal distribution = new Normal(100.0, dishBumpStDev);
        for (int i = 0; i < numDishes; ++i) {
            this.dishBumps[i] = distribution.nextRandom();
        }
    }

    public static DishModel serializableInstance() {
        return new DishModel(1, 1.0);
    }

    public int getDishNumber() {
        return this.dishNumber;
    }

    public void setDishNumber(int dishNumber) {
        if (dishNumber < 0 || dishNumber >= this.dishBumps.length) {
            throw new IllegalArgumentException("Invalid dish number: " + dishNumber);
        }
        this.dishNumber = dishNumber;
    }

    public double bumpInitialization(double expressionLevel) {
        return expressionLevel * this.dishBumps[this.dishNumber] / 100.0;
    }

    public double getDishBumpStDev() {
        return this.dishBumpStDev;
    }

    public void setDishBumpStDev(double dishBumpStDev) {
        this.dishBumpStDev = dishBumpStDev;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.dishBumps == null) {
            throw new NullPointerException();
        }
        if (this.dishBumpStDev < 0.0) {
            throw new IllegalStateException();
        }
        if (this.dishNumber < 0 || this.dishNumber >= this.dishBumps.length) {
            throw new IllegalStateException();
        }
    }
}

