/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.study.gene.tetrad.gene.history;

import edu.cmu.tetrad.util.TetradSerializable;
import java.io.IOException;
import java.io.ObjectInputStream;

public class LaggedFactor
implements Comparable,
TetradSerializable {
    private static final long serialVersionUID = 23L;
    private final int lag;
    private String factor;

    public LaggedFactor(String factor, int lag) {
        if (factor == null) {
            throw new NullPointerException("Factor name must not be null");
        }
        if (lag < 0) {
            throw new IllegalArgumentException("Lag must be >= 0");
        }
        this.factor = factor;
        this.lag = lag;
    }

    public LaggedFactor(LaggedFactor orig) {
        this.factor = orig.factor;
        this.lag = orig.lag;
    }

    public static LaggedFactor serializableInstance() {
        return new LaggedFactor("X", 1);
    }

    public int compareTo(Object o) {
        if (o instanceof LaggedFactor) {
            LaggedFactor f = (LaggedFactor)o;
            int n = this.factor.compareTo(f.getFactor());
            if (n != 0) {
                return n;
            }
            return this.lag - f.getLag();
        }
        return 0;
    }

    public String getFactor() {
        return this.factor;
    }

    public void setFactor(String factor) {
        this.factor = factor;
    }

    public int getLag() {
        return this.lag;
    }

    public int hashCode() {
        return 127 * this.factor.hashCode() + this.lag;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LaggedFactor)) {
            return false;
        }
        LaggedFactor c = (LaggedFactor)o;
        return c.getFactor().equals(this.getFactor()) && c.getLag() == this.getLag();
    }

    public String toString() {
        return this.factor + ":" + this.lag;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.factor == null) {
            throw new NullPointerException();
        }
        if (this.lag < 0) {
            throw new IllegalStateException();
        }
    }
}

