/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.study.gene.tetrad.gene.history;

import edu.cmu.tetrad.study.gene.tetrad.gene.history.BasicLagGraph;
import edu.cmu.tetrad.study.gene.tetrad.gene.history.IndexedLagGraph;
import edu.cmu.tetrad.study.gene.tetrad.gene.history.IndexedParent;
import edu.cmu.tetrad.study.gene.tetrad.gene.history.LagGraph;
import edu.cmu.tetrad.study.gene.tetrad.gene.history.Polynomial;
import edu.cmu.tetrad.study.gene.tetrad.gene.history.PolynomialTerm;
import edu.cmu.tetrad.study.gene.tetrad.gene.history.UpdateFunction;
import edu.cmu.tetrad.util.dist.Distribution;
import edu.cmu.tetrad.util.dist.Normal;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;

public class PolynomialFunction
implements UpdateFunction {
    private static final long serialVersionUID = 23L;
    private final IndexedLagGraph connectivity;
    private final Polynomial[] polynomials;
    private final Distribution[] errorDistributions;

    public PolynomialFunction(LagGraph lagGraph) {
        int i;
        if (lagGraph == null) {
            throw new NullPointerException("Lag graph must not be null.");
        }
        this.connectivity = new IndexedLagGraph(lagGraph);
        int numFactors = this.connectivity.getNumFactors();
        this.polynomials = new Polynomial[numFactors];
        for (i = 0; i < numFactors; ++i) {
            this.polynomials[i] = new Polynomial(new ArrayList<PolynomialTerm>());
        }
        this.errorDistributions = new Distribution[numFactors];
        for (i = 0; i < this.errorDistributions.length; ++i) {
            this.errorDistributions[i] = new Normal(0.0, 0.05);
        }
    }

    public static PolynomialFunction serializableInstance() {
        return new PolynomialFunction(BasicLagGraph.serializableInstance());
    }

    @Override
    public double getValue(int factorIndex, double[][] history) {
        int numParents = this.connectivity.getNumParents(factorIndex);
        double[] values = new double[numParents];
        for (int i = 0; i < numParents; ++i) {
            IndexedParent parent = this.connectivity.getParent(factorIndex, i);
            values[i] = history[parent.getLag()][parent.getIndex()];
        }
        return this.polynomials[factorIndex].evaluate(values) + this.errorDistributions[factorIndex].nextRandom();
    }

    @Override
    public IndexedLagGraph getIndexedLagGraph() {
        return this.connectivity;
    }

    public void setErrorDistribution(int factor, Distribution distribution) {
        if (distribution == null) {
            throw new NullPointerException();
        }
        this.errorDistributions[factor] = distribution;
    }

    public Distribution getErrorDistribution(int factor) {
        return this.errorDistributions[factor];
    }

    public void setPolynomial(int factor, Polynomial polynomial) {
        if (polynomial == null) {
            throw new NullPointerException("Polynomial must not be null.");
        }
        this.polynomials[factor] = polynomial;
    }

    public Polynomial getPolynomial(int factor) {
        return this.polynomials[factor];
    }

    @Override
    public int getNumFactors() {
        return this.connectivity.getNumFactors();
    }

    @Override
    public int getMaxLag() {
        int maxLag = 0;
        for (int i = 0; i < this.connectivity.getNumFactors(); ++i) {
            for (int j = 0; j < this.connectivity.getNumParents(i); ++j) {
                IndexedParent parent = this.connectivity.getParent(i, j);
                if (parent.getLag() <= maxLag) continue;
                maxLag = parent.getLag();
            }
        }
        return maxLag;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.connectivity == null) {
            throw new NullPointerException();
        }
        if (this.polynomials == null) {
            throw new NullPointerException();
        }
        if (this.errorDistributions == null) {
            throw new NullPointerException();
        }
    }
}

