/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.study.gene.tetrad.gene.history;

import edu.cmu.tetrad.study.gene.tetrad.gene.history.GraphInitializer;
import edu.cmu.tetrad.study.gene.tetrad.gene.history.LagGraph;
import edu.cmu.tetrad.study.gene.tetrad.gene.history.LaggedFactor;
import edu.cmu.tetrad.util.RandomUtil;
import java.util.ArrayList;

public class SimpleRandomizer
implements GraphInitializer {
    public static final int CONSTANT = 0;
    public static final int MAX = 1;
    public static final int MEAN = 2;
    private static final long serialVersionUID = 23L;
    private int indegreeType = 0;
    private int indegree = 1;
    private int mlag = 1;
    private double percentHousekeeping = 80.0;

    public SimpleRandomizer(int indegree, int indegreeType, int mlag, double percentHousekeeping) {
        if (indegree < 2) {
            throw new IllegalArgumentException("Indegree must be at least 2: " + indegree);
        }
        this.indegree = indegree;
        switch (indegreeType) {
            case 0: 
            case 1: 
            case 2: {
                this.indegreeType = indegreeType;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (mlag <= 0) {
            throw new IllegalArgumentException();
        }
        this.mlag = mlag;
        if (!(percentHousekeeping >= 0.0) || !(percentHousekeeping <= 100.0)) {
            throw new IllegalArgumentException();
        }
        this.percentHousekeeping = percentHousekeeping;
    }

    @Override
    public void initialize(LagGraph lagGraph) {
        String factor;
        lagGraph.clearEdges();
        ArrayList<String> factors = new ArrayList<String>(lagGraph.getFactors());
        for (Object e : factors) {
            factor = (String)e;
            LaggedFactor laggedFactor = new LaggedFactor(factor, 1);
            lagGraph.addEdge(factor, laggedFactor);
        }
        for (Object e : factors) {
            boolean isHousekeeping;
            factor = (String)e;
            int extraEdges = 1;
            boolean bl = isHousekeeping = RandomUtil.getInstance().nextDouble() * 100.0 < this.percentHousekeeping;
            if (isHousekeeping) continue;
            switch (this.indegreeType) {
                case 0: {
                    extraEdges = this.indegree - 1;
                    break;
                }
                case 1: {
                    extraEdges = RandomUtil.getInstance().nextInt(this.indegree - 1) + 1;
                    break;
                }
                case 2: {
                    extraEdges = RandomUtil.getInstance().nextInt(2 * (this.indegree - 1) - 1) + 1;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            int i = 0;
            while (i < extraEdges) {
                int lag = RandomUtil.getInstance().nextInt(this.mlag) + 1;
                int factorIndex = RandomUtil.getInstance().nextInt(lagGraph.getNumFactors());
                String otherFactor = (String)factors.get(factorIndex);
                LaggedFactor laggedFactor = new LaggedFactor(otherFactor, lag);
                if (lagGraph.existsEdge(factor, laggedFactor)) continue;
                lagGraph.addEdge(factor, laggedFactor);
                ++i;
            }
        }
    }
}

