/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.study.gene.tetrad.gene.simulation;

import edu.cmu.tetrad.study.gene.tetrad.gene.history.DishModel;
import edu.cmu.tetrad.study.gene.tetrad.gene.history.GeneHistory;
import edu.cmu.tetrad.study.gene.tetrad.gene.history.UpdateFunction;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.TetradSerializable;
import edu.cmu.tetrad.util.dist.Normal;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.math3.util.FastMath;

public class MeasurementSimulator
implements TetradSerializable {
    private static final long serialVersionUID = 23L;
    private final Parameters parameters;
    private final int numDishes = 1;
    private final int numCellsPerDish = 10000;
    private final int stepsGenerated = 4;
    private final int firstStepStored = 1;
    private final int interval = 1;
    private final double dishDishVariability = 10.0;
    private final int numSamplesPerDish = 4;
    private final double sampleSampleVariability = 0.025;
    private final double chipChipVariability = 0.1;
    private final double pixelDigitalization = 0.025;
    private GeneHistory history;
    private int[] timeSteps;
    private double[][][] rawData;
    private double[][][] measuredData;
    private int dishNumber = -1;
    private int cellNumber = -1;

    public MeasurementSimulator(Parameters parameters) {
        this.parameters = parameters;
        this.constructTimeSteps();
    }

    public static MeasurementSimulator serializableInstance() {
        return new MeasurementSimulator(new Parameters());
    }

    public GeneHistory getHistory() {
        return this.history;
    }

    public void setHistory(GeneHistory history) {
        if (history == null) {
            throw new NullPointerException();
        }
        this.history = history;
    }

    public int getNumDishes() {
        Objects.requireNonNull(this);
        return this.parameters.getInt("numDishes", 1);
    }

    public void setNumDishes(int numDishes) {
        if (numDishes <= 0) {
            throw new IllegalArgumentException("Number of dishes must be > 0: " + numDishes);
        }
        this.parameters.set("numDishes", (Object)numDishes);
    }

    public boolean isIncludeDishAndChipColumns() {
        boolean includeDishAndChipColumns = true;
        return this.parameters.getBoolean("includeDishAndChipColumns", includeDishAndChipColumns);
    }

    public void setIncludeDishAndChipColumns(boolean includeDishAndChipColumns) {
        this.parameters.set("includeDishAndChipColumns", (Object)includeDishAndChipColumns);
    }

    public int getNumCellsPerDish() {
        return this.parameters.getInt("numCellsPerDish", this.numCellsPerDish);
    }

    public void setNumCellsPerDish(int numCellsPerDish) {
        if (numCellsPerDish <= 0) {
            throw new IllegalArgumentException("Number of cells per dish must be > 0:" + numCellsPerDish);
        }
        this.parameters.set("numCellsPerDish", (Object)numCellsPerDish);
    }

    public int getStepsGenerated() {
        Objects.requireNonNull(this);
        return this.parameters.getInt("stepsGenerated", 4);
    }

    public void setStepsGenerated(int stepsGenerated) {
        if (stepsGenerated <= 0) {
            throw new IllegalArgumentException("Steps generated must be > 0:" + stepsGenerated);
        }
        this.parameters.set("stepsGenerated", (Object)stepsGenerated);
        this.constructTimeSteps();
    }

    public int getFirstStepStored() {
        Objects.requireNonNull(this);
        return this.parameters.getInt("firstStepStored", 1);
    }

    public void setFirstStepStored(int firstStepStored) {
        if (firstStepStored <= 0) {
            throw new IllegalArgumentException("First step stored must be > 0: " + firstStepStored);
        }
        this.parameters.set("firstStepStored", (Object)firstStepStored);
        this.constructTimeSteps();
    }

    public int getInterval() {
        Objects.requireNonNull(this);
        return this.parameters.getInt("interval", 1);
    }

    public void setInterval(int interval) {
        if (interval <= 0) {
            throw new IllegalArgumentException("Interval must be > 0: " + interval);
        }
        this.parameters.set("interval", (Object)interval);
        this.constructTimeSteps();
    }

    public boolean isRawDataSaved() {
        boolean rawDataSaved = false;
        return this.parameters.getBoolean("rawDataSaved", rawDataSaved);
    }

    public void setRawDataSaved(boolean rawDataSaved) {
        this.parameters.set("rawDataSaved", (Object)rawDataSaved);
    }

    public boolean isMeasuredDataSaved() {
        boolean measuredDataSaved = true;
        return this.parameters.getBoolean("measuredDataSaved", measuredDataSaved);
    }

    public void setMeasuredDataSaved(boolean measuredDataSaved) {
        this.parameters.set("measuredDataSaved", (Object)measuredDataSaved);
    }

    public boolean isInitSync() {
        boolean initSync = true;
        return this.parameters.getBoolean("initSync", initSync);
    }

    public void setInitSync(boolean initSync) {
        this.parameters.set("initSync", (Object)initSync);
    }

    public boolean isAntilogCalculated() {
        boolean antilogCalculated = false;
        return this.parameters.getBoolean("antilogCalculated", antilogCalculated);
    }

    public void setAntilogCalculated(boolean antilogCalculated) {
        this.parameters.set("antilogCalculated", (Object)antilogCalculated);
    }

    public double getDishDishVariability() {
        return this.parameters.getDouble("dishDishVariability", this.dishDishVariability);
    }

    public void setDishDishVariability(double dishDishVariability) {
        if (!(dishDishVariability > 0.0) || !(dishDishVariability < 100.0)) {
            throw new IllegalArgumentException("Dish variability must be > 0.0 and < 100.0: " + dishDishVariability);
        }
        this.parameters.set("dishDishVariability", (Object)dishDishVariability);
    }

    public int getNumSamplesPerDish() {
        Objects.requireNonNull(this);
        return this.parameters.getInt("numChipsPerDish", 4);
    }

    public void setNumSamplesPerDish(int numSamplesPerDish) {
        if (numSamplesPerDish <= 0) {
            throw new IllegalArgumentException("Number of chips per dish must be > 0: " + numSamplesPerDish);
        }
        this.parameters.set("numChipsPerDish", (Object)numSamplesPerDish);
    }

    public double getSampleSampleVariability() {
        Objects.requireNonNull(this);
        return this.parameters.getDouble("sampleSampleVariability", 0.025);
    }

    public void setSampleSampleVariability(double sampleSampleVariability) {
        if (!(sampleSampleVariability > 0.0) || !(sampleSampleVariability < 1.0)) {
            throw new IllegalArgumentException("Sample variability must be > 0.0: " + sampleSampleVariability);
        }
        this.parameters.set("sampleSampleVariability", (Object)sampleSampleVariability);
    }

    public double getChipChipVariability() {
        return this.parameters.getDouble("chipChipVariability", this.chipChipVariability);
    }

    public void setChipChipVariability(double chipChipVariability) {
        if (!(chipChipVariability > 0.0) || !(chipChipVariability < 1.0)) {
            throw new IllegalArgumentException("Chip to chip variability must be > 0.0 and < 1.0: " + chipChipVariability);
        }
        this.parameters.set("chipChipVariability", (Object)chipChipVariability);
    }

    public double getPixelDigitalization() {
        Objects.requireNonNull(this);
        return this.parameters.getDouble("pixelDigitalization", 0.025);
    }

    public void setPixelDigitalization(double pixelDigitalization) {
        if (!(pixelDigitalization > 0.0) || !(pixelDigitalization < 1.0)) {
            throw new IllegalArgumentException("Pixel digitalization must be > 0.0 and < 1.0: " + pixelDigitalization);
        }
        this.parameters.set("pixelDigitalization", (Object)pixelDigitalization);
    }

    public double[][][] getRawData() {
        return this.rawData;
    }

    public double[][][] getMeasuredData() {
        return this.measuredData;
    }

    private void constructTimeSteps() {
        int numTimeSteps = (1 + this.getStepsGenerated() - this.getFirstStepStored()) / this.getInterval();
        this.timeSteps = new int[numTimeSteps];
        for (int i = 0; i < this.timeSteps.length; ++i) {
            this.timeSteps[i] = this.getFirstStepStored() + i * this.getInterval();
        }
    }

    public int[] getTimeSteps() {
        return this.timeSteps;
    }

    public int getDishNumber() {
        return this.dishNumber;
    }

    public int getCellNumber() {
        return this.cellNumber;
    }

    public void simulate(GeneHistory history) {
        int numSteps;
        this.setHistory(history);
        history.reset();
        UpdateFunction updateFunction = history.getUpdateFunction();
        int numFactors = updateFunction.getNumFactors();
        DishModel dishModel = new DishModel(this.getNumDishes(), this.getDishDishVariability());
        history.setInitSync(this.isInitSync());
        history.setDishModel(dishModel);
        int numChips = this.getNumSamplesPerDish();
        if (this.isMeasuredDataSaved()) {
            numSteps = this.timeSteps.length;
            int numSamples = this.getNumDishes() * numChips;
            this.measuredData = new double[numFactors][numSteps][numSamples];
        }
        this.rawData = null;
        if (this.isRawDataSaved()) {
            numSteps = this.timeSteps.length;
            int numCells = this.getNumDishes() * this.getNumCellsPerDish();
            this.rawData = new double[numFactors][numSteps][numCells];
        }
        double sampleSd = this.getSampleSampleVariability();
        double chipSd = this.getChipChipVariability();
        double pixelSd = this.getPixelDigitalization();
        Normal sampleErrorDist = new Normal(0.0, sampleSd);
        Normal chipErrorDist = new Normal(0.0, chipSd);
        Normal pixelErrorDist = new Normal(0.0, pixelSd);
        double[][] chipErrors = new double[this.getNumDishes()][numChips];
        double[][] sampleErrors = new double[this.getNumDishes()][numChips];
        for (int d = 0; d < this.getNumDishes(); ++d) {
            for (int ch = 0; ch < numChips; ++ch) {
                chipErrors[d][ch] = chipErrorDist.nextRandom();
                sampleErrors[d][ch] = sampleErrorDist.nextRandom();
            }
        }
        double[][] cellData = new double[this.timeSteps.length][numFactors];
        double[][] aggregation = new double[cellData.length][cellData[0].length];
        for (int d = 0; d < this.getNumDishes(); ++d) {
            int sIndex;
            dishModel.setDishNumber(d);
            for (sIndex = 0; sIndex < this.timeSteps.length; ++sIndex) {
                Arrays.fill(aggregation[sIndex], 0.0);
            }
            for (int c = 0; c < this.getNumCellsPerDish(); ++c) {
                if ((c + 1) % 50 == 0) {
                    this.dishNumber = d;
                    this.cellNumber = c;
                }
                for (int sIndex2 = 0; sIndex2 < this.timeSteps.length; ++sIndex2) {
                    Arrays.fill(cellData[sIndex2], 0.0);
                }
                history.initialize();
                int s = -1;
                int sIndex3 = 0;
                while (++s < this.getStepsGenerated()) {
                    if (s > 0) {
                        history.update();
                    }
                    if (s != this.timeSteps[sIndex3] - 1) continue;
                    double[][] historyArray = history.getHistoryArray();
                    for (int f = 0; f < numFactors; ++f) {
                        cellData[sIndex3][f] = historyArray[0][f];
                        if (this.isAntilogCalculated()) {
                            cellData[sIndex3][f] = FastMath.exp(cellData[sIndex3][f]);
                        }
                        if (!this.isRawDataSaved()) continue;
                        int row = d * this.getNumCellsPerDish() + c;
                        this.rawData[f][sIndex3][row] = cellData[sIndex3][f];
                    }
                    if (++sIndex3 < this.timeSteps.length) continue;
                    break;
                }
                for (int i = 0; i < cellData.length; ++i) {
                    for (int j = 0; j < cellData[0].length; ++j) {
                        double[] dArray = aggregation[i];
                        int n = j;
                        dArray[n] = dArray[n] + cellData[i][j];
                    }
                }
            }
            if (!this.isMeasuredDataSaved()) continue;
            for (sIndex = 0; sIndex < this.timeSteps.length; ++sIndex) {
                for (int f = 0; f < numFactors; ++f) {
                    for (int ch = 0; ch < numChips; ++ch) {
                        double measurement;
                        double average = aggregation[sIndex][f] / (double)this.getNumCellsPerDish();
                        double pixelError = pixelErrorDist.nextRandom();
                        this.measuredData[f][sIndex][d * numChips + ch] = measurement = average + sampleErrors[d][ch] + chipErrors[d][ch] + pixelError;
                    }
                }
            }
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        block18: {
            block17: {
                block16: {
                    block15: {
                        s.defaultReadObject();
                        if (this.timeSteps == null) {
                            throw new NullPointerException();
                        }
                        if (this.chipChipVariability <= 0.0 || this.chipChipVariability >= 1.0) {
                            throw new IllegalStateException();
                        }
                        Objects.requireNonNull(this);
                        if (0.025 <= 0.0) break block15;
                        Objects.requireNonNull(this);
                        if (!(0.025 >= 1.0)) break block16;
                    }
                    throw new IllegalStateException();
                }
                Objects.requireNonNull(this);
                if (0.025 <= 0.0) break block17;
                Objects.requireNonNull(this);
                if (!(0.025 >= 1.0)) break block18;
            }
            throw new IllegalStateException();
        }
        if (this.dishDishVariability <= 0.0 || this.dishDishVariability >= 100.0) {
            throw new IllegalStateException();
        }
        Objects.requireNonNull(this);
        if (1 <= 0) {
            throw new IllegalStateException();
        }
        if (this.numCellsPerDish <= 0) {
            throw new IllegalStateException();
        }
        Objects.requireNonNull(this);
        if (4 <= 0) {
            throw new IllegalStateException();
        }
        Objects.requireNonNull(this);
        if (1 <= 0) {
            throw new IllegalStateException();
        }
        Objects.requireNonNull(this);
        if (1 <= 0) {
            throw new IllegalStateException();
        }
        Objects.requireNonNull(this);
        if (4 <= 0) {
            throw new IllegalStateException();
        }
    }
}

