/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.study.gene.tetrad.gene.util;

import edu.cmu.tetrad.study.gene.tetrad.gene.history.BasicLagGraph;
import edu.cmu.tetrad.study.gene.tetrad.gene.history.LagGraph;
import edu.cmu.tetrad.study.gene.tetrad.gene.history.LaggedFactor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.StringTokenizer;

public class HandleyConvert {
    public static void main(String[] args) {
        if (args.length != 1) {
            throw new IllegalArgumentException("Expecting exactly one argument, the filename of the file to translate.");
        }
        try {
            File inFile = new File(args[0]);
            File outFile = new File(inFile.getName() + ".out");
            BufferedReader in = new BufferedReader(new FileReader(inFile));
            PrintStream out = new PrintStream(new FileOutputStream(outFile));
            new HandleyConvert().convert(in, out);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void convert(BufferedReader in, PrintStream out) {
        try {
            BasicLagGraph lagGraph = new BasicLagGraph();
            String line = null;
            while ((line = in.readLine()) != null) {
                this.addEdges(line, lagGraph);
            }
            out.print(lagGraph);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void addEdges(String line, LagGraph lagGraph) {
        StringTokenizer st = new StringTokenizer(line);
        String cause = st.nextToken();
        while (st.hasMoreTokens()) {
            String effect = st.nextToken();
            if (effect == "") continue;
            System.out.println(cause + " --> " + effect);
            lagGraph.addFactor(effect);
            lagGraph.addEdge(effect, new LaggedFactor(cause, 1));
        }
    }
}

