/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.study.performance;

import edu.cmu.tetrad.sem.ScoreType;
import edu.cmu.tetrad.study.performance.Comparison2;
import edu.cmu.tetrad.study.performance.ComparisonParameters;
import edu.cmu.tetrad.study.performance.ComparisonResult;
import edu.cmu.tetrad.util.TextTable;
import java.util.ArrayList;

public class ComparisonScript {
    public static void main(String ... args) {
        new ComparisonScript().runFromSimulation();
    }

    private void runFromSimulation() {
        ComparisonParameters params = new ComparisonParameters();
        params.setDataType(ComparisonParameters.DataType.Continuous);
        params.setNumVars(12);
        params.setNumEdges(12);
        int minSample = 100;
        int maxSample = 1000;
        int increment = 100;
        int numTrials = 2;
        params.setDataFromFile(false);
        int maxGraphs = 2;
        int dataSetsPerGraph = 3;
        params.setNoData(false);
        if (params.isDataFromFile() && params.isNoData()) {
            throw new IllegalArgumentException("Cannot have setDataFromFile and setNoData both be true!");
        }
        ArrayList<Comparison2.TableColumn> tableColumns = new ArrayList<Comparison2.TableColumn>();
        tableColumns.add(Comparison2.TableColumn.AdjPrec);
        tableColumns.add(Comparison2.TableColumn.AdjRec);
        tableColumns.add(Comparison2.TableColumn.AhdPrec);
        tableColumns.add(Comparison2.TableColumn.AhdRec);
        tableColumns.add(Comparison2.TableColumn.SHD);
        tableColumns.add(Comparison2.TableColumn.Elapsed);
        ArrayList<ComparisonParameters.Algorithm> algList = new ArrayList<ComparisonParameters.Algorithm>();
        algList.add(ComparisonParameters.Algorithm.SVARFCI);
        if (params.isDataFromFile()) {
            System.out.println("running algorithm on data from input files");
            minSample = 1;
            maxSample = 2;
            increment = 1;
            numTrials = 3;
        }
        if (params.isNoData()) {
            System.out.println("running algorithm on NO DATA, only true graph");
            minSample = 1;
            maxSample = 1;
            increment = 1;
        }
        int count = 0;
        TextTable avgTable = new TextTable(((maxSample - minSample) / increment + 1) * algList.size() + 2, tableColumns.size() + 1);
        for (int sampleSize = minSample; sampleSize <= maxSample; sampleSize += increment) {
            params.setSampleSize(sampleSize);
            if (params.isDataFromFile()) {
                params.setGraphNum(sampleSize);
                System.out.println("graph file number = " + sampleSize);
            } else {
                System.out.println("sample size = " + sampleSize);
            }
            for (ComparisonParameters.Algorithm alg : algList) {
                ++count;
                params.setAlgorithm(alg);
                params.setIndependenceTest(ComparisonParameters.IndependenceTestType.FisherZ);
                params.setScore(ScoreType.SemBic);
                ArrayList<ComparisonResult> resultsTrials = new ArrayList<ComparisonResult>();
                for (int trial = 1; trial <= numTrials; ++trial) {
                    params.setTrial(trial);
                    resultsTrials.add(Comparison2.compare(params));
                }
                TextTable tempTable = new TextTable(numTrials + 2, tableColumns.size() + 1);
                tempTable = Comparison2.summarize(resultsTrials, tableColumns);
                System.out.println(tempTable);
                for (int k = 0; k <= tempTable.getNumColumns() - 1; ++k) {
                    avgTable.setToken(count, k, tempTable.getTokenAt(tempTable.getNumRows() - 1, k));
                }
                if (params.isDataFromFile()) {
                    avgTable.setToken(count, 0, "G=" + sampleSize + ", alg = " + (Object)((Object)alg));
                    continue;
                }
                if (params.isNoData()) {
                    avgTable.setToken(count, 0, "N=0, alg = " + (Object)((Object)alg));
                    continue;
                }
                avgTable.setToken(count, 0, "N=" + sampleSize + ", alg = " + (Object)((Object)alg));
            }
        }
        for (int j = 0; j <= tableColumns.size() - 1; ++j) {
            avgTable.setToken(0, j, ((Comparison2.TableColumn)((Object)tableColumns.get(j))).toString());
        }
        System.out.println(avgTable);
    }
}

