/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.study.performance;

import edu.cmu.tetrad.sem.ScoreType;
import edu.cmu.tetrad.study.performance.Comparison;
import edu.cmu.tetrad.study.performance.ComparisonParameters;
import edu.cmu.tetrad.study.performance.ComparisonResult;
import java.util.ArrayList;

public class ExploreComparison {
    public static void main(String ... args) {
        new ExploreComparison().runFromSimulation();
    }

    private void runFromSimulation() {
        ComparisonParameters params = new ComparisonParameters();
        params.setDataType(ComparisonParameters.DataType.Continuous);
        params.setAlgorithm(ComparisonParameters.Algorithm.FGES2);
        params.setScore(ScoreType.SemBic);
        params.setNumVars(100);
        params.setNumEdges(100);
        params.setPenaltyDiscount(4.0);
        ArrayList<ComparisonResult> results = new ArrayList<ComparisonResult>();
        for (int sampleSize = 1000; sampleSize <= 1000; sampleSize += 100) {
            params.setSampleSize(sampleSize);
            results.add(Comparison.compare(params));
        }
        ArrayList<Comparison.TableColumn> tableColumns = new ArrayList<Comparison.TableColumn>();
        tableColumns.add(Comparison.TableColumn.AdjPrec);
        tableColumns.add(Comparison.TableColumn.AdjRec);
        tableColumns.add(Comparison.TableColumn.AhdPrec);
        tableColumns.add(Comparison.TableColumn.AhdRec);
        tableColumns.add(Comparison.TableColumn.SHD);
        tableColumns.add(Comparison.TableColumn.Elapsed);
        System.out.println(Comparison.summarize(results, tableColumns));
    }
}

