/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.study.performance;

import edu.cmu.tetrad.bayes.BayesPm;
import edu.cmu.tetrad.bayes.MlBayesIm;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataTransforms;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphTransforms;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.MisclassificationUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Paths;
import edu.cmu.tetrad.graph.RandomGraph;
import edu.cmu.tetrad.search.Cpc;
import edu.cmu.tetrad.search.Fci;
import edu.cmu.tetrad.search.Fges;
import edu.cmu.tetrad.search.FgesMb;
import edu.cmu.tetrad.search.GFci;
import edu.cmu.tetrad.search.Pc;
import edu.cmu.tetrad.search.score.BdeuScore;
import edu.cmu.tetrad.search.score.Score;
import edu.cmu.tetrad.search.score.SemBicScore;
import edu.cmu.tetrad.search.test.IndTestFisherZ;
import edu.cmu.tetrad.search.test.MsepTest;
import edu.cmu.tetrad.search.utils.GraphSearchUtils;
import edu.cmu.tetrad.sem.LargeScaleSimulation;
import edu.cmu.tetrad.util.MillisecondTimes;
import edu.cmu.tetrad.util.RandomUtil;
import edu.cmu.tetrad.util.TextTable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.junit.Test;

public class PerformanceTests {
    private PrintStream out = System.out;

    public static String endpointMisclassification(List<Node> _nodes, Graph estGraph, Graph refGraph) {
        int i;
        int[][] counts = new int[4][4];
        for (int i2 = 0; i2 < _nodes.size(); ++i2) {
            for (int j = 0; j < _nodes.size(); ++j) {
                if (i2 == j) continue;
                Endpoint endpoint1 = refGraph.getEndpoint(_nodes.get(i2), _nodes.get(j));
                Endpoint endpoint2 = estGraph.getEndpoint(_nodes.get(i2), _nodes.get(j));
                int index1 = PerformanceTests.getIndex(endpoint1);
                int index2 = PerformanceTests.getIndex(endpoint2);
                int[] nArray = counts[index1];
                int n = index2;
                nArray[n] = nArray[n] + 1;
            }
        }
        TextTable table2 = new TextTable(5, 5);
        table2.setToken(0, 1, "-o");
        table2.setToken(0, 2, "->");
        table2.setToken(0, 3, "--");
        table2.setToken(0, 4, "NO EDGE");
        table2.setToken(1, 0, "-o");
        table2.setToken(2, 0, "->");
        table2.setToken(3, 0, "--");
        table2.setToken(4, 0, "NO EDGE");
        int sum = 0;
        for (i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                if (i == 3 && j == 3) continue;
                sum += counts[i][j];
            }
        }
        for (i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                if (i == 3 && j == 3) {
                    table2.setToken(4, 4, "");
                    continue;
                }
                table2.setToken(i + 1, j + 1, "" + counts[i][j]);
            }
        }
        return table2.toString();
    }

    private static int getIndex(Endpoint endpoint) {
        if (endpoint == Endpoint.CIRCLE) {
            return 0;
        }
        if (endpoint == Endpoint.ARROW) {
            return 1;
        }
        if (endpoint == Endpoint.TAIL) {
            return 2;
        }
        if (endpoint == null) {
            return 3;
        }
        throw new IllegalArgumentException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String ... args) {
        System.out.println("Start ");
        PerformanceTests performanceTests = new PerformanceTests();
        if (args.length == 3) {
            if (!"GFCI".equals(args[0])) throw new IllegalArgumentException("Not a configuration!");
            int numVars = Integer.parseInt(args[1]);
            double edgeFactor = Double.parseDouble(args[2]);
            performanceTests.testGfci(numVars, edgeFactor);
        } else if (args.length == 5) {
            switch (args[0]) {
                case "PC": {
                    int numVars = Integer.parseInt(args[1]);
                    double edgeFactor = Double.parseDouble(args[2]);
                    int numCases = Integer.parseInt(args[3]);
                    double alpha = Double.parseDouble(args[4]);
                    performanceTests.testPc(numVars, edgeFactor, numCases, alpha);
                    break;
                }
                case "PCSTABLE": {
                    int numVars = Integer.parseInt(args[1]);
                    double edgeFactor = Double.parseDouble(args[2]);
                    int numCases = Integer.parseInt(args[3]);
                    double alpha = Double.parseDouble(args[4]);
                    performanceTests.testPcStable(numVars, edgeFactor, numCases, alpha);
                    break;
                }
                case "CPCSTABLE": {
                    int numVars = Integer.parseInt(args[1]);
                    double edgeFactor = Double.parseDouble(args[2]);
                    int numCases = Integer.parseInt(args[3]);
                    double alpha = Double.parseDouble(args[4]);
                    performanceTests.testCpcStable(numVars, edgeFactor, numCases, alpha);
                    break;
                }
                case "TestFgesComparisonContinuous": {
                    int numVars = Integer.parseInt(args[1]);
                    double edgeFactor = Double.parseDouble(args[2]);
                    int numCases = Integer.parseInt(args[3]);
                    int numRuns = Integer.parseInt(args[4]);
                    performanceTests.testFgesComparisonContinuous(numVars, edgeFactor, numCases, numRuns);
                    break;
                }
                case "TestFgesComparisonDiscrete": {
                    int numVars = Integer.parseInt(args[1]);
                    double edgeFactor = Double.parseDouble(args[2]);
                    int numCases = Integer.parseInt(args[3]);
                    int numRuns = Integer.parseInt(args[4]);
                    performanceTests.testFgesComparisonDiscrete(numVars, edgeFactor, numCases, numRuns);
                    break;
                }
                case "TestFgesMbComparisonContinuous": {
                    int numVars = Integer.parseInt(args[1]);
                    double edgeFactor = Double.parseDouble(args[2]);
                    int numCases = Integer.parseInt(args[3]);
                    int numRuns = Integer.parseInt(args[4]);
                    performanceTests.testFgesMbComparisonContinuous(numVars, edgeFactor, numCases, numRuns);
                    break;
                }
                case "TestFgesMbComparisonDiscrete": {
                    int numVars = Integer.parseInt(args[1]);
                    double edgeFactor = Double.parseDouble(args[2]);
                    int numCases = Integer.parseInt(args[3]);
                    int numRuns = Integer.parseInt(args[4]);
                    performanceTests.testFgesMbComparisonDiscrete(numVars, edgeFactor, numCases, numRuns);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Not a configuration.");
                }
            }
        } else if (args.length == 6) {
            throw new IllegalArgumentException("Not a configuration.");
        }
        System.out.println("Finish");
        performanceTests.testPc(5000, 1.0, 1000, 1.0E-4);
    }

    public void testPc(int numVars, double edgeFactor, int numCases, double alpha) {
        int depth = -1;
        this.init(new File("long.pc." + numVars + "." + edgeFactor + "." + alpha + ".txt"), "Tests performance of the PC algorithm");
        long time1 = MillisecondTimes.timeMillis();
        System.out.println("Making list of vars");
        ArrayList<Node> vars = new ArrayList<Node>();
        for (int i = 0; i < numVars; ++i) {
            vars.add(new ContinuousVariable("X" + i));
        }
        System.out.println("Finishing list of vars");
        System.out.println("Making graph");
        Graph graph = RandomGraph.randomGraphRandomForwardEdges(vars, 0, (int)((double)numVars * edgeFactor), 30, 15, 15, false, true);
        System.out.println("Graph done");
        this.out.println("Graph done");
        System.out.println("Starting simulation");
        LargeScaleSimulation simulator = new LargeScaleSimulation(graph);
        simulator.setOut(this.out);
        DataSet data = simulator.simulateDataFisher(numCases);
        System.out.println("Finishing simulation");
        long time2 = MillisecondTimes.timeMillis();
        this.out.println("Elapsed (simulating the data): " + (time2 - time1) + " ms");
        System.out.println("Making covariance matrix");
        CovarianceMatrix cov = new CovarianceMatrix(data);
        System.gc();
        System.out.println("Covariance matrix done");
        long time3 = MillisecondTimes.timeMillis();
        this.out.println("Elapsed (calculating cov): " + (time3 - time2) + " ms");
        IndTestFisherZ test = new IndTestFisherZ(cov, alpha);
        Pc pc = new Pc(test);
        pc.setVerbose(false);
        pc.setDepth(-1);
        Graph outGraph = pc.search();
        this.out.println(outGraph);
        long time4 = MillisecondTimes.timeMillis();
        this.out.println("# Vars = " + numVars);
        this.out.println("# Edges = " + (int)((double)numVars * edgeFactor));
        this.out.println("# Cases = " + numCases);
        this.out.println("Elapsed (simulating the data): " + (time2 - time1) + " ms");
        this.out.println("Elapsed (calculating cov): " + (time3 - time2) + " ms");
        this.out.println("Elapsed (running PC-Stable) " + (time4 - time3) + " ms");
        this.out.println("Total elapsed (cov + PC-Stable) " + (time4 - time2) + " ms");
        GraphSearchUtils.graphComparison(GraphTransforms.cpdagForDag(graph), outGraph, this.out);
        this.out.close();
    }

    public void printStuffForKlea() {
        try {
            File _data = new File("data.txt");
            File _graph = new File("graph.txt");
            PrintStream out1 = new PrintStream(new FileOutputStream(_data));
            PrintStream out2 = new PrintStream(new FileOutputStream(_graph));
            int numVars = 50000;
            ArrayList<Node> vars = new ArrayList<Node>();
            for (int i = 0; i < 50000; ++i) {
                vars.add(new ContinuousVariable("X" + (i + 1)));
            }
            double edgeFactor = 1.0;
            int numCases = 1000;
            Graph graph = RandomGraph.randomGraphRandomForwardEdges(vars, 0, 50000, 30, 15, 15, false, true);
            out2.println(graph);
            System.out.println("Graph done");
            this.out.println("Graph done");
            System.out.println("Starting simulation");
            LargeScaleSimulation simulator = new LargeScaleSimulation(graph);
            simulator.setOut(this.out);
            DataSet data = simulator.simulateDataFisher(1000);
            out1.println(data);
            out1.close();
            out2.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void testPcStable(int numVars, double edgeFactor, int numCases, double alpha) {
        int depth = -1;
        this.init(new File("long.pcstable." + numVars + "." + edgeFactor + "." + alpha + ".txt"), "Tests performance of the PC Stable algorithm");
        long time1 = MillisecondTimes.timeMillis();
        Graph dag = this.makeDag(numVars, edgeFactor);
        System.out.println("Graph done");
        this.out.println("Graph done");
        System.out.println("Starting simulation");
        LargeScaleSimulation simulator = new LargeScaleSimulation(dag);
        simulator.setOut(this.out);
        DataSet data = simulator.simulateDataFisher(numCases);
        System.out.println("Finishing simulation");
        long time2 = MillisecondTimes.timeMillis();
        this.out.println("Elapsed (simulating the data): " + (time2 - time1) + " ms");
        System.out.println("Making covariance matrix");
        CovarianceMatrix cov = new CovarianceMatrix(data);
        System.out.println("Covariance matrix done");
        long time3 = MillisecondTimes.timeMillis();
        this.out.println("Elapsed (calculating cov): " + (time3 - time2) + " ms");
        IndTestFisherZ test = new IndTestFisherZ(cov, alpha);
        Pc pc = new Pc(test);
        pc.setStable(true);
        Graph estCPDAG = pc.search();
        long time4 = MillisecondTimes.timeMillis();
        this.out.println("# Cases = " + numCases);
        this.out.println("alpha = " + alpha);
        this.out.println("depth = -1");
        this.out.println("Elapsed (simulating the data): " + (time2 - time1) + " ms");
        this.out.println("Elapsed (calculating cov): " + (time3 - time2) + " ms");
        this.out.println("Elapsed (running PC-Stable) " + (time4 - time3) + " ms");
        this.out.println("Total elapsed (cov + PC-Stable) " + (time4 - time2) + " ms");
        Graph trueCPDAG = GraphTransforms.cpdagForDag(dag);
        System.out.println("# edges in true CPDAG = " + trueCPDAG.getNumEdges());
        System.out.println("# edges in est CPDAG = " + estCPDAG.getNumEdges());
        GraphSearchUtils.graphComparison(trueCPDAG, estCPDAG, this.out);
        this.out.close();
    }

    public void testFges(int numVars, double edgeFactor, int numCases, double penaltyDiscount) {
        this.init(new File("long.fges." + numVars + "." + edgeFactor + "." + penaltyDiscount + ".txt"), "Tests performance of the FGES algorithm");
        long time1 = MillisecondTimes.timeMillis();
        Graph dag = this.makeDag(numVars, edgeFactor);
        System.out.println("Graph done");
        this.out.println("Graph done");
        System.out.println("Starting simulation");
        LargeScaleSimulation simulator = new LargeScaleSimulation(dag);
        simulator.setOut(this.out);
        DataSet data = simulator.simulateDataFisher(numCases);
        System.out.println("Finishing simulation");
        long time2 = MillisecondTimes.timeMillis();
        this.out.println("Elapsed (simulating the data): " + (time2 - time1) + " ms");
        System.out.println("Making covariance matrix");
        CovarianceMatrix cov = new CovarianceMatrix(data);
        System.out.println("Covariance matrix done");
        long time3 = MillisecondTimes.timeMillis();
        this.out.println("Elapsed (calculating cov): " + (time3 - time2) + " ms");
        SemBicScore semBicScore = new SemBicScore(cov);
        semBicScore.setPenaltyDiscount(penaltyDiscount);
        Fges pcStable = new Fges(semBicScore);
        Graph estCPDAG = pcStable.search();
        long time4 = MillisecondTimes.timeMillis();
        this.out.println("# Cases = " + numCases);
        this.out.println("penalty discount = " + penaltyDiscount);
        this.out.println("Elapsed (simulating the data): " + (time2 - time1) + " ms");
        this.out.println("Elapsed (calculating cov): " + (time3 - time2) + " ms");
        this.out.println("Elapsed (running FGES) " + (time4 - time3) + " ms");
        this.out.println("Total elapsed (cov + FGES) " + (time4 - time2) + " ms");
        Graph trueCPDAG = GraphTransforms.cpdagForDag(dag);
        System.out.println("# edges in true CPDAG = " + trueCPDAG.getNumEdges());
        System.out.println("# edges in est CPDAG = " + estCPDAG.getNumEdges());
        GraphSearchUtils.graphComparison(trueCPDAG, estCPDAG, this.out);
        this.out.close();
    }

    public void testCpc(int numVars, double edgeFactor, int numCases) {
        double alpha = 1.0E-4;
        int depth = -1;
        this.init(new File("long.cpc." + numVars + ".txt"), "Tests performance of the CPC algorithm");
        long time1 = MillisecondTimes.timeMillis();
        System.out.println("Making list of vars");
        ArrayList<Node> vars = new ArrayList<Node>();
        for (int i = 0; i < numVars; ++i) {
            vars.add(new ContinuousVariable("X" + i));
        }
        System.out.println("Finishing list of vars");
        System.out.println("Making graph");
        Graph graph = RandomGraph.randomGraphRandomForwardEdges(vars, 0, (int)((double)numVars * edgeFactor), 30, 15, 15, false, true);
        System.out.println("Graph done");
        this.out.println("Graph done");
        System.out.println("Starting simulation");
        LargeScaleSimulation simulator = new LargeScaleSimulation(graph);
        simulator.setOut(this.out);
        DataSet data = simulator.simulateDataFisher(numCases);
        System.out.println("Finishing simulation");
        long time2 = MillisecondTimes.timeMillis();
        this.out.println("Elapsed (simulating the data): " + (time2 - time1) + " ms");
        System.out.println("Making covariance matrix");
        CovarianceMatrix cov = new CovarianceMatrix(data);
        System.gc();
        System.out.println("Covariance matrix done");
        long time3 = MillisecondTimes.timeMillis();
        this.out.println("Elapsed (calculating cov): " + (time3 - time2) + " ms");
        IndTestFisherZ test = new IndTestFisherZ(cov, 1.0E-4);
        Cpc cpc = new Cpc(test);
        cpc.setVerbose(false);
        cpc.setDepth(-1);
        Graph outGraph = cpc.search();
        this.out.println(outGraph);
        long time4 = MillisecondTimes.timeMillis();
        this.out.println("# Vars = " + numVars);
        this.out.println("# Edges = " + (int)((double)numVars * edgeFactor));
        this.out.println("# Cases = " + numCases);
        this.out.println("Elapsed (simulating the data): " + (time2 - time1) + " ms");
        this.out.println("Elapsed (calculating cov): " + (time3 - time2) + " ms");
        this.out.println("Elapsed (running PC-Stable) " + (time4 - time3) + " ms");
        this.out.println("Total elapsed (cov + PC-Stable) " + (time4 - time2) + " ms");
        GraphSearchUtils.graphComparison(GraphTransforms.cpdagForDag(graph), outGraph, this.out);
        this.out.close();
    }

    public void testCpcStable(int numVars, double edgeFactor, int numCases, double alpha) {
        int depth = 3;
        this.init(new File("long.cpcstable." + numVars + ".txt"), "Tests performance of the CPC algorithm");
        long time1 = MillisecondTimes.timeMillis();
        System.out.println("Making list of vars");
        System.out.println("Finishing list of vars");
        System.out.println("Making graph");
        Graph graph = this.makeDag(numVars, edgeFactor);
        System.out.println("Graph done");
        this.out.println("Graph done");
        System.out.println("Starting simulation");
        LargeScaleSimulation simulator = new LargeScaleSimulation(graph);
        simulator.setOut(this.out);
        DataSet data = simulator.simulateDataFisher(numCases);
        System.out.println("Finishing simulation");
        long time2 = MillisecondTimes.timeMillis();
        this.out.println("Elapsed (simulating the data): " + (time2 - time1) + " ms");
        System.out.println("Making covariance matrix");
        CovarianceMatrix cov = new CovarianceMatrix(data);
        System.out.println("Covariance matrix done");
        long time3 = MillisecondTimes.timeMillis();
        this.out.println("Elapsed (calculating cov): " + (time3 - time2) + " ms");
        IndTestFisherZ test = new IndTestFisherZ(cov, alpha);
        Cpc cpcStable = new Cpc(test);
        cpcStable.setStable(true);
        cpcStable.setVerbose(false);
        cpcStable.setDepth(3);
        Graph outGraph = cpcStable.search();
        long time4 = MillisecondTimes.timeMillis();
        this.out.println("# Cases = " + numCases);
        this.out.println("Elapsed (simulating the data): " + (time2 - time1) + " ms");
        this.out.println("Elapsed (calculating cov): " + (time3 - time2) + " ms");
        this.out.println("Elapsed (running CPC-Stable) " + (time4 - time3) + " ms");
        this.out.println("Total elapsed (cov + CPC-Stable) " + (time4 - time2) + " ms");
        Graph trueCPDAG = GraphTransforms.cpdagForDag(graph);
        GraphSearchUtils.graphComparison(trueCPDAG, outGraph, this.out);
        this.out.println("# ambiguous triples = " + outGraph.getAmbiguousTriples().size());
        this.out.close();
    }

    public void testFci(int numVars, double edgeFactor, int numCases) {
        double alpha = 0.001;
        int depth = 3;
        this.init(new File("long.fci." + numVars + ".txt"), "Tests performance of the FCI algorithm");
        long time1 = MillisecondTimes.timeMillis();
        System.out.println("Making list of vars");
        ArrayList<Node> vars = new ArrayList<Node>();
        for (int i = 0; i < numVars; ++i) {
            vars.add(new ContinuousVariable("X" + i));
        }
        System.out.println("Finishing list of vars");
        System.out.println("Making graph");
        Graph graph = RandomGraph.randomGraphRandomForwardEdges(vars, 0, (int)((double)numVars * edgeFactor), 30, 15, 15, false, true);
        System.out.println("Graph done");
        this.out.println("Graph done");
        System.out.println("Starting simulation");
        LargeScaleSimulation simulator = new LargeScaleSimulation(graph);
        simulator.setOut(this.out);
        DataSet data = simulator.simulateDataFisher(numCases);
        System.out.println("Finishing simulation");
        long time2 = MillisecondTimes.timeMillis();
        this.out.println("Elapsed (simulating the data): " + (time2 - time1) + " ms");
        System.out.println("Making covariance matrix");
        CovarianceMatrix cov = new CovarianceMatrix(data);
        System.out.println("Covariance matrix done");
        long time3 = MillisecondTimes.timeMillis();
        this.out.println("Elapsed (calculating cov): " + (time3 - time2) + " ms");
        IndTestFisherZ independenceTest = new IndTestFisherZ(cov, 0.001);
        Fci fci = new Fci(independenceTest);
        fci.setVerbose(false);
        fci.setDepth(3);
        fci.setMaxPathLength(2);
        Graph outGraph = fci.search();
        this.out.println(outGraph);
        long time4 = MillisecondTimes.timeMillis();
        this.out.println("# Vars = " + numVars);
        this.out.println("# Edges = " + (int)((double)numVars * edgeFactor));
        this.out.println("# Cases = " + numCases);
        this.out.println("Elapsed (simulating the data): " + (time2 - time1) + " ms");
        this.out.println("Elapsed (calculating cov): " + (time3 - time2) + " ms");
        this.out.println("Elapsed (running FCI) " + (time4 - time3) + " ms");
        this.out.close();
    }

    public void testGfci(int numVars, double edgeFactor) {
        double alpha = 0.1;
        int depth = -1;
        double penaltyDiscount = 4.0;
        int maxPathLength = -1;
        double coefLow = 0.3;
        double coefHigh = 1.5;
        int numLatentConfounders = 50;
        int numCases = 1000;
        this.init(new File("long.gfci." + numVars + ".txt"), "Tests performance of the FCI-GES algorithm");
        long time1 = MillisecondTimes.timeMillis();
        System.out.println("Making list of vars");
        ArrayList<Node> vars = new ArrayList<Node>();
        for (int i = 0; i < numVars; ++i) {
            vars.add(new ContinuousVariable("X" + i));
        }
        System.out.println("Finishing list of vars");
        System.out.println("Making graph");
        System.out.println("Finishing list of vars");
        Graph dag = RandomGraph.randomGraphRandomForwardEdges(vars, 50, (int)((double)numVars * edgeFactor), 10, 10, 10, false, false);
        System.out.println("Graph done");
        this.out.println("Graph done");
        System.out.println("Starting simulation");
        LargeScaleSimulation simulator = new LargeScaleSimulation(dag);
        simulator.setCoefRange(0.3, 1.5);
        DataSet data = simulator.simulateDataFisher(1000);
        data = DataTransforms.restrictToMeasured(data);
        System.out.println("Finishing simulation");
        System.out.println("Num measured vars = " + data.getNumColumns());
        long time2 = MillisecondTimes.timeMillis();
        this.out.println("Elapsed (simulating the data): " + (time2 - time1) + " ms");
        System.out.println("Making covariance matrix");
        CovarianceMatrix cov = new CovarianceMatrix(data);
        System.out.println("Covariance matrix done");
        long time3 = MillisecondTimes.timeMillis();
        this.out.println("Elapsed (calculating cov): " + (time3 - time2) + " ms");
        IndTestFisherZ independenceTest = new IndTestFisherZ(cov, 0.1);
        SemBicScore score = new SemBicScore(cov);
        score.setPenaltyDiscount(4.0);
        GFci fci = new GFci(independenceTest, score);
        fci.setVerbose(false);
        fci.setMaxPathLength(-1);
        fci.setMaxDegree(-1);
        fci.setFaithfulnessAssumed(true);
        fci.setCompleteRuleSetUsed(true);
        Graph outGraph = fci.search();
        this.out.println(outGraph);
        System.out.println(MisclassificationUtils.edgeMisclassifications(outGraph, GraphTransforms.dagToPag(dag)));
        long time4 = MillisecondTimes.timeMillis();
        this.out.println("# Vars = " + numVars);
        this.out.println("# Edges = " + (int)((double)numVars * edgeFactor));
        this.out.println("# Cases = 1000");
        this.out.println("Elapsed (simulating the data): " + (time2 - time1) + " ms");
        this.out.println("Elapsed (calculating cov): " + (time3 - time2) + " ms");
        this.out.println("Elapsed (running FCI) " + (time4 - time3) + " ms");
        this.out.close();
    }

    public void testFgesComparisonContinuous(int numVars, double edgeFactor, int numCases, int numRuns) {
        this.testFges(numVars, edgeFactor, numCases, numRuns, true);
    }

    public void testFgesComparisonDiscrete(int numVars, double edgeFactor, int numCases, int numRuns) {
        this.testFges(numVars, edgeFactor, numCases, numRuns, false);
    }

    private void testFges(int numVars, double edgeFactor, int numCases, int numRuns, boolean continuous) {
        this.out.println(new Date());
        double penaltyDiscount = 4.0;
        int maxIndegree = 5;
        ArrayList<int[][]> allCounts = new ArrayList<int[][]>();
        ArrayList<double[]> comparisons = new ArrayList<double[]>();
        ArrayList<Double> degrees = new ArrayList<Double>();
        ArrayList<Long> elapsedTimes = new ArrayList<Long>();
        if (continuous) {
            this.init(new File("fges.comparison.continuous" + numVars + "." + (int)(edgeFactor * (double)numVars) + "." + numCases + "." + numRuns + ".txt"), "Num runs = " + numRuns);
            this.out.println("Num vars = " + numVars);
            this.out.println("Num edges = " + (int)((double)numVars * edgeFactor));
            this.out.println("Num cases = " + numCases);
            this.out.println("Penalty discount = 4.0");
            this.out.println("Depth = 5");
            this.out.println();
        } else {
            this.init(new File("fges.comparison.discrete" + numVars + "." + (int)(edgeFactor * (double)numVars) + "." + numCases + "." + numRuns + ".txt"), "Num runs = " + numRuns);
            this.out.println("Num vars = " + numVars);
            this.out.println("Num edges = " + (int)((double)numVars * edgeFactor));
            this.out.println("Num cases = " + numCases);
            this.out.println("Sample prior = 1");
            this.out.println("Structure prior = 1");
            this.out.println("Depth = 1");
            this.out.println();
        }
        for (int run = 0; run < numRuns; ++run) {
            long elapsed;
            long timec;
            Graph estCPDAG;
            long timeb;
            Fges fges;
            long timea;
            Score score;
            this.out.println("\n\n\n******************************** RUN " + (run + 1) + " ********************************\n\n");
            System.out.println("Making dag");
            this.out.println(new Date());
            Graph dag = this.makeDag(numVars, edgeFactor);
            System.out.println(new Date());
            System.out.println("Calculating CPDAG for DAG");
            Graph CPDAG = GraphTransforms.cpdagForDag(dag);
            List<Node> vars = dag.getNodes();
            int[] tiers = new int[vars.size()];
            for (int i = 0; i < vars.size(); ++i) {
                tiers[i] = i;
            }
            System.out.println("Graph done");
            long time1 = MillisecondTimes.timeMillis();
            this.out.println("Graph done");
            System.out.println(new Date());
            System.out.println("Starting simulation");
            if (continuous) {
                LargeScaleSimulation simulator = new LargeScaleSimulation(dag, vars, tiers);
                simulator.setVerbose(false);
                simulator.setOut(this.out);
                DataSet data = simulator.simulateDataFisher(numCases);
                System.out.println("Finishing simulation");
                System.out.println(new Date());
                long time2 = MillisecondTimes.timeMillis();
                this.out.println("Elapsed (simulating the data): " + (time2 - time1) + " ms");
                System.out.println(new Date());
                System.out.println("Making covariance matrix");
                long time3 = MillisecondTimes.timeMillis();
                CovarianceMatrix cov = new CovarianceMatrix(data);
                System.out.println("Covariance matrix done");
                this.out.println("Elapsed (calculating cov): " + (time3 - time2) + " ms\n");
                score = new SemBicScore(cov);
                ((SemBicScore)score).setPenaltyDiscount(4.0);
                System.out.println(new Date());
                System.out.println("\nStarting FGES");
                timea = MillisecondTimes.timeMillis();
                fges = new Fges(score);
                fges.setOut(System.out);
                timeb = MillisecondTimes.timeMillis();
                estCPDAG = fges.search();
                timec = MillisecondTimes.timeMillis();
                this.out.println("Time for FGES constructor " + (timeb - timea) + " ms");
                this.out.println("Time for FGES search " + (timec - timea) + " ms");
                this.out.println();
                this.out.flush();
                elapsed = timec - timea;
            } else {
                BayesPm pm = new BayesPm(dag, 3, 3);
                MlBayesIm im = new MlBayesIm(pm, 1);
                DataSet data = im.simulateData(numCases, false, tiers);
                System.out.println("Finishing simulation");
                long time2 = MillisecondTimes.timeMillis();
                this.out.println("Elapsed (simulating the data): " + (time2 - time1) + " ms");
                long time3 = MillisecondTimes.timeMillis();
                score = new BdeuScore(data);
                ((BdeuScore)score).setStructurePrior(1.0);
                ((BdeuScore)score).setSamplePrior(1.0);
                System.out.println(new Date());
                System.out.println("\nStarting FGES");
                timea = MillisecondTimes.timeMillis();
                fges = new Fges(score);
                fges.setOut(System.out);
                timeb = MillisecondTimes.timeMillis();
                estCPDAG = fges.search();
                timec = MillisecondTimes.timeMillis();
                this.out.println("Time consructing BDeu score " + (timea - time3) + " ms");
                this.out.println("Time for FGES constructor " + (timeb - timea) + " ms");
                this.out.println("Time for FGES search " + (timec - timea) + " ms");
                this.out.println();
                elapsed = timec - timea;
            }
            System.out.println("Done with FGES");
            System.out.println(new Date());
            double[] comparison = new double[4];
            System.out.println("Counting misclassifications.");
            estCPDAG = GraphUtils.replaceNodes(estCPDAG, CPDAG.getNodes());
            int[][] counts = GraphUtils.edgeMisclassificationCounts(CPDAG, estCPDAG, false);
            allCounts.add(counts);
            System.out.println(new Date());
            int sumRow = counts[4][0] + counts[4][3] + counts[4][5];
            int sumCol = counts[0][3] + counts[4][3] + counts[5][3] + counts[7][3];
            int trueArrow = counts[4][3];
            int sumTrueAdjacencies = 0;
            for (int i = 0; i < 7; ++i) {
                for (int j = 0; j < 5; ++j) {
                    sumTrueAdjacencies += counts[i][j];
                }
            }
            int falsePositiveAdjacencies = 0;
            for (int j = 0; j < 5; ++j) {
                falsePositiveAdjacencies += counts[7][j];
            }
            int falseNegativeAdjacencies = 0;
            for (int i = 0; i < 5; ++i) {
                falseNegativeAdjacencies += counts[i][5];
            }
            comparison[0] = (double)sumTrueAdjacencies / (double)(sumTrueAdjacencies + falsePositiveAdjacencies);
            comparison[1] = (double)sumTrueAdjacencies / (double)(sumTrueAdjacencies + falseNegativeAdjacencies);
            comparison[2] = (double)trueArrow / (double)sumCol;
            comparison[3] = (double)trueArrow / (double)sumRow;
            comparisons.add(comparison);
            this.out.println(GraphUtils.edgeMisclassifications(counts));
            this.out.println(this.precisionRecall(comparison));
            elapsedTimes.add(elapsed);
            this.out.println("\nElapsed: " + elapsed + " ms");
        }
        this.printAverageConfusion(allCounts);
        this.printAveragePrecisionRecall(comparisons);
        this.printAverageStatistics(elapsedTimes, degrees);
        this.out.close();
    }

    public void testFgesMbComparisonContinuous(int numVars, double edgeFactor, int numCases, int numRuns) {
        this.testFgesMb(numVars, edgeFactor, numCases, numRuns, true);
    }

    public void testFgesMbComparisonDiscrete(int numVars, double edgeFactor, int numCases, int numRuns) {
        this.testFgesMb(numVars, edgeFactor, numCases, numRuns, false);
    }

    private void testFgesMb(int numVars, double edgeFactor, int numCases, int numRuns, boolean continuous) {
        FgesMb fges;
        Score score;
        List<Node> vars;
        double penaltyDiscount = 4.0;
        int structurePrior = 10;
        int samplePrior = 10;
        int maxIndegree = -1;
        ArrayList<int[][]> allCounts = new ArrayList<int[][]>();
        ArrayList<double[]> comparisons = new ArrayList<double[]>();
        ArrayList<Double> degrees = new ArrayList<Double>();
        ArrayList<Long> elapsedTimes = new ArrayList<Long>();
        System.out.println("Making dag");
        Graph dag = this.makeDag(numVars, edgeFactor);
        System.out.println(new Date());
        System.out.println("Calculating CPDAG for DAG");
        Graph CPDAG = GraphTransforms.cpdagForDag(dag);
        int[] tiers = new int[dag.getNumNodes()];
        for (int i = 0; i < dag.getNumNodes(); ++i) {
            tiers[i] = i;
        }
        System.out.println("Graph done");
        long time1 = MillisecondTimes.timeMillis();
        this.out.println("Graph done");
        System.out.println(new Date());
        System.out.println("Starting simulation");
        if (continuous) {
            this.init(new File("FgesMb.comparison.continuous" + numVars + "." + (int)(edgeFactor * (double)numVars) + "." + numCases + "." + numRuns + ".txt"), "Num runs = " + numRuns);
            this.out.println("Num vars = " + numVars);
            this.out.println("Num edges = " + (int)((double)numVars * edgeFactor));
            this.out.println("Num cases = " + numCases);
            this.out.println("Penalty discount = 4.0");
            this.out.println("Depth = -1");
            this.out.println();
            this.out.println(new Date());
            vars = dag.getNodes();
            LargeScaleSimulation simulator = new LargeScaleSimulation(dag, vars, tiers);
            simulator.setVerbose(false);
            simulator.setOut(this.out);
            DataSet data = simulator.simulateDataFisher(numCases);
            System.out.println("Finishing simulation");
            System.out.println(new Date());
            long time2 = MillisecondTimes.timeMillis();
            this.out.println("Elapsed (simulating the data): " + (time2 - time1) + " ms");
            System.out.println(new Date());
            System.out.println("Making covariance matrix");
            long time3 = MillisecondTimes.timeMillis();
            CovarianceMatrix cov = new CovarianceMatrix(data);
            System.out.println("Covariance matrix done");
            this.out.println("Elapsed (calculating cov): " + (time3 - time2) + " ms\n");
            score = new SemBicScore(cov);
            ((SemBicScore)score).setPenaltyDiscount(4.0);
            System.out.println(new Date());
            System.out.println("\nStarting FGES-MB");
            fges = new FgesMb(score);
            fges.setVerbose(false);
            fges.setOut(System.out);
            fges.setMaxDegree(-1);
        } else {
            this.init(new File("FgesMb.comparison.discrete" + numVars + "." + (int)(edgeFactor * (double)numVars) + "." + numCases + "." + numRuns + ".txt"), "Num runs = " + numRuns);
            this.out.println("Num vars = " + numVars);
            this.out.println("Num edges = " + (int)((double)numVars * edgeFactor));
            this.out.println("Num cases = " + numCases);
            this.out.println("Sample prior = 10");
            this.out.println("Structure prior = 10");
            this.out.println("Depth = -1");
            this.out.println();
            this.out.println(new Date());
            BayesPm pm = new BayesPm(dag, 3, 3);
            MlBayesIm im = new MlBayesIm(pm, 1);
            DataSet data = im.simulateData(numCases, false, tiers);
            vars = data.getVariables();
            CPDAG = GraphUtils.replaceNodes(CPDAG, vars);
            System.out.println("Finishing simulation");
            long time2 = MillisecondTimes.timeMillis();
            this.out.println("Elapsed (simulating the data): " + (time2 - time1) + " ms");
            long time3 = MillisecondTimes.timeMillis();
            score = new BdeuScore(data);
            ((BdeuScore)score).setStructurePrior(10.0);
            ((BdeuScore)score).setSamplePrior(10.0);
            System.out.println(new Date());
            System.out.println("\nStarting FGES");
            long time4 = MillisecondTimes.timeMillis();
            fges = new FgesMb(score);
            fges.setVerbose(false);
            fges.setOut(System.out);
            fges.setMaxDegree(-1);
            long timeb = MillisecondTimes.timeMillis();
            this.out.println("Time consructing BDeu score " + (time4 - time3) + " ms");
            this.out.println("Time for FGES-MB constructor " + (timeb - time4) + " ms");
            this.out.println();
        }
        boolean numSkipped = false;
        for (int run = 0; run < numRuns; ++run) {
            int j;
            this.out.println("\n\n\n******************************** RUN " + (run + 1) + " ********************************\n\n");
            Node target = vars.get(RandomUtil.getInstance().nextInt(vars.size()));
            System.out.println("Target = " + target);
            long timea = MillisecondTimes.timeMillis();
            Graph estCPDAG = fges.search(Collections.singletonList(target));
            long timed = MillisecondTimes.timeMillis();
            long elapsed = timed - timea;
            HashSet<Node> mb = new HashSet<Node>();
            mb.add(target);
            mb.addAll(CPDAG.getAdjacentNodes(target));
            for (Node child : CPDAG.getChildren(target)) {
                mb.addAll(CPDAG.getParents(child));
            }
            Graph trueMbGraph = CPDAG.subgraph(new ArrayList<Node>(mb));
            long timec = MillisecondTimes.timeMillis();
            this.out.println("Time for FGES-MB search " + (timec - timea) + " ms");
            this.out.println();
            System.out.println("Done with FGES");
            System.out.println(new Date());
            double[] comparison = new double[4];
            System.out.println("Counting misclassifications.");
            int[][] counts = GraphUtils.edgeMisclassificationCounts(trueMbGraph, estCPDAG, false);
            allCounts.add(counts);
            System.out.println(new Date());
            int sumRow = counts[4][0] + counts[4][3] + counts[4][5];
            int sumCol = counts[0][3] + counts[4][3] + counts[5][3] + counts[7][3];
            int trueArrow = counts[4][3];
            int sumTrueAdjacencies = 0;
            for (int i = 0; i < 7; ++i) {
                for (j = 0; j < 5; ++j) {
                    sumTrueAdjacencies += counts[i][j];
                }
            }
            int falsePositiveAdjacencies = 0;
            for (j = 0; j < 5; ++j) {
                falsePositiveAdjacencies += counts[7][j];
            }
            int falseNegativeAdjacencies = 0;
            for (int i = 0; i < 5; ++i) {
                falseNegativeAdjacencies += counts[i][5];
            }
            comparison[0] = (double)sumTrueAdjacencies / (double)(sumTrueAdjacencies + falsePositiveAdjacencies);
            comparison[1] = (double)sumTrueAdjacencies / (double)(sumTrueAdjacencies + falseNegativeAdjacencies);
            comparison[2] = (double)trueArrow / (double)sumCol;
            comparison[3] = (double)trueArrow / (double)sumRow;
            comparisons.add(comparison);
            this.out.println(GraphUtils.edgeMisclassifications(counts));
            this.out.println(this.precisionRecall(comparison));
            elapsedTimes.add(elapsed);
            this.out.println("\nElapsed: " + elapsed + " ms");
        }
        this.printAverageConfusion("Average", allCounts, new DecimalFormat("0.0"));
        this.printAveragePrecisionRecall(comparisons);
        this.out.println("Number of runs skipped because of undefined accuracies: 0");
        this.printAverageStatistics(elapsedTimes, degrees);
        this.out.close();
    }

    private String precisionRecall(double[] comparison) {
        StringBuilder b = new StringBuilder();
        DecimalFormat nf = new DecimalFormat("0.00");
        b.append("\n");
        b.append("APRE\tAREC\tOPRE\tOREC\n");
        b.append(nf.format(comparison[0] * 100.0)).append("%\t").append(nf.format(comparison[1] * 100.0)).append("%\t").append(nf.format(comparison[2] * 100.0)).append("%\t").append(nf.format(comparison[3] * 100.0)).append("%");
        return b.toString();
    }

    public void testGFciComparison() {
        int numVars = 1000;
        double edgeFactor = 1.0;
        int numLatents = 100;
        int numCases = 1000;
        int numRuns = 5;
        double alpha = 0.01;
        double penaltyDiscount = 3.0;
        int depth = 3;
        int maxPathLength = 3;
        boolean possibleMsepDone = true;
        boolean completeRuleSetUsed = false;
        boolean faithfulnessAssumed = true;
        this.init(new File("fci.algorithm.comparison" + numVars + "." + (int)(edgeFactor * (double)numVars) + "." + numCases + ".txt"), "Num runs = 5");
        this.out.println("Num vars = " + numVars);
        this.out.println("Num edges = " + (int)((double)numVars * edgeFactor));
        this.out.println("Num cases = " + numCases);
        this.out.println("Alpha = 0.01");
        this.out.println("Penalty discount = 3.0");
        this.out.println("Depth = 3");
        this.out.println("Maximum reachable path length for msep search and discriminating undirectedPaths = 3");
        this.out.println("Num additional latent common causes = " + numLatents);
        this.out.println("Possible Msep Done = true");
        this.out.println("Complete Rule Set Used = false");
        this.out.println();
        ArrayList<GraphUtils.GraphComparison> ffciCounts = new ArrayList<GraphUtils.GraphComparison>();
        ArrayList<double[]> ffciArrowStats = new ArrayList<double[]>();
        ArrayList<double[]> ffciTailStats = new ArrayList<double[]>();
        ArrayList<Long> ffciElapsedTimes = new ArrayList<Long>();
        for (int run = 0; run < 5; ++run) {
            this.out.println("\n\n\n******************************** RUN " + (run + 1) + " ********************************\n\n");
            System.out.println("Making list of vars");
            ArrayList<Node> vars = new ArrayList<Node>();
            for (int i = 0; i < numVars; ++i) {
                vars.add(new ContinuousVariable("X" + (i + 1)));
            }
            System.out.println("Finishing list of vars");
            Graph dag = this.getLatentGraph(vars, edgeFactor, numLatents);
            System.out.println("Graph done");
            Graph truePag = GraphTransforms.dagToPag(dag);
            System.out.println("True PAG_of_the_true_DAG done");
            System.out.println("Starting simulation");
            LargeScaleSimulation simulator = new LargeScaleSimulation(dag);
            simulator.setCoefRange(0.5, 1.5);
            simulator.setVarRange(1.0, 3.0);
            DataSet data = simulator.simulateDataFisher(numCases);
            data = DataTransforms.restrictToMeasured(data);
            System.out.println("Finishing simulation");
            System.out.println("Making covariance matrix");
            CovarianceMatrix cov = new CovarianceMatrix(data);
            System.out.println("Covariance matrix done");
            IndTestFisherZ independenceTest = new IndTestFisherZ(cov, 0.01);
            SemBicScore score = new SemBicScore(cov);
            score.setPenaltyDiscount(3.0);
            this.out.println("\n\n\n========================TGFCI run " + (run + 1));
            long ta1 = MillisecondTimes.timeMillis();
            GFci fci = new GFci(independenceTest, score);
            fci.setMaxDegree(3);
            fci.setMaxPathLength(3);
            fci.setCompleteRuleSetUsed(false);
            fci.setFaithfulnessAssumed(true);
            Graph estPag = fci.search();
            long ta2 = MillisecondTimes.timeMillis();
            estPag = GraphUtils.replaceNodes(estPag, truePag.getNodes());
            HashSet<Node> missingNodes = new HashSet<Node>();
            for (Node node : dag.getNodes()) {
                if (estPag.containsNode(node)) continue;
                missingNodes.add(node);
            }
            ffciArrowStats.add(this.printCorrectArrows(dag, estPag, truePag));
            ffciTailStats.add(this.printCorrectTails(dag, estPag, truePag));
            ffciCounts.add(GraphSearchUtils.getGraphComparison(estPag, truePag));
            long elapsed = ta2 - ta1;
            ffciElapsedTimes.add(elapsed);
            this.out.println("\nElapsed: " + elapsed + " ms");
            try {
                PrintStream out2 = new PrintStream(new File("dag." + run + ".txt"));
                out2.println(dag);
                PrintStream out3 = new PrintStream(new File("estpag." + run + ".txt"));
                out3.println(estPag);
                PrintStream out4 = new PrintStream(new File("truepag." + run + ".txt"));
                out4.println(truePag);
                out2.close();
                out3.close();
                out4.close();
                continue;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        this.printAverageStatistics(ffciElapsedTimes, new ArrayList<Double>());
        this.out.close();
    }

    public void testCompareDagToCPDAG(int numLatents) {
        System.out.println("Making list of vars");
        int numVars = 20;
        double edgeFactor = 2.0;
        int numEdges = (int)((double)numVars * edgeFactor);
        ArrayList<Node> vars = new ArrayList<Node>();
        for (int i = 0; i < numVars; ++i) {
            vars.add(new ContinuousVariable("X" + i));
        }
        System.out.println("Finishing list of vars");
        System.out.println("Making graph");
        System.out.println("Finishing list of vars");
        Graph dag = RandomGraph.randomGraph(vars, 0, numEdges, 100, 100, 100, false);
        Paths paths = dag.paths();
        List<Node> initialOrder = dag.getNodes();
        List<Node> list = paths.getValidOrder(initialOrder, true);
        System.out.println("DAG = " + dag);
        System.out.println("Graph done");
        MsepTest test = new MsepTest(dag, true);
        Graph left = new Pc(test).search();
        System.out.println("PC graph = " + left);
        Graph top = GraphTransforms.cpdagForDag(dag);
        System.out.println("DAG to CPDAG graph = " + top);
        top = GraphUtils.replaceNodes(top, left.getNodes());
        System.out.println("True DAG = " + dag);
        System.out.println("FCI DAG with msep = " + left);
        System.out.println("DAG to PAG_of_the_true_DAG = " + top);
        System.out.println("Correcting nodes");
        top = GraphUtils.replaceNodes(top, left.getNodes());
        int[][] counts = GraphUtils.edgeMisclassificationCounts(left, top, true);
        System.out.println(GraphUtils.edgeMisclassifications(counts));
        Set<Edge> leftEdges = left.getEdges();
        leftEdges.removeAll(top.getEdges());
        System.out.println("FCI but not DAGTOPAG " + leftEdges);
        Set<Edge> topEdges = top.getEdges();
        topEdges.removeAll(left.getEdges());
        System.out.println("DAGTOPAG but not FCI " + topEdges);
    }

    public void testComparePcVersions(int numVars, double edgeFactor, int numLatents) {
        System.out.println("Making list of vars");
        ArrayList<Node> vars = new ArrayList<Node>();
        for (int i = 0; i < numVars; ++i) {
            vars.add(new ContinuousVariable("X" + i));
        }
        System.out.println("Finishing list of vars");
        System.out.println("Making graph");
        System.out.println("Finishing list of vars");
        Graph dag = RandomGraph.randomGraphRandomForwardEdges(vars, 0, (int)((double)vars.size() * edgeFactor), 30, 15, 15, false, true);
        System.out.println("DAG = " + dag);
        System.out.println(dag);
        System.out.println("Graph done");
        Graph left = GraphTransforms.cpdagForDag(dag);
        System.out.println("First FAS graph = " + left);
        Pc pc2 = new Pc(new MsepTest(dag));
        pc2.setStable(true);
        Graph top = pc2.search();
        System.out.println("Second FAS graph = " + top);
        top = GraphUtils.replaceNodes(top, left.getNodes());
        top = GraphUtils.replaceNodes(top, left.getNodes());
        int[][] counts = GraphUtils.edgeMisclassificationCounts(left, top, true);
        System.out.println(GraphUtils.edgeMisclassifications(counts));
        Set<Edge> leftEdges = left.getEdges();
        leftEdges.removeAll(top.getEdges());
        System.out.println("FAS1 but not Fas " + leftEdges);
        Set<Edge> topEdges = top.getEdges();
        topEdges.removeAll(left.getEdges());
        System.out.println("Fas but not FAS1 " + topEdges);
    }

    private void init(File file, String x) {
        boolean writeToFile = true;
        if (writeToFile) {
            try {
                File dir = new File("performance");
                dir.mkdir();
                File _file = new File(dir, file.getName());
                this.out = new PrintStream(_file);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        this.out.println(x);
    }

    private Graph makeDag(int numVars, double edgeFactor) {
        System.out.println("Making list of vars");
        ArrayList<Node> vars = new ArrayList<Node>();
        for (int i = 0; i < numVars; ++i) {
            vars.add(new ContinuousVariable("X" + i));
        }
        System.out.println("Finishing list of vars");
        System.out.println("Making dag");
        return RandomGraph.randomGraphRandomForwardEdges(vars, 0, (int)((double)numVars * edgeFactor), 30, 12, 15, false, true);
    }

    private void printDegreeDistribution(Graph dag, PrintStream out) {
        int max = 0;
        for (Node node : dag.getNodes()) {
            int degree = dag.getAdjacentNodes(node).size();
            if (degree <= max) continue;
            max = degree;
        }
        int[] counts = new int[max + 1];
        HashMap names = new HashMap();
        for (int i = 0; i <= max; ++i) {
            names.put(i, new ArrayList());
        }
        for (Node node : dag.getNodes()) {
            int degree;
            int n = degree = dag.getAdjacentNodes(node).size();
            counts[n] = counts[n] + 1;
            ((List)names.get(degree)).add(node);
        }
        for (int k = 0; k < counts.length; ++k) {
            if (counts[k] == 0) continue;
            out.print(k + " " + counts[k]);
            for (Node node : (List)names.get(k)) {
                out.print(" " + node.getName());
            }
            out.println();
        }
    }

    private void printIndegreeDistribution(Graph dag, PrintStream out) {
        int max = 0;
        for (Node node : dag.getNodes()) {
            int degree = dag.getIndegree(node);
            if (degree <= max) continue;
            max = degree;
        }
        int[] counts = new int[max + 1];
        HashMap names = new HashMap();
        for (int i = 0; i <= max; ++i) {
            names.put(i, new ArrayList());
        }
        for (Node node : dag.getNodes()) {
            int degree;
            int n = degree = dag.getIndegree(node);
            counts[n] = counts[n] + 1;
            ((List)names.get(degree)).add(node);
        }
        for (int k = 0; k < counts.length; ++k) {
            out.print(k + " " + counts[k]);
            for (Node node : (List)names.get(k)) {
                out.print(" " + node.getName());
            }
            out.println();
        }
    }

    private List<Node> getParentsInOrdering(List<Node> ordering, int i, Graph graph) {
        Node n1 = ordering.get(i);
        ArrayList<Node> parents = new ArrayList<Node>();
        for (Node n2 : ordering) {
            if (!graph.isParentOf(n2, n1)) continue;
            parents.add(n2);
        }
        return parents;
    }

    private void bidirectedComparison(Graph dag, Graph truePag, Graph estGraph, Set<Node> missingNodes) {
        System.out.println("Bidirected comparison");
        for (Edge edge : estGraph.getEdges()) {
            if (!estGraph.containsEdge(Edges.bidirectedEdge(edge.getNode1(), edge.getNode2())) || !truePag.containsEdge(Edges.partiallyOrientedEdge(edge.getNode1(), edge.getNode2())) && !truePag.containsEdge(Edges.partiallyOrientedEdge(edge.getNode2(), edge.getNode1()))) continue;
            boolean existsCommonCause = false;
            for (Node latent : missingNodes) {
                if (!dag.paths().existsDirectedPathFromTo(latent, edge.getNode1()) || !dag.paths().existsDirectedPathFromTo(latent, edge.getNode2())) continue;
                existsCommonCause = true;
                break;
            }
            System.out.println("Edge " + edge + " common cause = " + existsCommonCause);
        }
        System.out.println();
    }

    private void printAverageStatistics(List<Long> elapsedTimes, List<Double> degrees) {
        DecimalFormat nf = new DecimalFormat("0");
        DecimalFormat nf2 = new DecimalFormat("0.00");
        this.out.println();
        if (degrees.size() > 0) {
            double sumDegrees = 0.0;
            for (Double degree : degrees) {
                sumDegrees += degree.doubleValue();
            }
            double avgDegree = sumDegrees / (double)degrees.size();
            this.out.println();
            this.out.println("Avg Max Degree of Output CPDAG = " + nf2.format(avgDegree));
        }
        double sumElapsed = 0.0;
        for (Long e : elapsedTimes) {
            sumElapsed += (double)e.longValue();
        }
        this.out.println();
        this.out.println("Average Elapsed Time = " + nf.format(sumElapsed / (double)elapsedTimes.size()) + " ms");
        this.out.println();
    }

    private void printAverageConfusion(List<int[][]> comparisons) {
        this.printAverageConfusion("Average", comparisons, new DecimalFormat("0.0"));
    }

    private void printAverageConfusion(String name, List<int[][]> comparisons, NumberFormat nf) {
        int rows = comparisons.get(0).length;
        int cols = comparisons.get(0)[0].length;
        double[][] average = new double[rows][cols];
        double[][] _sum = new double[rows][cols];
        for (int i = 0; i < rows; ++i) {
            int j = 0;
            while (j < cols) {
                int sum = 0;
                for (int[][] comparison : comparisons) {
                    sum += comparison[i][j];
                }
                average[i][j] = (double)sum / (double)comparisons.size();
                double[] dArray = _sum[i];
                int n = j++;
                dArray[n] = dArray[n] + (double)sum;
            }
        }
        this.out.println();
        this.out.println(name);
        this.out.println(GraphUtils.edgeMisclassifications(average, nf));
    }

    private void printAveragePrecisionRecall(List<double[]> comparisons) {
        double sum1 = 0.0;
        double sum2 = 0.0;
        double sum3 = 0.0;
        double sum4 = 0.0;
        for (double[] comparison : comparisons) {
            sum1 += comparison[0];
            sum2 += comparison[1];
            sum3 += comparison[2];
            sum4 += comparison[3];
        }
        double avg1 = sum1 / (double)comparisons.size();
        double avg2 = sum2 / (double)comparisons.size();
        double avg3 = sum3 / (double)comparisons.size();
        double avg4 = sum4 / (double)comparisons.size();
        StringBuilder b = new StringBuilder();
        DecimalFormat nf = new DecimalFormat("0.00");
        b.append("\n");
        b.append("APRE\tAREC\tOPRE\tOREC\n");
        b.append(nf.format(avg1 * 100.0)).append("%\t").append(nf.format(avg2 * 100.0)).append("%\t").append(nf.format(avg3 * 100.0)).append("%\t").append(nf.format(avg4 * 100.0)).append("%");
        this.out.println(b);
    }

    private void printAggregatedPrecisionRecall(int[][] counts) {
        int j;
        int sumRow = counts[4][0] + counts[4][3] + counts[4][5];
        int sumCol = counts[0][3] + counts[4][3] + counts[5][3] + counts[7][3];
        int trueArrow = counts[4][3];
        int sumTrueAdjacencies = 0;
        for (int i = 0; i < 7; ++i) {
            for (j = 0; j < 5; ++j) {
                sumTrueAdjacencies += counts[i][j];
            }
        }
        int falsePositiveAdjacencies = 0;
        for (j = 0; j < 5; ++j) {
            falsePositiveAdjacencies += counts[7][j];
        }
        int falseNegativeAdjacencies = 0;
        for (int i = 0; i < 5; ++i) {
            falseNegativeAdjacencies += counts[i][5];
        }
        double[] comparison = new double[]{(double)sumTrueAdjacencies / (double)(sumTrueAdjacencies + falsePositiveAdjacencies), (double)sumTrueAdjacencies / (double)(sumTrueAdjacencies + falseNegativeAdjacencies), (double)trueArrow / (double)sumCol, (double)trueArrow / (double)sumRow};
        StringBuilder b = new StringBuilder();
        DecimalFormat nf = new DecimalFormat("0.00");
        b.append("\n");
        b.append("APRE\tAREC\tOPRE\tOREC\n");
        b.append(nf.format(comparison[0] * 100.0)).append("%\t").append(nf.format(comparison[1] * 100.0)).append("%\t").append(nf.format(comparison[2] * 100.0)).append("%\t").append(nf.format(comparison[3] * 100.0)).append("%");
        this.out.println(b);
    }

    private double[] printCorrectArrows(Graph dag, Graph outGraph, Graph truePag) {
        int correctArrows = 0;
        int totalEstimatedArrows = 0;
        int totalTrueArrows = 0;
        int correctNonAncestorRelationships = 0;
        double[] stats = new double[6];
        for (Edge edge : outGraph.getEdges()) {
            Node x = edge.getNode1();
            Node y = edge.getNode2();
            Endpoint ex = edge.getEndpoint1();
            Endpoint ey = edge.getEndpoint2();
            Edge edge1 = truePag.getEdge(x, y);
            if (ex == Endpoint.ARROW) {
                if (!dag.paths().isAncestorOf(x, y)) {
                    ++correctNonAncestorRelationships;
                }
                if (edge1 != null && edge1.getProximalEndpoint(x) == Endpoint.ARROW) {
                    ++correctArrows;
                }
                ++totalEstimatedArrows;
            }
            if (ey != Endpoint.ARROW) continue;
            if (!dag.paths().isAncestorOf(y, x)) {
                ++correctNonAncestorRelationships;
            }
            if (edge1 != null && edge1.getProximalEndpoint(y) == Endpoint.ARROW) {
                ++correctArrows;
            }
            ++totalEstimatedArrows;
        }
        for (Edge edge : truePag.getEdges()) {
            Endpoint ex = edge.getEndpoint1();
            Endpoint ey = edge.getEndpoint2();
            if (ex == Endpoint.ARROW) {
                ++totalTrueArrows;
            }
            if (ey != Endpoint.ARROW) continue;
            ++totalTrueArrows;
        }
        this.out.println();
        this.out.println("# correct arrows = " + correctArrows);
        this.out.println("# total estimated arrows = " + totalEstimatedArrows);
        this.out.println("# correct arrow nonancestor relationships = " + correctNonAncestorRelationships);
        this.out.println("# total true arrows = " + totalTrueArrows);
        this.out.println();
        DecimalFormat nf = new DecimalFormat("0.00");
        double precision = (double)correctArrows / (double)totalEstimatedArrows;
        this.out.println("Arrow precision = " + nf.format(precision));
        double recall = (double)correctArrows / (double)totalTrueArrows;
        this.out.println("Arrow recall = " + nf.format(recall));
        double proportionCorrectNonAncestorRelationships = (double)correctNonAncestorRelationships / (double)totalEstimatedArrows;
        this.out.println("Proportion correct arrow nonancestor relationships " + nf.format(proportionCorrectNonAncestorRelationships));
        stats[0] = correctArrows;
        stats[1] = totalEstimatedArrows;
        stats[2] = totalTrueArrows;
        stats[3] = precision;
        stats[4] = recall;
        stats[5] = proportionCorrectNonAncestorRelationships;
        return stats;
    }

    private double[] printCorrectTails(Graph dag, Graph outGraph, Graph truePag) {
        int correctTails = 0;
        int correctAncestorRelationships = 0;
        int totalEstimatedTails = 0;
        int totalTrueTails = 0;
        double[] stats = new double[6];
        for (Edge edge : outGraph.getEdges()) {
            Node x = edge.getNode1();
            Node y = edge.getNode2();
            Endpoint ex = edge.getEndpoint1();
            Endpoint ey = edge.getEndpoint2();
            Edge edge1 = truePag.getEdge(x, y);
            if (ex == Endpoint.TAIL) {
                if (dag.paths().isAncestorOf(x, y)) {
                    ++correctAncestorRelationships;
                }
                if (edge1 != null && edge1.getProximalEndpoint(x) == Endpoint.TAIL) {
                    ++correctTails;
                }
                ++totalEstimatedTails;
            }
            if (ey != Endpoint.TAIL) continue;
            if (dag.paths().isAncestorOf(y, x)) {
                ++correctAncestorRelationships;
            }
            if (edge1 != null && edge1.getProximalEndpoint(y) == Endpoint.TAIL) {
                ++correctTails;
            }
            ++totalEstimatedTails;
        }
        for (Edge edge : truePag.getEdges()) {
            Endpoint ex = edge.getEndpoint1();
            Endpoint ey = edge.getEndpoint2();
            if (ex == Endpoint.TAIL) {
                ++totalTrueTails;
            }
            if (ey != Endpoint.TAIL) continue;
            ++totalTrueTails;
        }
        this.out.println();
        this.out.println("# correct tails = " + correctTails);
        this.out.println("# total estimated tails = " + totalEstimatedTails);
        this.out.println("# correct tail ancestor relationships = " + correctAncestorRelationships);
        this.out.println("# total true tails = " + totalTrueTails);
        this.out.println();
        DecimalFormat nf = new DecimalFormat("0.00");
        double precision = (double)correctTails / (double)totalEstimatedTails;
        this.out.println("Tail precision = " + nf.format(precision));
        double recall = (double)correctTails / (double)totalTrueTails;
        this.out.println("Tail recall = " + nf.format(recall));
        double proportionCorrectAncestorRelationships = (double)correctAncestorRelationships / (double)totalEstimatedTails;
        this.out.println("Proportion correct tail ancestor relationships " + nf.format(proportionCorrectAncestorRelationships));
        stats[0] = correctTails;
        stats[1] = totalEstimatedTails;
        stats[2] = totalTrueTails;
        stats[3] = precision;
        stats[4] = recall;
        stats[5] = proportionCorrectAncestorRelationships;
        return stats;
    }

    private Graph getLatentGraph(List<Node> vars, double edgeFactor, int numLatents) {
        int numEdges = (int)((double)vars.size() * edgeFactor);
        return RandomGraph.randomGraph(vars, numLatents, numEdges, 3, 3, 3, false);
    }

    @Test
    public void printGraphDegrees() {
        int numVars = 30000;
        int numEdges = 60000;
        Graph graph = RandomGraph.randomGraphRandomForwardEdges(30000, 0, 60000, 30, 30, 30, false);
        TreeMap<Integer, Integer> degreeCounts = new TreeMap<Integer, Integer>();
        List<Node> nodes = graph.getNodes();
        for (int i = 0; i < 30000; ++i) {
            Node node = nodes.get(i);
            List<Node> adj = graph.getAdjacentNodes(node);
            int degree = adj.size();
            degreeCounts.putIfAbsent(degree, 0);
            degreeCounts.put(degree, (Integer)degreeCounts.get(degree) + 1);
        }
        Iterator iterator = degreeCounts.keySet().iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            System.out.println(i + " " + degreeCounts.get(i));
        }
    }
}

