/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.study.performance;

import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataTransforms;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.GraphTransforms;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.graph.RandomGraph;
import edu.cmu.tetrad.search.GFci;
import edu.cmu.tetrad.search.Pc;
import edu.cmu.tetrad.search.score.SemBicScore;
import edu.cmu.tetrad.search.test.IndTestFisherZ;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemPm;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

public class PerformanceTestsDan {
    public static void main(String ... args) {
        System.out.println("Start ");
        new PerformanceTestsDan().testIdaOutputForDan();
    }

    private void testIdaOutputForDan() {
        int numRuns = 100;
        for (int run = 0; run < 100; ++run) {
            PrintStream out12;
            PrintStream out11;
            PrintStream out10;
            PrintStream out9;
            PrintStream out8;
            PrintStream out7;
            PrintStream out6;
            PrintStream out5;
            PrintStream out4;
            PrintStream out3;
            PrintStream out2;
            PrintStream out1;
            double alphaGFci = 0.01;
            double alphaPc = 0.01;
            boolean penaltyDiscount = true;
            int depth = 3;
            int maxPathLength = 3;
            int numVars = 15;
            double edgesPerNode = 1.0;
            int numCases = 1000;
            int numLatents = 6;
            File dir0 = new File("gfci.output");
            dir0.mkdirs();
            File dir = new File(dir0, "" + (run + 1));
            dir.mkdir();
            try {
                out1 = new PrintStream(new File(dir, "hyperparameters.txt"));
                out2 = new PrintStream(new File(dir, "variables.txt"));
                out3 = new PrintStream(new File(dir, "dag.long.txt"));
                out4 = new PrintStream(new File(dir, "dag.matrix.txt"));
                out5 = new PrintStream(new File(dir, "coef.matrix.txt"));
                out6 = new PrintStream(new File(dir, "pag.long.txt"));
                out7 = new PrintStream(new File(dir, "pag.matrix.txt"));
                out8 = new PrintStream(new File(dir, "cpdag.long.txt"));
                out9 = new PrintStream(new File(dir, "cpdag.matrix.txt"));
                out10 = new PrintStream(new File(dir, "data.txt"));
                out11 = new PrintStream(new File(dir, "true.pag.long.txt"));
                out12 = new PrintStream(new File(dir, "true.pag.matrix.txt"));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            out1.println("Num _vars = 15");
            out1.println("Num edges = 15");
            out1.println("Num cases = 1000");
            out1.println("Alpha for PC = 0.01");
            out1.println("Alpha for FFCI = 0.01");
            out1.println("Penalty discount = 1");
            out1.println("Depth = 3");
            out1.println("Maximum reachable path length for msep search and discriminating undirectedPaths = 3");
            ArrayList<Node> vars = new ArrayList<Node>();
            for (int i = 0; i < 15; ++i) {
                vars.add(new GraphNode("X" + (i + 1)));
            }
            Graph dag = RandomGraph.randomGraph(vars, 0, (int)((double)vars.size() * 1.0), 5, 5, 5, false);
            RandomGraph.fixLatents1(6, dag);
            out3.println(dag);
            this.printDanMatrix(vars, dag, out4);
            SemPm pm = new SemPm(dag);
            SemIm im = new SemIm(pm);
            DecimalFormat nf = new DecimalFormat("0.0000");
            for (int i = 0; i < vars.size(); ++i) {
                for (Node node : vars) {
                    if (im.existsEdgeCoef(node, (Node)vars.get(i))) {
                        double coef = im.getEdgeCoef(node, (Node)vars.get(i));
                        out5.print(nf.format(coef) + "\t");
                        continue;
                    }
                    out5.print(nf.format(0L) + "\t");
                }
                out5.println();
            }
            out5.println();
            String vars_temp = ((Object)vars).toString();
            vars_temp = vars_temp.replace("[", "");
            vars_temp = vars_temp.replace("]", "");
            vars_temp = vars_temp.replace("X", "");
            out2.println(vars_temp);
            ArrayList<Node> _vars = new ArrayList<Node>();
            for (Node node : vars) {
                if (node.getNodeType() != NodeType.MEASURED) continue;
                _vars.add(node);
            }
            String string4 = ((Object)_vars).toString();
            string4 = string4.replace("[", "");
            string4 = string4.replace("]", "");
            string4 = string4.replace("X", "");
            out2.println(string4);
            DataSet fullData = im.simulateData(1000, false);
            DataSet data = DataTransforms.restrictToMeasured(fullData);
            CovarianceMatrix cov = new CovarianceMatrix(data);
            IndTestFisherZ independenceTestGFci = new IndTestFisherZ(cov, 0.01);
            SemBicScore scoreGfci = new SemBicScore(cov);
            out6.println("GFCI.PAG_of_the_true_DAG");
            GFci gFci = new GFci(independenceTestGFci, scoreGfci);
            gFci.setVerbose(false);
            gFci.setMaxDegree(3);
            gFci.setMaxPathLength(3);
            gFci.setCompleteRuleSetUsed(true);
            Graph pag = gFci.search();
            out6.println(pag);
            this.printDanMatrix(_vars, pag, out7);
            out8.println("CPDAG_of_the_true_DAG OVER MEASURED VARIABLES");
            IndTestFisherZ independencePc = new IndTestFisherZ(cov, 0.01);
            Pc pc = new Pc(independencePc);
            pc.setVerbose(false);
            pc.setDepth(3);
            Graph CPDAG = pc.search();
            out8.println(CPDAG);
            this.printDanMatrix(_vars, CPDAG, out9);
            out10.println(data);
            out11.println("True PAG_of_the_true_DAG");
            Graph truePag = GraphTransforms.dagToPag(dag);
            out11.println(truePag);
            this.printDanMatrix(_vars, truePag, out12);
            out1.close();
            out2.close();
            out3.close();
            out4.close();
            out5.close();
            out6.close();
            out7.close();
            out8.close();
            out9.close();
            out10.close();
            out11.close();
            out12.close();
        }
    }

    private void printDanMatrix(List<Node> vars, Graph CPDAG, PrintStream out) {
        CPDAG = GraphUtils.replaceNodes(CPDAG, vars);
        for (int i = 0; i < vars.size(); ++i) {
            for (Node var : vars) {
                Edge edge = CPDAG.getEdge(vars.get(i), var);
                if (edge == null) {
                    out.print("0\t");
                    continue;
                }
                Endpoint ej = edge.getProximalEndpoint(var);
                if (ej == Endpoint.TAIL) {
                    out.print("3\t");
                    continue;
                }
                if (ej == Endpoint.ARROW) {
                    out.print("2\t");
                    continue;
                }
                if (ej != Endpoint.CIRCLE) continue;
                out.print("1\t");
            }
            out.println();
        }
        out.println();
    }
}

