/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.util;

import org.apache.commons.math3.special.Gamma;
import org.apache.commons.math3.util.FastMath;

public final class ChoiceGenerator {
    private final int a;
    private final int b;
    private final int diff;
    private final int[] choiceLocal;
    private final int[] choiceReturned;
    private boolean begun;

    public ChoiceGenerator(int a, int b) {
        if (a < 0 || b < 0) {
            throw new IllegalArgumentException("ERROR: a and b must be non-negative");
        }
        if (b > a) {
            b = a;
        }
        this.a = a;
        this.b = b;
        this.choiceLocal = new int[b];
        this.choiceReturned = new int[b];
        this.diff = a - b;
        for (int i = 0; i < b - 1; ++i) {
            this.choiceLocal[i] = i;
        }
        if (b > 0) {
            this.choiceLocal[b - 1] = b - 2;
        }
        this.begun = false;
    }

    public static void testPrint(int a, int b) {
        int[] choice;
        ChoiceGenerator cg = new ChoiceGenerator(a, b);
        System.out.println();
        System.out.println("Printing combinations for " + a + " choose " + b + ":");
        System.out.println();
        while ((choice = cg.next()) != null) {
            if (choice.length == 0) {
                System.out.println("zero-length array");
                continue;
            }
            for (int aChoice : choice) {
                System.out.print(aChoice + "\t");
            }
            System.out.println();
        }
        System.out.println();
    }

    public static int getNumCombinations(int a, int b) {
        return (int)FastMath.round(FastMath.exp(ChoiceGenerator.logCombinations(a, b)));
    }

    public static double logCombinations(int a, int b) {
        return Gamma.logGamma(a + 1) - Gamma.logGamma(b + 1) - Gamma.logGamma(a - b + 1);
    }

    public synchronized int[] next() {
        int i = this.getB();
        while (--i > -1) {
            if (this.choiceLocal[i] >= i + this.diff) continue;
            if (Thread.currentThread().isInterrupted()) break;
            this.fill(i);
            this.begun = true;
            System.arraycopy(this.choiceLocal, 0, this.choiceReturned, 0, this.b);
            return this.choiceReturned;
        }
        if (this.begun) {
            return null;
        }
        this.begun = true;
        System.arraycopy(this.choiceLocal, 0, this.choiceReturned, 0, this.b);
        return this.choiceReturned;
    }

    public int getA() {
        return this.a;
    }

    public int getB() {
        return this.b;
    }

    private void fill(int index) {
        int n = index;
        this.choiceLocal[n] = this.choiceLocal[n] + 1;
        for (int i = index + 1; i < this.getB(); ++i) {
            this.choiceLocal[i] = this.choiceLocal[i - 1] + 1;
        }
    }
}

