/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.util;

import java.util.Iterator;

public class CombinationIterator
implements Iterator {
    private final int[] values;
    private final int[] maxValues;
    private final int numValues;
    private boolean hasNext;

    public CombinationIterator(int[] maxValues) {
        this.numValues = maxValues.length;
        this.values = new int[this.numValues];
        this.maxValues = maxValues;
        this.hasNext = true;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    public int[] next() {
        int i;
        int[] clone = new int[this.numValues];
        System.arraycopy(this.values, 0, clone, 0, this.numValues);
        for (i = this.numValues - 1; i >= 0 && this.values[i] + 1 >= this.maxValues[i]; --i) {
        }
        if (i < 0) {
            this.hasNext = false;
        } else {
            int n = i;
            this.values[n] = this.values[n] + 1;
            for (int j = i + 1; j < this.numValues; ++j) {
                this.values[j] = 0;
            }
        }
        return clone;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

