/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.util;

import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.EdgeTypeProbability;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.pitt.dbmi.algo.resampling.ResamplingEdgeEnsemble;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;

public final class GraphSampling {
    private GraphSampling() {
    }

    public static Graph createGraphWithoutNullEdges(Graph graph) {
        EdgeListGraph myGraph = new EdgeListGraph(graph.getNodes());
        graph.getEdges().stream().filter(edge -> edge.getEndpoint1() != Endpoint.NULL && edge.getEndpoint2() != Endpoint.NULL).forEach(myGraph::addEdge);
        return myGraph;
    }

    public static Graph createDisplayGraph(Graph graph, ResamplingEdgeEnsemble ensemble) {
        EdgeListGraph ensembleGraph = new EdgeListGraph(graph.getNodes());
        for (Edge edge : graph.getEdges()) {
            List<EdgeTypeProbability> edgeTypeProbabilities = edge.getEdgeTypeProbabilities();
            if (edgeTypeProbabilities == null || edgeTypeProbabilities.isEmpty()) {
                ensembleGraph.addEdge(edge);
                continue;
            }
            EdgeTypeProbability highestEdgeTypeProbability = GraphSampling.getHighestEdgeTypeProbability(edgeTypeProbabilities, ensemble);
            Edge highestProbEdge = GraphSampling.createEdge(highestEdgeTypeProbability, edge.getNode1(), edge.getNode2());
            if (highestProbEdge == null) continue;
            edgeTypeProbabilities.forEach(highestProbEdge::addEdgeTypeProbability);
            highestEdgeTypeProbability.getProperties().forEach(highestProbEdge::addProperty);
            ensembleGraph.addEdge(highestProbEdge);
        }
        GraphSampling.setEdgeProbabilitiesOfNonNullEdges(ensembleGraph);
        return ensembleGraph;
    }

    public static Graph createGraphWithHighProbabilityEdges(List<Graph> graphs, ResamplingEdgeEnsemble ensemble) {
        Graph graph = GraphSampling.createGraphWithHighProbabilityEdges(graphs);
        return GraphSampling.createDisplayGraph(graph, ensemble);
    }

    public static Graph createGraphWithHighProbabilityEdges(List<Graph> graphs) {
        if ((graphs = graphs.stream().filter(graph -> graph != null).map(graph -> GraphSampling.addPagColorings(graph)).collect(Collectors.toList())).isEmpty()) {
            return new EdgeListGraph();
        }
        Graph graph2 = GraphSampling.createNewGraph(graphs.get(0).getNodes());
        for (NodePair nodePair : GraphSampling.getEdgeNodePairs(graphs)) {
            String node2;
            String node1 = nodePair.getNode1();
            List<EdgeTypeProbability> edgeTypeProbabilities = GraphSampling.getEdgeTypeProbabilities(node1, node2 = nodePair.getNode2(), graphs);
            EdgeTypeProbability highestEdgeTypeProbability = GraphSampling.getHighestEdgeTypeProbability(edgeTypeProbabilities);
            Edge highestProbEdge = GraphSampling.createEdge(highestEdgeTypeProbability, graph2.getNode(node1), graph2.getNode(node2));
            if (highestProbEdge == null) continue;
            if (node1.equals(highestProbEdge.getNode1().getName()) && node2.equals(highestProbEdge.getNode2().getName())) {
                edgeTypeProbabilities.forEach(highestProbEdge::addEdgeTypeProbability);
            } else {
                edgeTypeProbabilities.forEach(etp -> {
                    etp.setEdgeType(GraphSampling.getReversed(etp.getEdgeType()));
                    highestProbEdge.addEdgeTypeProbability((EdgeTypeProbability)etp);
                });
            }
            graph2.addEdge(highestProbEdge);
        }
        GraphSampling.setEdgeProbabilitiesOfNonNullEdges(graph2);
        return graph2;
    }

    private static void setEdgeProbabilitiesOfNonNullEdges(Graph graph) {
        graph.getEdges().forEach(edge -> {
            List<EdgeTypeProbability> etps = edge.getEdgeTypeProbabilities();
            if (etps != null || !etps.isEmpty()) {
                double probability = edge.getEdgeTypeProbabilities().stream().filter(etp -> etp.getEdgeType() != EdgeTypeProbability.EdgeType.nil).mapToDouble(EdgeTypeProbability::getProbability).sum();
                edge.setProbability(probability);
            }
        });
    }

    private static Edge createEdge(EdgeTypeProbability edgeTypeProbability, Node n1, Node n2) {
        if (edgeTypeProbability == null) {
            return null;
        }
        switch (edgeTypeProbability.getEdgeType()) {
            case ta: {
                return new Edge(n1, n2, Endpoint.TAIL, Endpoint.ARROW);
            }
            case at: {
                return new Edge(n1, n2, Endpoint.ARROW, Endpoint.TAIL);
            }
            case ca: {
                return new Edge(n1, n2, Endpoint.CIRCLE, Endpoint.ARROW);
            }
            case ac: {
                return new Edge(n1, n2, Endpoint.ARROW, Endpoint.CIRCLE);
            }
            case cc: {
                return new Edge(n1, n2, Endpoint.CIRCLE, Endpoint.CIRCLE);
            }
            case aa: {
                return new Edge(n1, n2, Endpoint.ARROW, Endpoint.ARROW);
            }
            case tt: {
                return new Edge(n1, n2, Endpoint.TAIL, Endpoint.TAIL);
            }
        }
        return new Edge(n1, n2, Endpoint.NULL, Endpoint.NULL);
    }

    private static EdgeTypeProbability getHighestEdgeTypeProbability(List<EdgeTypeProbability> edgeTypeProbabilities, ResamplingEdgeEnsemble edgeEnsemble) {
        EdgeTypeProbability highestEdgeTypeProb = null;
        if (edgeTypeProbabilities != null && !edgeTypeProbabilities.isEmpty()) {
            double maxEdgeProb = 0.0;
            double noEdgeProb = 0.0;
            for (EdgeTypeProbability etp : edgeTypeProbabilities) {
                EdgeTypeProbability.EdgeType edgeType = etp.getEdgeType();
                double prob = etp.getProbability();
                if (edgeType == EdgeTypeProbability.EdgeType.nil) {
                    noEdgeProb = prob;
                    continue;
                }
                if (!(prob > maxEdgeProb)) continue;
                highestEdgeTypeProb = etp;
                maxEdgeProb = prob;
            }
            switch (edgeEnsemble) {
                case Highest: {
                    if (!(noEdgeProb > maxEdgeProb)) break;
                    highestEdgeTypeProb = null;
                    break;
                }
                case Majority: {
                    if (!(noEdgeProb > maxEdgeProb) && !(maxEdgeProb < 0.5)) break;
                    highestEdgeTypeProb = null;
                    break;
                }
                case Threshold: {
                    double threshold = Preferences.userRoot().getDouble("edge.ensemble.threshold", 0.5);
                    if (!(noEdgeProb > maxEdgeProb) && !(maxEdgeProb < threshold)) break;
                    highestEdgeTypeProb = null;
                }
            }
        }
        return highestEdgeTypeProb;
    }

    private static EdgeTypeProbability getHighestEdgeTypeProbability(List<EdgeTypeProbability> edgeTypeProbabilities) {
        if (edgeTypeProbabilities == null || edgeTypeProbabilities.isEmpty()) {
            return null;
        }
        EdgeTypeProbability[] etps = (EdgeTypeProbability[])edgeTypeProbabilities.stream().toArray(EdgeTypeProbability[]::new);
        Arrays.sort(etps, (etp1, etp2) -> {
            if (etp1.getProbability() > etp2.getProbability()) {
                return -1;
            }
            if (etp1.getProbability() < etp2.getProbability()) {
                return 1;
            }
            return 0;
        });
        return etps[0];
    }

    private static List<EdgeTypeProbability> getEdgeTypeProbabilities(String node1, String node2, List<Graph> graphs) {
        LinkedList<EdgeTypeProbability> edgeTypeProbabilities = new LinkedList<EdgeTypeProbability>();
        int numOfNullEdges = 0;
        HashMap<EdgeTypeProbability.EdgeType, Integer> edgeTypeCounts = new HashMap<EdgeTypeProbability.EdgeType, Integer>();
        HashMap<EdgeTypeProbability.EdgeType, Edge> edgeTypeEdges = new HashMap<EdgeTypeProbability.EdgeType, Edge>();
        for (Graph graph : graphs) {
            Node n2;
            Node n1;
            Edge edge = graph.getEdge(n1 = graph.getNode(node1), n2 = graph.getNode(node2));
            if (edge == null) {
                ++numOfNullEdges;
                continue;
            }
            EdgeTypeProbability.EdgeType edgeType = GraphSampling.getEdgeType(edge, n1, n2);
            edgeTypeEdges.put(edgeType, edge);
            Integer edgeCounts = (Integer)edgeTypeCounts.get((Object)edgeType);
            edgeCounts = edgeCounts == null ? 1 : edgeCounts + 1;
            edgeTypeCounts.put(edgeType, edgeCounts);
        }
        for (EdgeTypeProbability.EdgeType edgeType : edgeTypeCounts.keySet()) {
            Edge edge = (Edge)edgeTypeEdges.get((Object)edgeType);
            ArrayList<Edge.Property> properties = edge.getProperties();
            double probability = (double)((Integer)edgeTypeCounts.get((Object)edgeType)).intValue() / (double)graphs.size();
            edgeTypeProbabilities.add(new EdgeTypeProbability(edgeType, properties, probability));
        }
        if (numOfNullEdges > 0 && numOfNullEdges < graphs.size()) {
            edgeTypeProbabilities.add(new EdgeTypeProbability(EdgeTypeProbability.EdgeType.nil, (double)numOfNullEdges / (double)graphs.size()));
        }
        EdgeTypeProbability[] etps = (EdgeTypeProbability[])edgeTypeProbabilities.stream().toArray(EdgeTypeProbability[]::new);
        Arrays.sort(etps, (etp1, etp2) -> {
            if (etp1.getProbability() > etp2.getProbability()) {
                return -1;
            }
            if (etp1.getProbability() < etp2.getProbability()) {
                return 1;
            }
            return 0;
        });
        return Arrays.asList(etps);
    }

    private static EdgeTypeProbability.EdgeType getReversed(EdgeTypeProbability.EdgeType edgeType) {
        switch (edgeType) {
            case ac: {
                return EdgeTypeProbability.EdgeType.ca;
            }
            case at: {
                return EdgeTypeProbability.EdgeType.ta;
            }
            case ca: {
                return EdgeTypeProbability.EdgeType.ac;
            }
            case ta: {
                return EdgeTypeProbability.EdgeType.at;
            }
        }
        return edgeType;
    }

    private static EdgeTypeProbability.EdgeType getEdgeType(Edge edge, Node node1, Node node2) {
        Endpoint node1Endpoint = edge.getProximalEndpoint(node1);
        Endpoint node2Endpoint = edge.getProximalEndpoint(node2);
        if (node1Endpoint == Endpoint.TAIL && node2Endpoint == Endpoint.ARROW) {
            return EdgeTypeProbability.EdgeType.ta;
        }
        if (node1Endpoint == Endpoint.ARROW && node2Endpoint == Endpoint.TAIL) {
            return EdgeTypeProbability.EdgeType.at;
        }
        if (node1Endpoint == Endpoint.CIRCLE && node2Endpoint == Endpoint.ARROW) {
            return EdgeTypeProbability.EdgeType.ca;
        }
        if (node1Endpoint == Endpoint.ARROW && node2Endpoint == Endpoint.CIRCLE) {
            return EdgeTypeProbability.EdgeType.ac;
        }
        if (node1Endpoint == Endpoint.CIRCLE && node2Endpoint == Endpoint.CIRCLE) {
            return EdgeTypeProbability.EdgeType.cc;
        }
        if (node1Endpoint == Endpoint.ARROW && node2Endpoint == Endpoint.ARROW) {
            return EdgeTypeProbability.EdgeType.aa;
        }
        if (node1Endpoint == Endpoint.TAIL && node2Endpoint == Endpoint.TAIL) {
            return EdgeTypeProbability.EdgeType.tt;
        }
        return EdgeTypeProbability.EdgeType.nil;
    }

    public static Set<NodePair> getEdgeNodePairs(List<Graph> graphs) {
        HashSet nodePairs = new HashSet();
        graphs.forEach(graph -> graph.getEdges().forEach(edge -> {
            String node1Name = edge.getNode1().getName();
            String node2Name = edge.getNode2().getName();
            nodePairs.add(new NodePair(node1Name, node2Name));
        }));
        return new TreeSet<NodePair>(nodePairs);
    }

    private static Graph createNewGraph(List<Node> graphNodes) {
        Object[] nodes = (Node[])graphNodes.stream().toArray(Node[]::new);
        Arrays.sort(nodes);
        return new EdgeListGraph(Arrays.asList(nodes));
    }

    private static Graph addPagColorings(Graph graph) {
        GraphUtils.addPagColoring(graph);
        return graph;
    }

    private static class NodePair
    implements Comparable<NodePair> {
        private final String node1;
        private final String node2;

        public NodePair(String node1, String node2) {
            this.node1 = node1;
            this.node2 = node2;
        }

        @Override
        public int compareTo(NodePair other) {
            int firstNodeComparison = this.node1.compareTo(other.node1);
            return firstNodeComparison == 0 ? this.node2.compareTo(other.node2) : firstNodeComparison;
        }

        public int hashCode() {
            return this.node1.hashCode() + this.node2.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NodePair other = (NodePair)obj;
            boolean isDirectlyEqual = this.node1.equals(other.node1) && this.node2.equals(other.node2);
            boolean isIndirectlyEqual = this.node1.equals(other.node2) && this.node2.equals(other.node1);
            return isDirectlyEqual || isIndirectlyEqual;
        }

        public String toString() {
            return String.format("(%s, %s)", this.node1, this.node2);
        }

        public String getNode1() {
            return this.node1;
        }

        public String getNode2() {
            return this.node2;
        }
    }
}

