/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.util;

import edu.cmu.tetrad.util.ArrUtils;
import edu.cmu.tetrad.util.Matrix;
import edu.cmu.tetrad.util.MatrixUtils;

public final class IndexedMatrix {
    private final double[][] matrix;
    private int[] indices;

    public IndexedMatrix(double[][] matrix) {
        assert (MatrixUtils.isSquare(matrix));
        this.matrix = new Matrix(matrix).toArray();
        this.setIndices(new int[0]);
    }

    public int[] getIndices() {
        return this.indices;
    }

    public void setIndices(int[] indices) {
        if (indices == null) {
            throw new NullPointerException("Permutation must not be null.");
        }
        if (!this.isLegal(indices)) {
            throw new IllegalArgumentException("Illegal index array: " + ArrUtils.toString(indices));
        }
        this.indices = ArrUtils.copy(indices);
    }

    public double getValue(int i, int j) {
        return this.matrix[this.indices[i]][this.indices[j]];
    }

    private boolean isLegal(int[] indices) {
        int[] check = new int[this.matrix.length];
        for (int indice : indices) {
            if (indice < 0 || indice >= this.matrix.length) {
                return false;
            }
            int n = indice;
            check[n] = check[n] + 1;
        }
        for (int i = 0; i < this.matrix.length; ++i) {
            if (check[i] <= 1) continue;
            return false;
        }
        return true;
    }
}

