/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.util;

import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.EdgeTypeProbability;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.graph.Triple;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonUtils {
    public static Graph parseJSONObjectToTetradGraph(String jsonResponse) {
        return JsonUtils.parseJSONObjectToTetradGraph(new JSONObject(jsonResponse));
    }

    public static Graph parseJSONObjectToTetradGraph(JSONObject jObj) {
        if (!jObj.isNull("graph")) {
            return JsonUtils.parseJSONObjectToTetradGraph(jObj.getJSONObject("graph"));
        }
        List<Node> nodes = JsonUtils.parseJSONArrayToTetradNodes(jObj.getJSONArray("nodes"));
        EdgeListGraph graph = new EdgeListGraph(nodes);
        Set<Edge> edges = JsonUtils.parseJSONArrayToTetradEdges(graph, jObj.getJSONArray("edgesSet"));
        for (Edge edge : edges) {
            graph.addEdge(edge);
        }
        Set<Triple> ambiguousTriples = JsonUtils.parseJSONArrayToTetradTriples(jObj.getJSONArray("ambiguousTriples"));
        for (Triple triple : ambiguousTriples) {
            graph.addAmbiguousTriple(triple.getX(), triple.getY(), triple.getZ());
        }
        Set<Triple> set = JsonUtils.parseJSONArrayToTetradTriples(jObj.getJSONArray("underLineTriples"));
        for (Triple triple : set) {
            graph.addUnderlineTriple(triple.getX(), triple.getY(), triple.getZ());
        }
        Set<Triple> set2 = JsonUtils.parseJSONArrayToTetradTriples(jObj.getJSONArray("dottedUnderLineTriples"));
        for (Triple triple : set2) {
            graph.addDottedUnderlineTriple(triple.getX(), triple.getY(), triple.getZ());
        }
        graph.removeTriplesNotInGraph();
        return graph;
    }

    public static Set<Triple> parseJSONArrayToTetradTriples(JSONArray jArray) {
        HashSet<Triple> triples = new HashSet<Triple>();
        for (int i = 0; i < jArray.length(); ++i) {
            Triple triple = JsonUtils.parseJSONArrayToTetradTriple(jArray.getJSONObject(i));
            triples.add(triple);
        }
        return triples;
    }

    public static Triple parseJSONArrayToTetradTriple(JSONObject jObj) {
        Node x = JsonUtils.parseJSONObjectToTetradNode(jObj.getJSONObject("x"));
        Node y = JsonUtils.parseJSONObjectToTetradNode(jObj.getJSONObject("y"));
        Node z = JsonUtils.parseJSONObjectToTetradNode(jObj.getJSONObject("z"));
        return new Triple(x, y, z);
    }

    public static Set<Edge> parseJSONArrayToTetradEdges(Graph graph, JSONArray jArray) {
        HashSet<Edge> edges = new HashSet<Edge>();
        for (int i = 0; i < jArray.length(); ++i) {
            Edge edge = JsonUtils.parseJSONObjectToTetradEdge(graph, jArray.getJSONObject(i));
            edges.add(edge);
        }
        return edges;
    }

    public static Edge parseJSONObjectToTetradEdge(Graph graph, JSONObject jObj) {
        int i;
        JSONArray jArray2;
        Node node1 = graph.getNode(jObj.getJSONObject("node1").getString("name"));
        Node node2 = graph.getNode(jObj.getJSONObject("node2").getString("name"));
        Endpoint endpoint1 = Endpoint.valueOf(jObj.getString("endpoint1"));
        Endpoint endpoint2 = Endpoint.valueOf(jObj.getString("endpoint2"));
        Edge edge = new Edge(node1, node2, endpoint1, endpoint2);
        try {
            jArray2 = jObj.getJSONArray("properties");
            if (jArray2 != null) {
                for (i = 0; i < jArray2.length(); ++i) {
                    edge.addProperty(JsonUtils.parseJSONObjectToEdgeProperty(jArray2.getString(i)));
                }
            }
        }
        catch (JSONException jArray2) {
            // empty catch block
        }
        try {
            jArray2 = jObj.getJSONArray("edgeTypeProbabilities");
            if (jArray2 != null) {
                for (i = 0; i < jArray2.length(); ++i) {
                    edge.addEdgeTypeProbability(JsonUtils.parseJSONObjectToEdgeTypeProperty(jArray2.getJSONObject(i)));
                }
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return edge;
    }

    public static EdgeTypeProbability parseJSONObjectToEdgeTypeProperty(JSONObject jObj) {
        String _edgeType = jObj.getString("edgeType");
        EdgeTypeProbability.EdgeType edgeType = EdgeTypeProbability.EdgeType.nil;
        switch (_edgeType) {
            case "ta": {
                edgeType = EdgeTypeProbability.EdgeType.ta;
                break;
            }
            case "at": {
                edgeType = EdgeTypeProbability.EdgeType.at;
                break;
            }
            case "ca": {
                edgeType = EdgeTypeProbability.EdgeType.ca;
                break;
            }
            case "ac": {
                edgeType = EdgeTypeProbability.EdgeType.ac;
                break;
            }
            case "cc": {
                edgeType = EdgeTypeProbability.EdgeType.cc;
                break;
            }
            case "aa": {
                edgeType = EdgeTypeProbability.EdgeType.aa;
                break;
            }
            case "tt": {
                edgeType = EdgeTypeProbability.EdgeType.tt;
            }
        }
        double probability = jObj.getDouble("probability");
        EdgeTypeProbability edgeTypeProbability = new EdgeTypeProbability(edgeType, probability);
        try {
            JSONArray jArray = jObj.getJSONArray("properties");
            if (jArray != null) {
                for (int i = 0; i < jArray.length(); ++i) {
                    edgeTypeProbability.addProperty(JsonUtils.parseJSONObjectToEdgeProperty(jArray.getString(i)));
                }
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return edgeTypeProbability;
    }

    public static Edge.Property parseJSONObjectToEdgeProperty(String prop) {
        if (prop.equalsIgnoreCase("dd")) {
            return Edge.Property.dd;
        }
        if (prop.equalsIgnoreCase("nl")) {
            return Edge.Property.nl;
        }
        if (prop.equalsIgnoreCase("pd")) {
            return Edge.Property.pd;
        }
        if (prop.equalsIgnoreCase("pl")) {
            return Edge.Property.pl;
        }
        return null;
    }

    public static List<Node> parseJSONArrayToTetradNodes(JSONArray jArray) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (int i = 0; i < jArray.length(); ++i) {
            Node node = JsonUtils.parseJSONObjectToTetradNode(jArray.getJSONObject(i));
            nodes.add(node);
        }
        return nodes;
    }

    public static Node parseJSONObjectToTetradNode(JSONObject jObj) {
        JSONObject nodeType = jObj.getJSONObject("nodeType");
        int ordinal = nodeType.getInt("ordinal");
        int centerX = jObj.getInt("centerX");
        int centerY = jObj.getInt("centerY");
        String name = jObj.getString("name");
        GraphNode graphNode = new GraphNode(name);
        graphNode.setNodeType(NodeType.TYPES[ordinal]);
        graphNode.setCenter(centerX, centerY);
        return graphNode;
    }
}

