/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.util;

import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;

public class LogUtils {
    private static final LogUtils INSTANCE = new LogUtils();
    private final Logger logger = Logger.getLogger("tetradlog");
    private final Map<OutputStream, StreamHandler> streams = new HashMap<OutputStream, StreamHandler>();

    private LogUtils() {
        this.logger.setUseParentHandlers(false);
        this.logger.setLevel(Level.FINEST);
    }

    public static LogUtils getInstance() {
        return INSTANCE;
    }

    public void add(OutputStream stream, Level level) {
        if (stream == null) {
            throw new NullPointerException();
        }
        if (level == null) {
            throw new NullPointerException();
        }
        SimpleFormatter formatter = new SimpleFormatter(){

            @Override
            public synchronized String format(LogRecord record) {
                return record.getMessage() + "\n";
            }
        };
        StreamHandler handler = new StreamHandler(stream, formatter);
        handler.setLevel(level);
        this.streams.put(stream, handler);
        this.getLogger().addHandler(handler);
    }

    public void setLevel(OutputStream stream, Level level) {
        Handler handler = this.streams.get(stream);
        if (handler != null) {
            handler.setLevel(level);
        }
    }

    private void remove(OutputStream stream) {
        if (stream == null) {
            return;
        }
        Handler handler = this.streams.get(stream);
        if (handler == null) {
            return;
        }
        handler.flush();
        if (stream != System.out) {
            handler.close();
        }
        this.getLogger().removeHandler(handler);
    }

    public void clear() {
        for (OutputStream stream : this.streams.keySet()) {
            this.remove(stream);
        }
    }

    public void severe(String s) {
        this.getLogger().severe(s);
    }

    public void warning(String s) {
        this.getLogger().warning(s);
        this.flushAll();
    }

    public void config(String s) {
        this.getLogger().config(s);
        this.flushAll();
    }

    public void info(String s) {
        this.getLogger().info(s);
        this.flushAll();
    }

    public void fine(String s) {
        this.getLogger().fine(s);
        this.flushAll();
    }

    public void finer(String s) {
        this.getLogger().finer(s);
        this.flushAll();
    }

    public void finest(String s) {
        this.getLogger().finest(s);
        this.flushAll();
    }

    private Logger getLogger() {
        return this.logger;
    }

    private void flushAll() {
        for (OutputStream stream : this.streams.keySet()) {
            Handler handler = this.streams.get(stream);
            handler.flush();
        }
    }
}

