/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.util;

import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import edu.cmu.tetrad.util.MatrixUtils;
import edu.cmu.tetrad.util.TetradSerializable;
import edu.cmu.tetrad.util.Vector;
import java.io.IOException;
import java.io.ObjectInputStream;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.BlockRealMatrix;
import org.apache.commons.math3.linear.CholeskyDecomposition;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.OpenMapRealMatrix;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.SingularMatrixException;
import org.apache.commons.math3.linear.SingularValueDecomposition;
import org.apache.commons.math3.util.FastMath;

public class Matrix
implements TetradSerializable {
    private static final long serialVersionUID = 23L;
    private final RealMatrix apacheData;
    private int m;
    private int n;

    public Matrix(double[][] data) {
        this.apacheData = data.length == 0 ? new Array2DRowRealMatrix() : new BlockRealMatrix(data);
        this.m = data.length;
        this.n = this.m == 0 ? 0 : data[0].length;
    }

    public Matrix(RealMatrix data) {
        this.apacheData = data;
        this.m = data.getRowDimension();
        this.n = data.getColumnDimension();
    }

    public Matrix(int m, int n) {
        this.apacheData = m == 0 || n == 0 ? new Array2DRowRealMatrix() : new BlockRealMatrix(m, n);
        this.m = m;
        this.n = n;
    }

    public Matrix(Matrix m) {
        this(m.apacheData.copy());
    }

    public static Matrix identity(int rows) {
        Matrix m = new Matrix(rows, rows);
        for (int i = 0; i < rows; ++i) {
            m.set(i, i, 1.0);
        }
        return m;
    }

    public static Matrix sparseMatrix(int m, int n) {
        return new Matrix(new OpenMapRealMatrix(m, n).getData());
    }

    public static Matrix serializableInstance() {
        return new Matrix(0, 0);
    }

    public void assign(Matrix matrix) {
        if (this.apacheData.getRowDimension() != matrix.getNumRows() || this.apacheData.getColumnDimension() != matrix.getNumColumns()) {
            throw new IllegalArgumentException("Mismatched matrix size.");
        }
        for (int i = 0; i < this.apacheData.getRowDimension(); ++i) {
            for (int j = 0; j < this.apacheData.getColumnDimension(); ++j) {
                this.apacheData.setEntry(i, j, matrix.get(i, j));
            }
        }
    }

    public int getNumColumns() {
        return this.n;
    }

    public Vector diag() {
        double[] diag = new double[this.apacheData.getRowDimension()];
        for (int i = 0; i < this.apacheData.getRowDimension(); ++i) {
            diag[i] = this.apacheData.getEntry(i, i);
        }
        return new Vector(diag);
    }

    public Matrix getSelection(int[] rows, int[] cols) {
        Matrix m = new Matrix(rows.length, cols.length);
        for (int i = 0; i < rows.length; ++i) {
            for (int j = 0; j < cols.length; ++j) {
                m.set(i, j, this.apacheData.getEntry(rows[i], cols[j]));
            }
        }
        return m;
    }

    public Matrix copy() {
        if (this.zeroDimension()) {
            return new Matrix(this.getNumRows(), this.getNumColumns());
        }
        return new Matrix(this.apacheData.copy());
    }

    public Vector getColumn(int j) {
        if (this.zeroDimension()) {
            return new Vector(this.getNumRows());
        }
        return new Vector(this.apacheData.getColumn(j));
    }

    public Matrix times(Matrix m) {
        if (this.zeroDimension() || m.zeroDimension()) {
            return new Matrix(this.getNumRows(), m.getNumColumns());
        }
        return new Matrix(this.apacheData.multiply(m.apacheData));
    }

    public Vector times(Vector v) {
        if (v.size() != this.apacheData.getColumnDimension()) {
            throw new IllegalArgumentException("Mismatched dimensions.");
        }
        double[] y = new double[this.apacheData.getRowDimension()];
        for (int i = 0; i < this.apacheData.getRowDimension(); ++i) {
            double sum = 0.0;
            for (int j = 0; j < this.apacheData.getColumnDimension(); ++j) {
                sum += this.apacheData.getEntry(i, j) * v.get(j);
            }
            y[i] = sum;
        }
        return new Vector(y);
    }

    public double[][] toArray() {
        return this.apacheData.getData();
    }

    public RealMatrix getApacheData() {
        return this.apacheData;
    }

    public double get(int i, int j) {
        return this.apacheData.getEntry(i, j);
    }

    public Matrix like() {
        return new Matrix(this.apacheData.getRowDimension(), this.apacheData.getColumnDimension());
    }

    public void set(int i, int j, double v) {
        this.apacheData.setEntry(i, j, v);
    }

    public Vector getRow(int i) {
        if (this.zeroDimension()) {
            return new Vector(this.getNumColumns());
        }
        return new Vector(this.apacheData.getRow(i));
    }

    public Matrix getPart(int i, int j, int k, int l) {
        return new Matrix(this.apacheData.getSubMatrix(i, j, k, l));
    }

    public Matrix inverse() throws SingularMatrixException {
        if (!this.isSquare()) {
            throw new IllegalArgumentException("I can only invert square matrices.");
        }
        if (this.getNumRows() == 0) {
            return new Matrix(0, 0);
        }
        return new Matrix(new LUDecomposition(this.apacheData, 1.0E-10).getSolver().getInverse());
    }

    public Matrix symmetricInverse() {
        if (!this.isSquare()) {
            throw new IllegalArgumentException();
        }
        if (this.getNumRows() == 0) {
            return new Matrix(0, 0);
        }
        return new Matrix(new CholeskyDecomposition(this.apacheData).getSolver().getInverse());
    }

    public Matrix ginverse() {
        double[][] data = this.apacheData.getData();
        if (data.length == 0 || data[0].length == 0) {
            return new Matrix(data);
        }
        return new Matrix(MatrixUtils.pseudoInverse(data));
    }

    public void assignRow(int row, Vector doubles) {
        this.apacheData.setRow(row, doubles.toArray());
    }

    public void assignColumn(int col, Vector doubles) {
        this.apacheData.setColumn(col, doubles.toArray());
    }

    public double trace() {
        return this.apacheData.getTrace();
    }

    public double det() {
        return new LUDecomposition(this.apacheData, 1.0E-6).getDeterminant();
    }

    public Matrix transpose() {
        if (this.zeroDimension()) {
            return new Matrix(this.getNumColumns(), this.getNumRows());
        }
        return new Matrix(this.apacheData.transpose());
    }

    public boolean equals(Matrix m, double tolerance) {
        for (int i = 0; i < this.apacheData.getRowDimension(); ++i) {
            for (int j = 0; j < this.apacheData.getColumnDimension(); ++j) {
                if (!(FastMath.abs(this.apacheData.getEntry(i, j) - m.apacheData.getEntry(i, j)) > tolerance)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isSquare() {
        return this.getNumRows() == this.getNumColumns();
    }

    public boolean isSymmetric(double tolerance) {
        return MatrixUtils.isSymmetric(this.apacheData.getData(), tolerance);
    }

    public Matrix minus(Matrix mb) {
        if (mb.getNumRows() == 0 || mb.getNumColumns() == 0) {
            return this;
        }
        return new Matrix(this.apacheData.subtract(mb.apacheData));
    }

    public double norm1() {
        return this.apacheData.getNorm();
    }

    public Matrix plus(Matrix mb) {
        if (mb.getNumRows() == 0 || mb.getNumColumns() == 0) {
            return this;
        }
        return new Matrix(this.apacheData.add(mb.apacheData));
    }

    public int rank() {
        SingularValueDecomposition singularValueDecomposition = new SingularValueDecomposition(this.apacheData);
        return singularValueDecomposition.getRank();
    }

    public int getNumRows() {
        return this.m;
    }

    public Matrix scalarMult(double scalar) {
        Matrix newMatrix = this.copy();
        for (int i = 0; i < this.getNumRows(); ++i) {
            for (int j = 0; j < this.getNumColumns(); ++j) {
                newMatrix.set(i, j, this.get(i, j) * scalar);
            }
        }
        return newMatrix;
    }

    public Matrix sqrt() {
        SingularValueDecomposition svd = new SingularValueDecomposition(this.apacheData);
        RealMatrix U = svd.getU();
        RealMatrix V = svd.getV();
        double[] s = svd.getSingularValues();
        for (int i = 0; i < s.length; ++i) {
            s[i] = 1.0 / s[i];
        }
        BlockRealMatrix S = new BlockRealMatrix(s.length, s.length);
        for (int i = 0; i < s.length; ++i) {
            S.setEntry(i, i, s[i]);
        }
        RealMatrix sqrt = U.multiply(S).multiply(V);
        return new Matrix(sqrt);
    }

    public Vector sum(int direction) {
        if (direction == 1) {
            Vector sums = new Vector(this.getNumColumns());
            for (int j = 0; j < this.getNumColumns(); ++j) {
                double sum = 0.0;
                for (int i = 0; i < this.getNumRows(); ++i) {
                    sum += this.apacheData.getEntry(i, j);
                }
                sums.set(j, sum);
            }
            return sums;
        }
        if (direction == 2) {
            Vector sums = new Vector(this.getNumRows());
            for (int i = 0; i < this.getNumRows(); ++i) {
                double sum = 0.0;
                for (int j = 0; j < this.getNumColumns(); ++j) {
                    sum += this.apacheData.getEntry(i, j);
                }
                sums.set(i, sum);
            }
            return sums;
        }
        throw new IllegalArgumentException("Expecting 1 (sum columns) or 2 (sum rows).");
    }

    public double zSum() {
        return new DenseDoubleMatrix2D(this.apacheData.getData()).zSum();
    }

    private boolean zeroDimension() {
        return this.getNumRows() == 0 || this.getNumColumns() == 0;
    }

    public String toString() {
        if (this.getNumRows() == 0) {
            return "Empty";
        }
        return MatrixUtils.toString(this.toArray());
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.m == 0) {
            this.m = this.apacheData.getRowDimension();
        }
        if (this.n == 0) {
            this.n = this.apacheData.getColumnDimension();
        }
    }
}

