/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.util;

import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.linalg.Property;
import edu.cmu.tetrad.util.Matrix;
import edu.cmu.tetrad.util.RandomUtil;
import edu.cmu.tetrad.util.TetradAlgebra;
import edu.cmu.tetrad.util.TextTable;
import edu.cmu.tetrad.util.Vector;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.linear.AbstractRealMatrix;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.BlockRealMatrix;
import org.apache.commons.math3.linear.CholeskyDecomposition;
import org.apache.commons.math3.linear.EigenDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.SingularValueDecomposition;
import org.apache.commons.math3.util.FastMath;

public final class MatrixUtils {
    public static double[][] repmat(double[][] mat, int nRow, int mColumn) {
        int numOfRow = mat.length;
        double[][] repMat = new double[numOfRow * nRow][];
        for (int row = 0; row < numOfRow; ++row) {
            repMat[row] = MatrixUtils.repeatCopyVector(mat[row], mColumn);
        }
        MatrixUtils.repeatCopyRow(repMat, --nRow, numOfRow, numOfRow);
        return repMat;
    }

    public static double[][] repmat(double[][] mat, int n) {
        int numOfRow = mat.length;
        double[][] repMat = new double[numOfRow * n][];
        for (int row = 0; row < numOfRow; ++row) {
            repMat[row] = MatrixUtils.repeatCopyVector(mat[row], n);
        }
        MatrixUtils.repeatCopyRow(repMat, --n, numOfRow, numOfRow);
        return repMat;
    }

    private static void repeatCopyRow(double[][] mat, int n, int startRowPos, int numOfRow) {
        for (int i = 0; i < n; ++i) {
            for (int row = 0; row < numOfRow; ++row) {
                double[] src = mat[row];
                double[] dest = new double[src.length];
                System.arraycopy(src, 0, dest, 0, src.length);
                mat[startRowPos++] = dest;
            }
        }
    }

    private static double[] repeatCopyVector(double[] src, int n) {
        double[] dest = new double[src.length * n];
        for (int i = 0; i < n; ++i) {
            System.arraycopy(src, 0, dest, i * src.length, src.length);
        }
        return dest;
    }

    public static boolean equals(double[][] ma, double[][] mb) {
        if (ma.length != mb.length) {
            return false;
        }
        for (int i = 0; i < ma.length; ++i) {
            double[] _ma = ma[i];
            double[] _mb = mb[i];
            if (Arrays.equals(_ma, _mb)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(double[] va, double[] vb) {
        return Arrays.equals(va, vb);
    }

    public static boolean equals(double[][] ma, double[][] mb, double tolerance) {
        return new Matrix(ma).equals(new Matrix(mb), tolerance);
    }

    public static boolean equals(double[] va, double[] vb, double tolerance) {
        return new Property(tolerance).equals((DoubleMatrix1D)new DenseDoubleMatrix1D(va), new DenseDoubleMatrix1D(vb));
    }

    public static boolean isSquare(double[][] m) {
        return new Matrix(m).isSquare();
    }

    public static boolean isSymmetric(double[][] m, double tolerance) {
        for (int i = 0; i < m.length; ++i) {
            for (int j = i; j < m[0].length; ++j) {
                if (!(FastMath.abs(m[i][j] - m[j][i]) > tolerance)) continue;
                return false;
            }
        }
        return true;
    }

    public static double determinant(double[][] m) {
        return new Matrix(m).det();
    }

    public static double[][] submatrix(double[][] m, int rem) {
        int[] indices = new int[m.length];
        int j = -1;
        for (int i = 0; i < m.length; ++i) {
            if (++j == rem) {
                // empty if block
            }
            indices[i] = ++j;
        }
        return new Matrix(m).getSelection(indices, indices).toArray();
    }

    public static double[][] inverse(double[][] m) {
        Matrix mm = new Matrix(m);
        return mm.inverse().toArray();
    }

    public static double[][] pseudoInverse(double[][] x) {
        SingularValueDecomposition svd = new SingularValueDecomposition(new BlockRealMatrix(x));
        RealMatrix U = svd.getU();
        RealMatrix V = svd.getV();
        RealMatrix S = svd.getS();
        for (int i = 0; i < S.getRowDimension(); ++i) {
            for (int j = 0; j < S.getColumnDimension(); ++j) {
                double v = S.getEntry(i, j);
                S.setEntry(i, j, v == 0.0 ? 0.0 : 1.0 / v);
            }
        }
        return V.multiply(S.multiply(U.transpose())).getData();
    }

    public static double[][] product(double[][] ma, double[][] mb) {
        Matrix d = new Matrix(ma);
        Matrix e = new Matrix(mb);
        return d.times(e).toArray();
    }

    public static double[] product(double[] ma, double[][] mb) {
        return new Matrix(mb).transpose().times(new Vector(ma)).toArray();
    }

    public static Vector product(Vector ma, Matrix mb) {
        return mb.transpose().times(ma);
    }

    public static double[] product(double[][] ma, double[] mb) {
        return new Matrix(ma).times(new Vector(mb)).toArray();
    }

    public static double[][] outerProduct(double[] ma, double[] mb) {
        return TetradAlgebra.multOuter(new Vector(ma), new Vector(mb)).toArray();
    }

    public static double innerProduct(double[] ma, double[] mb) {
        return new Vector(ma).dotProduct(new Vector(mb));
    }

    public static double[][] transpose(double[][] m) {
        return new Matrix(m).transpose().toArray();
    }

    public static double trace(double[][] m) {
        return new Matrix(m).trace();
    }

    public static double zSum(double[][] m) {
        return new Matrix(m).zSum();
    }

    public static double[][] identity(int size) {
        return Matrix.identity(size).toArray();
    }

    public static double[][] sum(double[][] ma, double[][] mb) {
        Matrix _ma = new Matrix(ma);
        Matrix _mb = new Matrix(mb);
        _ma = _ma.plus(_mb);
        return _ma.toArray();
    }

    public static double[] sum(double[] ma, double[] mb) {
        Vector _ma = new Vector(ma);
        Vector _mb = new Vector(mb);
        _ma = _ma.plus(_mb);
        return _ma.toArray();
    }

    public static double[][] subtract(double[][] ma, double[][] mb) {
        Matrix _ma = new Matrix(ma);
        Matrix _mb = new Matrix(mb);
        _ma = _ma.minus(_mb);
        return _ma.toArray();
    }

    public static double[] subtract(double[] ma, double[] mb) {
        Vector _ma = new Vector(ma);
        Vector _mb = new Vector(mb);
        _ma = _ma.minus(_mb);
        return _ma.toArray();
    }

    public static double[][] directProduct(double[][] ma, double[][] mb) {
        int arow = ma.length;
        int brow = mb.length;
        int acol = ma[0].length;
        int bcol = mb[0].length;
        double[][] product = new double[arow * brow][acol * bcol];
        for (int i1 = 0; i1 < arow; ++i1) {
            for (int j1 = 0; j1 < acol; ++j1) {
                for (int i2 = 0; i2 < brow; ++i2) {
                    for (int j2 = 0; j2 < bcol; ++j2) {
                        int i = i1 * brow + i2;
                        int j = j1 * bcol + j2;
                        product[i][j] = ma[i1][j1] * mb[i2][j2];
                    }
                }
            }
        }
        return product;
    }

    public static double[][] scalarProduct(double scalar, double[][] m) {
        Matrix _m = new Matrix(m);
        return _m.scalarMult(scalar).toArray();
    }

    public static double[] scalarProduct(double scalar, double[] m) {
        Vector _m = new Vector(m);
        _m = _m.scalarMult(scalar);
        return _m.toArray();
    }

    public static double[] concatenate(double[][] vectors) {
        int numVectors = vectors.length;
        int length = vectors[0].length;
        double[] concat = new double[numVectors * length];
        for (int i = 0; i < vectors.length; ++i) {
            System.arraycopy(vectors[i], 0, concat, i * length, length);
        }
        return concat;
    }

    public static double[][] asRow(double[] v) {
        double[][] arr = new double[1][v.length];
        System.arraycopy(v, 0, arr[0], 0, v.length);
        return arr;
    }

    private static double[][] asCol(double[] v) {
        double[][] arr = new double[v.length][1];
        for (int i = 0; i < v.length; ++i) {
            arr[i][0] = v[i];
        }
        return arr;
    }

    public static Matrix impliedCovar2(Matrix edgeCoef, Matrix errCovar) {
        if (MatrixUtils.containsNaN(edgeCoef)) {
            throw new IllegalArgumentException("Edge coefficient matrix must not contain undefined values. Probably the search put them there.");
        }
        if (MatrixUtils.containsNaN(errCovar)) {
            throw new IllegalArgumentException("Error covariance matrix must not contain undefined values. Probably the search put them there.");
        }
        int sampleSize = 10000;
        Matrix iMinusBInverse = Matrix.identity(edgeCoef.getNumRows()).minus(edgeCoef).inverse();
        Matrix sample = new Matrix(10000, edgeCoef.getNumColumns());
        Vector e = new Vector(edgeCoef.getNumColumns());
        for (int i = 0; i < 10000; ++i) {
            for (int j = 0; j < e.size(); ++j) {
                e.set(j, RandomUtil.getInstance().nextNormal(0.0, errCovar.get(j, j)));
            }
            sample.assignRow(i, iMinusBInverse.times(e));
        }
        return sample.transpose().times(sample).scalarMult(1.0E-4);
    }

    public static Matrix impliedCovar(Matrix edgeCoef, Matrix errCovar) {
        if (MatrixUtils.containsNaN(edgeCoef)) {
            System.out.println(edgeCoef);
            throw new IllegalArgumentException("Edge coefficient matrix must not contain undefined values. Probably the search put them there.");
        }
        if (MatrixUtils.containsNaN(errCovar)) {
            throw new IllegalArgumentException("Error covariance matrix must not contain undefined values. Probably the search put them there.");
        }
        Matrix m1 = Matrix.identity(edgeCoef.getNumRows()).minus(edgeCoef);
        Matrix m3 = m1.inverse();
        Matrix m4 = m3.transpose();
        Matrix m5 = m3.times(errCovar);
        return m5.times(m4);
    }

    private static boolean containsNaN(Matrix m) {
        for (int i = 0; i < m.getNumRows(); ++i) {
            for (int j = 0; j < m.getNumColumns(); ++j) {
                if (!Double.isNaN(m.get(i, j))) continue;
                return true;
            }
        }
        return false;
    }

    public static double[][] vech(double[][] m) {
        if (!MatrixUtils.isSymmetric(m, 1.0E-5)) {
            throw new IllegalArgumentException("m must be a symmetric matrix.");
        }
        int order = m.length;
        int vechSize = MatrixUtils.sum0ToN(order);
        double[] vech = new double[vechSize];
        int index = -1;
        for (int i = 0; i < order; ++i) {
            for (int j = i; j < order; ++j) {
                vech[++index] = m[i][j];
            }
        }
        return MatrixUtils.asCol(vech);
    }

    public static double[][] invVech(double[] vech) {
        int order = MatrixUtils.vechOrder(vech);
        double[][] m = new double[order][order];
        int index = -1;
        for (int i = 0; i < order; ++i) {
            for (int j = i; j < order; ++j) {
                m[i][j] = vech[++index];
                m[j][i] = vech[index];
            }
        }
        return m;
    }

    public static double[][] vec(double[][] m) {
        assert (MatrixUtils.isSquare(m));
        int order = m.length;
        int vecSize = order * order;
        double[] vec = new double[vecSize];
        int index = -1;
        for (double[] aM : m) {
            for (int j = 0; j < order; ++j) {
                vec[++index] = aM[j];
            }
        }
        return MatrixUtils.asCol(vec);
    }

    public static int sum0ToN(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Argument must be >= 0: " + n);
        }
        return n * (n + 1) / 2;
    }

    public static double[][] vechToVecLeft(int n) {
        int row = n * n;
        int col = MatrixUtils.sum0ToN(n);
        double[][] m = new double[row][col];
        int index = -1;
        for (int i = 0; i < n; ++i) {
            for (int j = i; j < n; ++j) {
                int _row = i * n + j;
                int _col = ++index;
                m[_row][_col] = 1.0;
                _row = j * n + i;
                _col = index;
                m[_row][_col] = 1.0;
            }
        }
        return m;
    }

    public static boolean hasDimensions(double[][] m, int i, int j) {
        Matrix _m = new Matrix(m);
        return _m.getNumRows() == i && _m.getNumColumns() == j;
    }

    public static double[][] zeros(int rows, int cols) {
        return new Matrix(rows, cols).toArray();
    }

    public static boolean isPositiveDefinite(Matrix matrix) {
        double[] eigenvalues;
        Array2DRowRealMatrix realMatrix = new Array2DRowRealMatrix(matrix.toArray());
        EigenDecomposition eigenDecomposition = new EigenDecomposition(realMatrix);
        for (double eigenvalue : eigenvalues = eigenDecomposition.getRealEigenvalues()) {
            if (!(eigenvalue <= 0.0)) continue;
            return false;
        }
        return true;
    }

    public static Matrix cholesky(Matrix covar) {
        RealMatrix L = new CholeskyDecomposition(new BlockRealMatrix(covar.toArray())).getL();
        return new Matrix(L.getData());
    }

    public static Matrix convertCovToCorr(Matrix m) {
        int i;
        if (m.getNumRows() != m.getNumColumns()) {
            throw new IllegalArgumentException("Not a square matrix.");
        }
        if (!MatrixUtils.isSymmetric(m.toArray(), 0.001)) {
            throw new IllegalArgumentException("Not symmetric with tolerance 0.001");
        }
        Matrix corr = m.like();
        for (i = 0; i < m.getNumRows(); ++i) {
            for (int j = i + 1; j < m.getNumColumns(); ++j) {
                double v = m.get(i, j) / FastMath.sqrt(m.get(i, i) * m.get(j, j));
                corr.set(i, j, v);
                corr.set(j, i, v);
            }
        }
        for (i = 0; i < m.getNumColumns(); ++i) {
            corr.set(i, i, 1.0);
        }
        return corr;
    }

    public static double[][] convertLowerTriangleToSymmetric(double[][] arr) {
        int size = arr.length;
        double[][] m = new double[size][size];
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j <= i; ++j) {
                m[i][j] = arr[i][j];
                m[j][i] = arr[i][j];
            }
        }
        return m;
    }

    public static String toString(double[][] m) {
        DecimalFormat nf = new DecimalFormat(" 0.0000;-0.0000");
        return MatrixUtils.toString(m, (NumberFormat)nf);
    }

    public static String toString(double[][] m, List<String> variables) {
        DecimalFormat nf = new DecimalFormat(" 0.0000;-0.0000");
        return MatrixUtils.toString(m, nf, variables);
    }

    private static String toString(double[][] m, NumberFormat nf) {
        return MatrixUtils.toString(m, nf, null);
    }

    private static String toString(double[][] m, NumberFormat nf, List<String> variables) {
        String result;
        if (nf == null) {
            throw new NullPointerException("NumberFormat must not be null.");
        }
        if (variables == null) {
            variables = new ArrayList<String>();
            if (m.length > 0) {
                for (int i = 0; i < m[0].length; ++i) {
                    variables.add("V" + (i + 1));
                }
            }
        }
        if (m == null) {
            result = MatrixUtils.nullMessage();
        } else if (m.length > 0) {
            int i;
            TextTable textTable = new TextTable(m.length + 1, m[0].length);
            for (i = 0; i < variables.size(); ++i) {
                textTable.setToken(0, i, variables.get(i));
            }
            for (i = 0; i < m.length; ++i) {
                for (int j = 0; j < m[0].length; ++j) {
                    textTable.setToken(i + 1, j, m[i][j] == 0.0 ? " " : nf.format(m[i][j]));
                }
            }
            result = "\n" + textTable;
        } else {
            result = MatrixUtils.nullMessage();
        }
        return result;
    }

    public static String toStringSquare(double[][] m, List<String> variables) {
        DecimalFormat nf = new DecimalFormat(" 0.0000;-0.0000");
        return MatrixUtils.toStringSquare(m, nf, variables);
    }

    public static String toStringSquare(double[][] m, NumberFormat nf, List<String> variables) {
        String result;
        if (nf == null) {
            throw new NullPointerException("NumberFormat must not be null.");
        }
        if (variables == null) {
            variables = new ArrayList<String>();
            for (int i = 0; i < m.length; ++i) {
                variables.add("V" + (i + 1));
            }
        }
        if (m == null) {
            result = MatrixUtils.nullMessage();
        } else {
            int i;
            TextTable textTable = new TextTable(m.length + 1, m[0].length + 1);
            for (i = 0; i < variables.size(); ++i) {
                textTable.setToken(0, i + 1, variables.get(i));
            }
            for (i = 0; i < m.length; ++i) {
                textTable.setToken(i + 1, 0, variables.get(i));
                for (int j = 0; j < m[0].length; ++j) {
                    textTable.setToken(i + 1, j + 1, nf.format(m[i][j]));
                }
            }
            result = "\n" + textTable;
        }
        return result;
    }

    public static String toString(int[] m) {
        StringBuilder buf = new StringBuilder();
        for (int aM : m) {
            buf.append(aM).append("\t");
        }
        return buf.toString();
    }

    public static String toString(int[][] m, List<String> variables) {
        String result;
        if (variables == null) {
            variables = new ArrayList<String>();
            for (int i = 0; i < m.length; ++i) {
                variables.add("V" + (i + 1));
            }
        }
        if (m == null) {
            result = MatrixUtils.nullMessage();
        } else {
            int i;
            TextTable textTable = new TextTable(m.length + 1, m[0].length);
            for (i = 0; i < variables.size(); ++i) {
                textTable.setToken(0, i, variables.get(i));
            }
            for (i = 0; i < m.length; ++i) {
                for (int j = 0; j < m[0].length; ++j) {
                    textTable.setToken(i + 1, j, Integer.toString(m[i][j]));
                }
            }
            result = "\n" + textTable;
        }
        return result;
    }

    public static String toStringSquare(int[][] m, List<String> variables) {
        String result;
        if (m == null) {
            result = MatrixUtils.nullMessage();
        } else {
            int i;
            if (variables == null) {
                variables = new ArrayList<String>();
                for (int i2 = 0; i2 < m.length; ++i2) {
                    variables.add("V" + (i2 + 1));
                }
            }
            TextTable textTable = new TextTable(m.length + 1, m[0].length + 1);
            for (i = 0; i < variables.size(); ++i) {
                textTable.setToken(0, i + 1, variables.get(i));
            }
            for (i = 0; i < m.length; ++i) {
                textTable.setToken(i + 1, 0, variables.get(i));
                for (int j = 0; j < m[0].length; ++j) {
                    textTable.setToken(i + 1, j + 1, Integer.toString(m[i][j]));
                }
            }
            result = "\n" + textTable;
        }
        return result;
    }

    public static String toString(double[] m) {
        StringBuilder buf = new StringBuilder();
        for (double aM : m) {
            buf.append(aM).append("\t");
        }
        return buf.toString();
    }

    public static String toString(double[] m, NumberFormat nf) {
        StringBuilder buf = new StringBuilder();
        for (double aM : m) {
            buf.append(nf.format(aM)).append("\t");
        }
        return buf.toString();
    }

    public static String toString(int[][] m) {
        TextTable textTable = new TextTable(m.length, m[0].length);
        for (int i = 0; i < m.length; ++i) {
            for (int j = 0; j < m[0].length; ++j) {
                textTable.setToken(i, j, Integer.toString(m[i][j]));
            }
        }
        return "\n" + textTable;
    }

    public static String toString(boolean[][] m) {
        String result;
        if (m == null) {
            result = MatrixUtils.nullMessage();
        } else {
            TextTable textTable = new TextTable(m.length, m[0].length);
            for (int i = 0; i < m.length; ++i) {
                for (int j = 0; j < m[0].length; ++j) {
                    textTable.setToken(i, j, Boolean.toString(m[i][j]));
                }
            }
            result = "\n" + textTable;
        }
        return result;
    }

    private static String nullMessage() {
        return "\n\t<Matrix is null>";
    }

    private static int vechOrder(double[] vech) {
        int difference = vech.length;
        int order = 0;
        while (difference > 0) {
            if ((difference -= ++order) >= 0) continue;
            throw new IllegalArgumentException("Illegal length for vech: " + vech.length);
        }
        return order;
    }

    public static int[] copyOf(int[] arr, int length) {
        int[] copy = new int[arr.length];
        System.arraycopy(arr, 0, copy, 0, length);
        return copy;
    }

    public static double[][] copyOf(double[][] arr) {
        double[][] copy = new double[arr.length][arr[0].length];
        for (int i = 0; i < arr.length; ++i) {
            System.arraycopy(arr[i], 0, copy[i], 0, arr[0].length);
        }
        return copy;
    }

    public static RealMatrix transposeWithoutCopy(final RealMatrix apacheData) {
        return new AbstractRealMatrix(apacheData.getColumnDimension(), apacheData.getRowDimension()){

            @Override
            public int getRowDimension() {
                return apacheData.getColumnDimension();
            }

            @Override
            public int getColumnDimension() {
                return apacheData.getRowDimension();
            }

            @Override
            public RealMatrix createMatrix(int rowDimension, int columnDimension) throws NotStrictlyPositiveException {
                return apacheData.createMatrix(rowDimension, columnDimension);
            }

            @Override
            public RealMatrix copy() {
                throw new IllegalArgumentException("Can't copy");
            }

            @Override
            public double getEntry(int i, int j) throws OutOfRangeException {
                return apacheData.getEntry(j, i);
            }

            @Override
            public void setEntry(int i, int j, double v) throws OutOfRangeException {
                throw new UnsupportedOperationException();
            }
        };
    }
}

