/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.util;

import java.util.HashMap;
import java.util.Map;

public class MultiDimIntTable {
    private Map<Integer, Long> cells;
    private int numCells;
    private int[] dims;

    public MultiDimIntTable(int[] dims) {
        this.reset(dims);
    }

    public int getCellIndex(int[] coords) {
        int cellIndex = 0;
        for (int i = 0; i < this.dims.length; ++i) {
            cellIndex *= this.dims[i];
            cellIndex += coords[i];
        }
        return cellIndex;
    }

    public int[] getCoordinates(int cellIndex) {
        int[] coords = new int[this.dims.length];
        for (int i = this.dims.length - 1; i >= 0; --i) {
            coords[i] = cellIndex % this.dims[i];
            cellIndex /= this.dims[i];
        }
        return coords;
    }

    public long increment(int[] coords, int value) {
        int cellIndex = this.getCellIndex(coords);
        if (!this.cells.containsKey(cellIndex)) {
            this.cells.put(cellIndex, 0L);
        }
        this.cells.put(cellIndex, this.cells.get(cellIndex) + (long)value);
        return this.cells.get(cellIndex);
    }

    public long setValue(int[] coords, int value) {
        int cellIndex = this.getCellIndex(coords);
        this.cells.put(cellIndex, Long.valueOf(value));
        return this.cells.get(cellIndex);
    }

    public long getValue(int[] coords) {
        int cellIndex = this.getCellIndex(coords);
        if (this.cells == null || !this.cells.containsKey(cellIndex)) {
            return 0L;
        }
        return this.cells.get(cellIndex);
    }

    public int getNumCells() {
        return this.numCells;
    }

    public int[] getDimensions() {
        return this.dims;
    }

    public int getDimension(int var) {
        return this.dims[var];
    }

    public int getNumDimensions() {
        return this.dims.length;
    }

    public final void reset(int[] dims) {
        if (dims == null) {
            this.cells = null;
        } else {
            if (dims.length < 1) {
                throw new IllegalArgumentException("Table must have at least one dimension.");
            }
            this.numCells = 1;
            for (int dim : dims) {
                this.numCells *= dim;
            }
            this.cells = new HashMap<Integer, Long>();
            this.dims = new int[dims.length];
            System.arraycopy(dims, 0, this.dims, 0, dims.length);
        }
    }

    public int getDims(int varIndex) {
        return this.dims[varIndex];
    }
}

