/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.util;

import cern.jet.stat.Probability;
import edu.cmu.tetrad.util.Matrix;
import edu.cmu.tetrad.util.MatrixUtils;
import edu.cmu.tetrad.util.RandomUtil;
import org.apache.commons.math3.util.FastMath;

public class ProbUtils {
    private static final double[] r = new double[]{1.2533141373155003, 1.1931829647319152, 1.1374909212036046, 1.0858270274680037, 1.0378245758537268, 0.9931557904881572, 0.9515271920712067, 0.9126755670832122, 0.8763644564536923, 0.84238109145213, 0.8105337152790304, 0.7806492378708634, 0.7525711790634081, 0.7261578617139919, 0.7012808218544301, 0.6778234075911775, 0.6556795424187984, 0.6347526319769262, 0.6149545961509297, 0.5962050108690213, 0.5784303460476311, 0.5615632879362914, 0.545542135658217, 0.5303102630712526, 0.5158156382179634, 0.502010393620417, 0.48885044152757373, 0.47629512896051, 0.4643069280394422, 0.4528511576306266, 0.44189573283260003, 0.43141093924000323, 0.4213692292880545, 0.4117450382989767, 0.4025146181296717, 0.3936558865630571, 0.38514829079843427, 0.3769726835829618, 0.3691112106902638, 0.36154720859634004, 0.3542651113297933, 0.34725036558519684, 0.340489353287085, 0.33396932087918235, 0.32767831469055236, 0.3216051217986084, 0.31573921586941034, 0.3100707075093598, 0.304590298710103, 0.29928924101087695, 0.2941592970402896, 0.28919270513321227, 0.2843821467484926, 0.27972071644000907, 0.27520189415760615, 0.270819519675909, 0.2665677689682235, 0.26244113236003597, 0.25843439431203824, 0.2545426146965893, 0.25076111144396523, 0.24708544444608058, 0.24351140061545623, 0.24003498000639087, 0.23665238291356047, 0.2333599978706986, 0.23015439047880062, 0.2270322929993801, 0.2239905946538291, 0.22102633257497697, 0.21813668336147102, 0.21531895518973632, 0.21257058044203206, 0.2098891088125368, 0.20727220085650075, 0.20471762195033022, 0.20222323663305453, 0.19978700330198626, 0.19740696923751944, 0.1950812659339918, 0.19280810471531556, 0.19058577261574028, 0.18841262850760018, 0.18628709945929098, 0.18420767730797033, 0.1821729154326492, 0.18018142571439155, 0.17823187567133156, 0.1763229857571026, 0.17445352681211268, 0.17262231765785077, 0.17082822282511367, 0.1690701504076942, 0.16734705003365535, 0.1656579109468774, 0.16400176019206403, 0.16237766089686734, 0.16078471064521938, 0.15922203993636733, 0.15768881072447175, 0.1561842150339761, 0.15470747364627135, 0.15325783485347902, 0.15183457327544114, 0.15043698873626915, 0.149064405197033, 0.14771616974139326, 0.14639165161118275, 0.14509024128913084, 0.14381134962610503, 0.14255440701040226, 0.14131886257677895, 0.1401041834530502, 0.13890985404222025, 0.13773537533823035, 0.13658026427352798, 0.13544405309676352, 0.1343262887790272, 0.13322653244712926, 0.1321443588425154, 0.1310793558044918, 0.13003112377651022, 0.12899927533433747, 0.12798343473499657, 0.12698323748543688, 0.1259983299299428, 0.12502836885535032, 0.1240730211131909, 0.12313196325793226, 0.12220488120052962, 0.12129146987654613, 0.12039143292813971, 0.11950448239925308, 0.1186303384433775, 0.11776872904329794, 0.11691938974225351, 0.11608206338598234, 0.11525649987514432, 0.11444245592764314, 0.11363969485039356, 0.11284798632010304, 0.11206710617265928, 0.11129683620073585, 0.11053696395924793, 0.1097872825783083, 0.1090475905833519, 0.10831769172211304, 0.10759739479815637, 0.10688651351067442, 0.10618486630028322, 0.1054922762005561, 0.10480857069505113, 0.10413358157959822, 0.10346714482962362, 0.10280910047230002, 0.10215929246332031, 0.10151756856810279, 0.10088378024724459, 0.10025778254604852, 0.09963943398795666, 0.09902859647173191, 0.09842513517223564, 0.09782891844465687, 0.09723981773205465, 0.09665770747608199, 0.09608246503076462, 0.09551397057921561, 0.09495210705316912, 0.09439676005522443, 0.093847817783695, 0.0933051709599617, 0.09276871275823452, 0.09223833873763036, 0.09171394677647927, 0.09119543700877474, 0.09068271176268733, 0.0901756755010647, 0.08967423476384374, 0.08917829811230432, 0.08868777607509647, 0.08820258109597616, 0.08772262748318727, 0.08724783136042985, 0.08677811061935764, 0.08631338487354936, 0.08585357541390161, 0.08539860516539226, 0.08494839864516607, 0.0845028819218957, 0.08406198257637364, 0.0836256296632913, 0.08319375367416516, 0.08276628650136914, 0.08234316140323582, 0.08192431297018951, 0.08150967709187601, 0.08109919092525535, 0.08069279286362471, 0.08029042250654046, 0.07989202063060893, 0.0794975291611172, 0.07910689114447579, 0.07872005072144661, 0.07833695310113016, 0.07795754453568719, 0.07758177229577093, 0.07720958464664666, 0.0768409308249766, 0.07647576101624849, 0.07611402633282746, 0.07575567879261111, 0.0754006712982688, 0.07504895761704657, 0.0747004923611199, 0.07435523096847724, 0.07401312968431743, 0.07367414554294563, 0.0733382363501515, 0.07300536066605565, 0.07267547778840923, 0.07234854773633337, 0.0720245312344847, 0.07170338969763432, 0.07138508521564745, 0.07106958053885215, 0.07075683906378473, 0.0704468248193017, 0.07013950245304623, 0.06983483721825944, 0.069532794960926, 0.06923334210724438, 0.06893644565141219, 0.06864207314371744, 0.06835019267892699, 0.06806077288496333, 0.06777378291186177, 0.0674891924209997, 0.06720697157459027, 0.06692709102543308, 0.06664952190691442, 0.06637423582325018};
    private static final double[] cof = new double[]{76.18009172947146, -86.50532032941678, 24.01409824083091, -1.231739572450155, 0.001208650973866179, -5.395239384953E-6};
    private static final double EPSILON = 1.0E-14;
    private static final double LARGE_A = 10000.0;
    private static final int ITMAX = 1000;
    private static final double TWOVRPI = 0.6366197723675814;
    private static final double HALF_PI = 1.5707963268;
    private static final double TOL = 1.0E-6;
    private static final double sae = -30.0;
    private static final double zero = 0.0;
    private static final double one = 1.0;
    private static final double two = 2.0;
    private static final double three = 3.0;
    private static final double four = 4.0;
    private static final double five = 5.0;
    private static final double six = 6.0;
    private static final double aa = 0.6931471806;
    private static final double c1 = 0.01;
    private static final double c2 = 0.222222;
    private static final double c3 = 0.32;
    private static final double c4 = 0.4;
    private static final double c5 = 1.24;
    private static final double c6 = 2.2;
    private static final double c7 = 4.67;
    private static final double c8 = 6.66;
    private static final double c9 = 6.73;
    private static final double e = 5.0E-7;
    private static final double c10 = 13.32;
    private static final double c11 = 60.0;
    private static final double c12 = 70.0;
    private static final double c13 = 84.0;
    private static final double c14 = 105.0;
    private static final double c15 = 120.0;
    private static final double c16 = 127.0;
    private static final double c17 = 140.0;
    private static final double c18 = 1175.0;
    private static final double c19 = 210.0;
    private static final double c20 = 252.0;
    private static final double c21 = 2264.0;
    private static final double c22 = 294.0;
    private static final double c23 = 346.0;
    private static final double c24 = 420.0;
    private static final double c25 = 462.0;
    private static final double c26 = 606.0;
    private static final double c27 = 672.0;
    private static final double c28 = 707.0;
    private static final double c29 = 735.0;
    private static final double c30 = 889.0;
    private static final double c31 = 932.0;
    private static final double c32 = 966.0;
    private static final double c33 = 1141.0;
    private static final double c34 = 1182.0;
    private static final double c35 = 1278.0;
    private static final double c36 = 1740.0;
    private static final double c37 = 2520.0;
    private static final double c38 = 5040.0;
    private static final double half = 0.5;
    private static final double split = 0.42;
    private static final double a0 = 2.50662823884;
    private static final double a1 = -18.61500062529;
    private static final double a2 = 41.39119773534;
    private static final double a3 = -25.44106049637;
    private static final double b1 = -8.4735109309;
    private static final double b2 = 23.08336743743;
    private static final double b3 = -21.06224101826;
    private static final double b4 = 3.13082909833;
    private static final double cc0 = -2.78718931138;
    private static final double cc1 = -2.29796479134;
    private static final double cc2 = 4.85014127135;
    private static final double cc3 = 2.3212127685;
    private static final double d1 = 3.54388924762;
    private static final double d2 = 1.63706781897;
    private static final long MASK = 0xFFFFFFFFL;
    private static double vm_epsilon = 1.0;
    private static long seedi = 123456789L;
    private static long seedj = 362436069L;

    public static double normalCdf(double y) {
        double dcphi;
        double x = y;
        if (FastMath.abs(x) > 15.0) {
            dcphi = 0.0;
        } else {
            int j = (int)FastMath.floor(FastMath.abs(x) * 16.0 + 0.5);
            double z = (double)j * 0.0625;
            double h = FastMath.abs(x) - z;
            double f = r[j];
            double f1 = f * z - 1.0;
            double f2 = f + z * f1;
            double f3 = f1 * 2.0 + z * f2;
            double f4 = f2 * 3.0 + z * f3;
            double f5 = f3 * 4.0 + z * f4;
            dcphi = f + h * (f1 * 120.0 + h * (f2 * 60.0 + h * (f3 * 20.0 + h * (f4 * 5.0 + h * f5)))) / 120.0;
            dcphi = dcphi * 0.3989422804014327 * FastMath.exp(x * -0.5 * x);
        }
        if (x < 0.0) {
            return dcphi;
        }
        return 1.0 - dcphi;
    }

    private static double macheps() {
        if (vm_epsilon >= 1.0) {
            while (1.0 + vm_epsilon / 2.0 != 1.0) {
                vm_epsilon /= 2.0;
            }
        }
        return vm_epsilon;
    }

    public static double lngamma(double xx) {
        double x;
        if (xx <= 0.0) {
            return Double.NaN;
        }
        double y = x = xx;
        double tmp = x + 5.5;
        tmp -= (x + 0.5) * FastMath.log(tmp);
        double ser = 1.000000000190015;
        for (int j = 0; j <= 5; ++j) {
            ser += cof[j] / (y += 1.0);
        }
        return -tmp + FastMath.log(2.5066282746310007 * ser / x);
    }

    public static double logbeta(double p, double q) {
        return ProbUtils.lngamma(p) + ProbUtils.lngamma(q) - ProbUtils.lngamma(p + q);
    }

    public static double betaCdf(double x, double pin, double qin) {
        double dbetai;
        if (x <= 0.0) {
            return 0.0;
        }
        double eps = ProbUtils.macheps();
        double alneps = FastMath.log(eps);
        double sml = eps;
        double alnsml = alneps;
        double y = x;
        double q = qin;
        double p = pin;
        if ((q > p || x >= 0.8) && x >= 0.2) {
            y = 1.0 - y;
            p = qin;
            q = pin;
        }
        if ((p + q) * y / (p + 1.0) < eps) {
            dbetai = 0.0;
            double xb = p * FastMath.log(FastMath.max(y, sml)) - FastMath.log(p) - ProbUtils.logbeta(p, q);
            if (xb > alnsml && y != 0.0) {
                dbetai = FastMath.exp(xb);
            }
            if (y != x || p != pin) {
                dbetai = 1.0 - dbetai;
            }
        } else {
            double xi;
            int i;
            int n;
            double term;
            double ps = q - FastMath.floor(q);
            if (ps == 0.0) {
                ps = 1.0;
            }
            double xb = p * FastMath.log(y) - ProbUtils.logbeta(ps, p) - FastMath.log(p);
            dbetai = 0.0;
            if (xb >= alnsml) {
                dbetai = FastMath.exp(xb);
                term = dbetai * p;
                if (ps != 1.0) {
                    n = (int)FastMath.max(alneps / FastMath.log(y), 4.0);
                    for (i = 1; i <= n; ++i) {
                        xi = i;
                        term = term * (xi - ps) * y / xi;
                        dbetai += term / (p + xi);
                    }
                }
            }
            if (q > 1.0) {
                xb = p * FastMath.log(y) + q * FastMath.log(1.0 - y) - ProbUtils.logbeta(p, q) - FastMath.log(q);
                int ib = (int)FastMath.max(xb / alnsml, 0.0);
                term = FastMath.exp(xb - (double)ib * alnsml);
                double c = 1.0 / (1.0 - y);
                double p1 = q * c / (p + q - 1.0);
                double finsum = 0.0;
                n = (int)q;
                if (q == (double)n) {
                    --n;
                }
                for (i = 1; !(i > n || p1 <= 1.0 && term / eps <= finsum); ++i) {
                    xi = i;
                    if ((term = (q - xi + 1.0) * c * term / (p + q - xi)) > 1.0) {
                        --ib;
                    }
                    if (term > 1.0) {
                        term *= sml;
                    }
                    if (ib != 0) continue;
                    finsum += term;
                }
                dbetai += finsum;
            }
            if (y != x || p != pin) {
                dbetai = 1.0 - dbetai;
            }
            dbetai = FastMath.max(FastMath.min(dbetai, 1.0), 0.0);
        }
        return dbetai;
    }

    public static double binomialCdf(int k, int n, double p) {
        double dp;
        if (k < 0) {
            dp = 0.0;
        } else if (k >= n) {
            dp = 1.0;
        } else if (p == 0.0) {
            dp = k < 0 ? 0.0 : 1.0;
        } else if (p == 1.0) {
            dp = k < n ? 0.0 : 1.0;
        } else {
            double da = (double)k + 1.0;
            double db = n - k;
            dp = 1.0 - ProbUtils.betaCdf(p, da, db);
        }
        return dp;
    }

    public static double cauchyCdf(double x) {
        return (FastMath.atan(x) + 1.5707963267948966) / Math.PI;
    }

    public static double fCdf(double x, double df1, double df2) {
        return 1.0 - ProbUtils.betaCdf(df2 / (df2 + df1 * x), 0.5 * df2, 0.5 * df1);
    }

    private static double gnorm(double a, double x) {
        if (x <= 0.0 || a <= 0.0) {
            return 0.0;
        }
        double sx = FastMath.sqrt(a) * 3.0 * (FastMath.pow(x / a, 0.3333333333333333) + 1.0 / (a * 9.0) - 1.0);
        return ProbUtils.normalCdf(sx);
    }

    private static double gser(double a, double x, double gln) {
        double p;
        boolean done = false;
        if (x <= 0.0 || a <= 0.0) {
            p = 0.0;
        } else {
            double del;
            double ap = a;
            double sum = del = 1.0 / a;
            for (int n = 1; !done && n < 1000; ++n) {
                sum += (del *= x / (ap += 1.0));
                if (!(FastMath.abs(del) < 1.0E-14)) continue;
                done = true;
            }
            p = sum * FastMath.exp(-x + a * FastMath.log(x) - gln);
        }
        return p;
    }

    private static double gcf(double a, double x, double gln) {
        double gold = 0.0;
        double fac = 1.0;
        double b1 = 1.0;
        double b0 = 0.0;
        double a0 = 1.0;
        boolean done = false;
        double a1 = x;
        double p = 0.0;
        for (double an = 1.0; !done && an <= 1000.0; an += 1.0) {
            double ana = an - a;
            a0 = (a1 + a0 * ana) * fac;
            b0 = (b1 + b0 * ana) * fac;
            double anf = an * fac;
            a1 = x * a0 + anf * a1;
            b1 = x * b0 + anf * b1;
            if (a1 == 0.0) continue;
            fac = 1.0 / a1;
            double g = b1 * fac;
            if (FastMath.abs((g - gold) / g) < 1.0E-14) {
                p = FastMath.exp(-x + a * FastMath.log(x) - gln) * g;
                done = true;
            }
            gold = g;
        }
        return p;
    }

    public static double gammaCdf(double a, double x) {
        if (x <= 0.0 || a <= 0.0) {
            return Double.NaN;
        }
        if (a > 10000.0) {
            return ProbUtils.gnorm(a, x);
        }
        double gln = ProbUtils.lngamma(a);
        if (x < a + 1.0) {
            return ProbUtils.gser(a, x, gln);
        }
        return 1.0 - ProbUtils.gcf(a, x, gln);
    }

    public static double chisqCdf(double x, double df) {
        return Probability.chiSquare(df, x);
    }

    public static double poissonCdf(int k, double y) {
        double dp;
        if (k < 0) {
            dp = 0.0;
        } else if (y == 0.0) {
            dp = k < 0 ? 0.0 : 1.0;
        } else {
            double dx = (double)k + 1.0;
            dp = 1.0 - ProbUtils.gammaCdf(dx, y);
        }
        return dp;
    }

    public static double tCdf(double x, double df) {
        double cdf;
        double n = df;
        double z = 1.0;
        double t = x * x;
        double y = t / n;
        double b = 1.0 + y;
        if (n > FastMath.floor(n) || n >= 20.0 && t < n || n > 20.0) {
            if (n < 2.0 && n != 1.0) {
                double da = 0.5;
                double db = 0.5 * n;
                double dx = db / (db + 0.5 * t);
                double dp = ProbUtils.betaCdf(dx, db, 0.5);
                cdf = x >= 0.0 ? 1.0 - 0.5 * dp : 0.5 * dp;
            } else {
                if (y > 1.0E-6) {
                    y = FastMath.log(b);
                }
                double a = n - 0.5;
                b = 48.0 * a * a;
                y = a * y;
                y = (((((-0.4 * y - 3.3) * y - 24.0) * y - 85.5) / (0.8 * y * y + 100.0 + b) + y + 3.0) / b + 1.0) * FastMath.sqrt(y);
                y = -1.0 * y;
                cdf = ProbUtils.normalCdf(y);
                if (x > 0.0) {
                    cdf = 1.0 - cdf;
                }
            }
        } else {
            double a;
            if (n < 20.0 && t < 4.0) {
                y = a = FastMath.sqrt(y);
                if (n == 1.0) {
                    a = 0.0;
                }
            } else {
                a = FastMath.sqrt(b);
                y = a * n;
                double j = 2.0;
                while (FastMath.abs(a - z) > 1.0E-6) {
                    z = a;
                    y = y * (j - 1.0) / (b * j);
                    a += y / (n + j);
                    j += 2.0;
                }
                n += 2.0;
                z = 0.0;
                y = 0.0;
                a = -a;
            }
            n -= 2.0;
            while (n > 1.0) {
                a = (n - 1.0) / (b * n) * a + y;
                n -= 2.0;
            }
            a = FastMath.abs(n) < 1.0E-6 ? a / FastMath.sqrt(b) : 0.6366197723675814 * (FastMath.atan(y) + a / b);
            cdf = z - a;
            cdf = x > 0.0 ? 1.0 - 0.5 * cdf : 0.5 * cdf;
        }
        return cdf;
    }

    public static double betaQuantile(double alpha, double p, double q) {
        double d_1;
        double t;
        boolean indx;
        double qq;
        double pp;
        double a;
        double beta = ProbUtils.lngamma(p) + ProbUtils.lngamma(q) - ProbUtils.lngamma(p + q);
        double fpu = -300.0;
        double ret_val = alpha;
        if (p <= 0.0 || q <= 0.0) {
            return ret_val;
        }
        if (alpha == 0.0 || alpha == 1.0) {
            return ret_val;
        }
        if (alpha <= 0.5) {
            a = alpha;
            pp = p;
            qq = q;
            indx = false;
        } else {
            a = 1.0 - alpha;
            pp = q;
            qq = p;
            indx = true;
        }
        double r = FastMath.sqrt(-FastMath.log(a * a));
        double y = r - (r * 0.27061 + 2.30753) / (1.0 + (r * 0.04481 + 0.99229) * r);
        if (pp > 1.0 && qq > 1.0) {
            r = (y * y - 3.0) / 6.0;
            double s = 1.0 / (pp + pp - 1.0);
            t = 1.0 / (qq + qq - 1.0);
            double h = 2.0 / (s + t);
            d_1 = y * FastMath.sqrt(h + r) / h;
            double d_2 = (t - s) * (r + 0.8333333333333334 - 2.0 / (3.0 * h));
            double w = d_1 - d_2;
            ret_val = pp / (pp + qq * FastMath.exp(w + w));
        } else {
            r = qq + qq;
            t = 1.0 / (qq * 9.0);
            d_1 = 1.0 - t + y * FastMath.sqrt(t);
            ret_val = (t = r * (d_1 * d_1 * d_1)) <= 0.0 ? 1.0 - FastMath.exp((FastMath.log((1.0 - a) * qq) + beta) / qq) : ((t = (4.0 * pp + r - 2.0) / t) <= 1.0 ? FastMath.exp((FastMath.log(a * pp) + beta) / pp) : 1.0 - 2.0 / (t + 1.0));
        }
        r = 1.0 - pp;
        t = 1.0 - qq;
        double yprev = 0.0;
        double sq = 1.0;
        double prev = 1.0;
        if (ret_val < 1.0E-4) {
            ret_val = 1.0E-4;
        }
        if (ret_val > 0.9999) {
            ret_val = 0.9999;
        }
        int iex = -30.0 > (d_1 = -5.0 / (pp * pp) - 1.0 / (a * a) - 13.0) ? -30 : (int)d_1;
        double acu = FastMath.pow(10.0, iex);
        while (true) {
            double tx;
            y = ProbUtils.betaCdf(ret_val, pp, qq);
            double xin = ret_val;
            if ((y = (y - a) * FastMath.exp(beta + r * FastMath.log(xin) + t * FastMath.log(1.0 - xin))) * yprev <= 0.0) {
                prev = FastMath.max(sq, fpu);
            }
            double g = 1.0;
            while (true) {
                double adj;
                if ((sq = (adj = g * y) * adj) < prev && (tx = ret_val - adj) >= 0.0 && tx <= 1.0) {
                    if (prev <= acu || y * y <= acu) {
                        if (indx) {
                            ret_val = 1.0 - ret_val;
                        }
                        return ret_val;
                    }
                    if (tx != 0.0 && tx != 1.0) break;
                }
                g /= 3.0;
            }
            if (tx == ret_val) {
                if (indx) {
                    ret_val = 1.0 - ret_val;
                }
                return ret_val;
            }
            ret_val = tx;
            yprev = y;
        }
    }

    public static int binomialQuantile(double x, int n, double p) {
        double p2;
        double p1;
        int k;
        if (p == 0.0) {
            return 0;
        }
        if (p == (double)n) {
            return n;
        }
        double m = (double)n * p;
        double s = FastMath.sqrt((double)n * p * (1.0 - p));
        int del = FastMath.max(1, (int)(0.2 * s));
        int k1 = k = (int)(m + s * ProbUtils.normalQuantile(x));
        int k2 = k;
        do {
            k1 -= del;
            k1 = FastMath.max(0, k1);
            p1 = ProbUtils.binomialCdf(k1, n, p);
        } while (k1 > 0 && p1 > x);
        if (k1 == 0 && p1 >= x) {
            return k1;
        }
        do {
            k2 += del;
            k2 = FastMath.min(n, k2);
            p2 = ProbUtils.binomialCdf(k2, n, p);
        } while (k2 < n && p2 < x);
        if (k2 == n && p2 <= x) {
            return k2;
        }
        while (k2 - k1 > 1) {
            k = (k1 + k2) / 2;
            double pk = ProbUtils.binomialCdf(k, n, p);
            if (pk < x) {
                k1 = k;
                p1 = pk;
                continue;
            }
            k2 = k;
            p2 = pk;
        }
        return k2;
    }

    public static double cauchyQuantile(double x) {
        return FastMath.tan(Math.PI * (x - 0.5));
    }

    public static double chisqQuantile(double p, double v) {
        double s2;
        double b;
        double s1;
        double t;
        double p2;
        double q;
        double a;
        double d_1;
        double p1;
        double ch;
        double g = ProbUtils.lngamma(v * 0.5);
        double ret_val = -1.0;
        double xx = 0.5 * v;
        double c = xx - 1.0;
        if (v < -1.24 * FastMath.log(p)) {
            ch = FastMath.pow(p * xx * FastMath.exp(g + xx * 0.6931471806), 1.0 / xx);
            if (ch < 5.0E-7) {
                ret_val = ch;
                return ret_val;
            }
        } else if (v > 0.32) {
            double x = ProbUtils.normalQuantile(p);
            d_1 = x * FastMath.sqrt(p1 = 0.222222 / v) + 1.0 - p1;
            ch = v * (d_1 * d_1 * d_1);
            if (ch > 2.2 * v + 6.0) {
                ch = -2.0 * (FastMath.log(1.0 - p) - c * FastMath.log(0.5 * ch) + g);
            }
        } else {
            ch = 0.4;
            a = FastMath.log(1.0 - p);
            do {
                q = ch;
                p1 = 1.0 + ch * (4.67 + ch);
                p2 = ch * (6.73 + ch * (6.66 + ch));
                d_1 = -0.5 + (4.67 + 2.0 * ch) / p1;
                double d_2 = (6.73 + ch * (13.32 + 3.0 * ch)) / p2;
                t = d_1 - d_2;
            } while (FastMath.abs(q / (ch -= (1.0 - FastMath.exp(a + g + 0.5 * ch + c * 0.6931471806) * p2 / p1) / t) - 1.0) > 0.01);
        }
        do {
            q = ch;
            p1 = 0.5 * ch;
            p2 = p - ProbUtils.gammaCdf(xx, p1);
            t = p2 * FastMath.exp(xx * 0.6931471806 + g + p1 - c * FastMath.log(ch));
            b = t / ch;
            a = 0.5 * t - b * c;
            s1 = (210.0 + a * (140.0 + a * (105.0 + a * (84.0 + a * (70.0 + 60.0 * a))))) / 420.0;
            s2 = (420.0 + a * (735.0 + a * (966.0 + a * (1141.0 + 1278.0 * a)))) / 2520.0;
            double s3 = (210.0 + a * (462.0 + a * (707.0 + 932.0 * a))) / 2520.0;
            double s4 = (252.0 + a * (672.0 + 1182.0 * a) + c * (294.0 + a * (889.0 + 1740.0 * a))) / 5040.0;
            double s5 = (84.0 + 2264.0 * a + c * (1175.0 + 606.0 * a)) / 2520.0;
            double s6 = (120.0 + c * (346.0 + 127.0 * c)) / 5040.0;
            d_1 = s3 - b * (s4 - b * (s5 - b * s6));
        } while (FastMath.abs(q / (ch += t * (1.0 + 0.5 * t * s1 - b * c * (d_1 = s1 - b * (s2 - b * d_1)))) - 1.0) > 5.0E-7);
        ret_val = ch;
        return ret_val;
    }

    public static double fQuantile(double p, double df1, double df2) {
        if (p == 0.0) {
            return 0.0;
        }
        double dx = ProbUtils.betaCdf(1.0 - p, 0.5 * df2, 0.5 * df1);
        return df2 * (1.0 / dx - 1.0) / df1;
    }

    public static double gammaQuantile(double a, double p) {
        return 0.5 * ProbUtils.chisqQuantile(p, 2.0 * a);
    }

    public static double normalQuantile(double p) {
        double ppn;
        double q = p - 0.5;
        if (FastMath.abs(q) <= 0.42) {
            double r = q * q;
            ppn = q * (((-25.44106049637 * r + 41.39119773534) * r + -18.61500062529) * r + 2.50662823884) / ((((3.13082909833 * r + -21.06224101826) * r + 23.08336743743) * r + -8.4735109309) * r + 1.0);
        } else {
            double r = p;
            if (q > 0.0) {
                r = 1.0 - p;
            }
            r = FastMath.sqrt(-FastMath.log(r));
            ppn = (((2.3212127685 * r + 4.85014127135) * r + -2.29796479134) * r + -2.78718931138) / ((1.63706781897 * r + 3.54388924762) * r + 1.0);
            if (q < 0.0) {
                ppn = -ppn;
            }
        }
        return ppn;
    }

    public static int poissonQuantile(double x, double l) {
        double p2;
        double p1;
        int k;
        if (x == 0.0) {
            return 0;
        }
        if (l == 0.0) {
            return 0;
        }
        double m = l;
        double s = FastMath.sqrt(l);
        int del = FastMath.max(1, (int)(0.2 * s));
        int k1 = k = (int)(m + s * ProbUtils.normalQuantile(x));
        int k2 = k;
        do {
            k1 -= del;
            k1 = FastMath.max(0, k1);
            p1 = ProbUtils.poissonCdf(k1, l);
        } while (k1 > 0 && p1 > x);
        if (k1 == 0 && p1 >= x) {
            return k1;
        }
        while ((p2 = ProbUtils.poissonCdf(k2 += del, l)) < x) {
        }
        while (k2 - k1 > 1) {
            k = (k1 + k2) / 2;
            double pk = ProbUtils.poissonCdf(k, l);
            if (pk < x) {
                k1 = k;
                p1 = pk;
                continue;
            }
            k2 = k;
            p2 = pk;
        }
        return k2;
    }

    public static double tQuantile(double pp, double n) {
        double sq;
        double p;
        double d = p = pp < 0.5 ? 2.0 * pp : 2.0 * (1.0 - pp);
        if (n <= 3.0) {
            if (n == 1.0) {
                sq = FastMath.tan(1.5707963268 * (1.0 - p));
            } else if (n == 2.0) {
                sq = FastMath.sqrt(2.0 / (p * (2.0 - p)) - 2.0);
            } else {
                sq = ProbUtils.betaQuantile(p, 0.5 * n, 0.5);
                if (sq != 0.0) {
                    sq = FastMath.sqrt(n / sq - n);
                }
            }
        } else {
            double a = 1.0 / (n - 0.5);
            double b = 48.0 / (a * a);
            double c = ((20700.0 * a / b - 98.0) * a - 16.0) * a + 96.36;
            double d2 = ((94.5 / (b + c) - 3.0) / b + 1.0) * FastMath.sqrt(a * 1.5707963268) * n;
            double x = d2 * p;
            double y = FastMath.pow(x, 2.0 / n);
            if (y > 0.05 + a) {
                x = ProbUtils.normalQuantile(0.5 * p);
                y = x * x;
                if (n < 5.0) {
                    c += 0.3 * (n - 4.5) * (x + 0.6);
                }
                c = (((0.05 * d2 * x - 5.0) * x - 7.0) * x - 2.0) * x + b + c;
                y = (((((0.4 * y + 6.3) * y + 36.0) * y + 94.5) / c - y - 3.0) / b + 1.0) * x;
                y = (y = a * y * y) > 0.002 ? FastMath.exp(y) - 1.0 : 0.5 * y * y + y;
            } else {
                y = ((1.0 / (((n + 6.0) / (n * y) - 0.089 * d2 - 0.822) * (n + 2.0) * 3.0) + 0.5 / (n + 4.0)) * y - 1.0) * (n + 1.0) / (n + 2.0) + 1.0 / y;
            }
            sq = FastMath.sqrt(n * y);
        }
        if (pp < 0.5) {
            sq = -sq;
        }
        return sq;
    }

    public static double betaPdf(double x, double a, double b) {
        if (x <= 0.0 || x >= 1.0) {
            return 0.0;
        }
        return FastMath.exp(FastMath.log(x) * (a - 1.0) + FastMath.log(1.0 - x) * (b - 1.0) - ProbUtils.logbeta(a, b));
    }

    public static double binomialPmf(int k, int n, double p) {
        if (p == 0.0) {
            return k == 0 ? 1.0 : 0.0;
        }
        if (p == 1.0) {
            return k == n ? 1.0 : 0.0;
        }
        if (k < 0 || k > n) {
            return 0.0;
        }
        return FastMath.exp(ProbUtils.lngamma((double)n + 1.0) - ProbUtils.lngamma((double)k + 1.0) - ProbUtils.lngamma((double)(n - k) + 1.0) + (double)k * FastMath.log(p) + (double)(n - k) * FastMath.log(1.0 - p));
    }

    public static double cauchyPdf(double x) {
        return ProbUtils.tPdf(x, 1.0);
    }

    public static double chisqPdf(double x, double v) {
        return 0.5 * ProbUtils.gammaPdf(0.5 * x, 0.5 * v);
    }

    public static double fPdf(double x, double a, double b) {
        if (x <= 0.0) {
            return 0.0;
        }
        return FastMath.exp(0.5 * a * FastMath.log(a) + 0.5 * b * FastMath.log(b) + (0.5 * a - 1.0) * FastMath.log(x) - ProbUtils.logbeta(0.5 * a, 0.5 * b) - 0.5 * (a + b) * FastMath.log(b + a * x));
    }

    public static double gammaPdf(double x, double a) {
        if (x <= 0.0) {
            return 0.0;
        }
        return FastMath.exp(FastMath.log(x) * (a - 1.0) - x - ProbUtils.lngamma(a));
    }

    public static double normalPdf(double x) {
        return FastMath.exp(-0.5 * x * x) / FastMath.sqrt(Math.PI * 2);
    }

    public static double poissonPmf(int k, double lambda) {
        if (lambda == 0.0) {
            return k == 0 ? 1.0 : 0.0;
        }
        if (k < 0) {
            return 0.0;
        }
        return FastMath.exp((double)k * FastMath.log(lambda) - lambda - ProbUtils.lngamma((double)k + 1.0));
    }

    public static double tPdf(double x, double a) {
        return 1.0 / FastMath.sqrt(a * Math.PI) * FastMath.exp(ProbUtils.lngamma(0.5 * (a + 1.0)) - ProbUtils.lngamma(0.5 * a) - 0.5 * (a + 1.0) * FastMath.log(1.0 + x * x / a));
    }

    public static void uniformSeeds(long a, long b) {
        seedi = a & 0xFFFFFFFFL;
        seedj = b & 0xFFFFFFFFL;
    }

    public static double uniformRand() {
        seedi = seedi * 69069L + 23606797L & 0xFFFFFFFFL;
        seedj ^= seedj << 13 & 0xFFFFFFFFL;
        seedj ^= seedj >> 17 & 0xFFFFFFFFL;
        seedj ^= seedj << 5 & 0xFFFFFFFFL;
        return (double)(seedi + seedj & 0xFFFFFFFFL) * FastMath.pow(2.0, -32.0);
    }

    public static int bernoulliRand(double p) {
        return ProbUtils.uniformRand() <= p ? 1 : 0;
    }

    public static int poissonRand(double xm) {
        int k;
        if (xm < 12.0) {
            double expxm = FastMath.exp(-xm);
            k = -1;
            double t = 1.0;
            do {
                ++k;
            } while ((t *= ProbUtils.uniformRand()) > expxm);
        } else {
            double sqrt2xm = FastMath.sqrt(2.0 * xm);
            double logxm = FastMath.log(xm);
            double g = xm * logxm - ProbUtils.lngamma(xm + 1.0);
            while (true) {
                double y;
                if ((k = (int)FastMath.floor(sqrt2xm * (y = FastMath.tan(Math.PI * ProbUtils.uniformRand())) + xm)) < 0) {
                    continue;
                }
                double t = 0.9 * (1.0 + y * y) * FastMath.exp((double)k * logxm - ProbUtils.lngamma((double)k + 1.0) - g);
                if (!(ProbUtils.uniformRand() > t)) break;
            }
        }
        return k;
    }

    public static int binomialRand(int n, double pp) {
        int k;
        double p = pp <= 0.5 ? pp : 1.0 - pp;
        double am = (double)n * p;
        if (p == 0.0) {
            k = 0;
        } else if (p == 1.0) {
            k = n;
        } else if (n < 50) {
            k = 0;
            for (int j = 0; j < n; ++j) {
                if (!(ProbUtils.uniformRand() < p)) continue;
                ++k;
            }
        } else if (am < 1.0) {
            double g = FastMath.exp(-am);
            double t = 1.0;
            k = -1;
            do {
                ++k;
            } while ((t *= ProbUtils.uniformRand()) > g);
            if (k > n) {
                k = n;
            }
        } else {
            double em;
            double en = n;
            double g = ProbUtils.lngamma(en + 1.0);
            double pc = 1.0 - p;
            double plog = FastMath.log(p);
            double pclog = FastMath.log(pc);
            double sq = FastMath.sqrt(2.0 * am * pc);
            while (true) {
                double y;
                if ((em = sq * (y = FastMath.tan(Math.PI * ProbUtils.uniformRand())) + am) < 0.0 || em >= en + 1.0) {
                    continue;
                }
                em = FastMath.floor(em);
                double t = 1.2 * sq * (1.0 + y * y) * FastMath.exp(g - ProbUtils.lngamma(em + 1.0) - ProbUtils.lngamma(en - em + 1.0) + em * plog + (en - em) * pclog);
                if (!(ProbUtils.uniformRand() > t)) break;
            }
            k = (int)em;
        }
        if (p != pp) {
            k = n - k;
        }
        return k;
    }

    public static double normalRand() {
        double u;
        double u1;
        double v;
        double x;
        double y;
        double c = FastMath.sqrt(2.0 / FastMath.exp(1.0));
        do {
            u = ProbUtils.uniformRand();
        } while ((y = (x = (v = c * (2.0 * (u1 = ProbUtils.uniformRand()) - 1.0)) / u) * x / 4.0) > 1.0 - u && y > -FastMath.log(u));
        return x;
    }

    public static double cauchyRand() {
        double u2;
        double v2;
        double u1;
        double v1;
        while ((v1 = 2.0 * (u1 = ProbUtils.uniformRand()) - 1.0) * v1 + (v2 = (u2 = ProbUtils.uniformRand())) * v2 > 1.0) {
        }
        return v1 / v2;
    }

    public static double gammaRand(double a) {
        double x;
        double e = FastMath.exp(1.0);
        if (a < 1.0) {
            boolean done = false;
            double c = (a + e) / e;
            do {
                double u0 = ProbUtils.uniformRand();
                double u1 = ProbUtils.uniformRand();
                double v = c * u0;
                if (v <= 1.0) {
                    x = FastMath.exp(FastMath.log(v) / a);
                    if (!(u1 <= FastMath.exp(-x))) continue;
                    done = true;
                    continue;
                }
                x = -FastMath.log((c - v) / a);
                if (!(x > 0.0) || !(u1 < FastMath.exp((a - 1.0) * FastMath.log(x)))) continue;
                done = true;
            } while (!done);
        } else if (a == 1.0) {
            x = -FastMath.log(ProbUtils.uniformRand());
        } else {
            double u2;
            double w;
            double u1;
            double c1 = a - 1.0;
            double c2 = (a - 1.0 / (6.0 * a)) / c1;
            double c3 = 2.0 / c1;
            double c4 = 2.0 / (a - 1.0) + 2.0;
            double c5 = 1.0 / FastMath.sqrt(a);
            do {
                u1 = ProbUtils.uniformRand();
                u2 = ProbUtils.uniformRand();
                if (!(a > 2.5)) continue;
                u1 = u2 + c5 * (1.0 - 1.86 * u1);
            } while (u1 <= 0.0 || u1 >= 1.0 || c3 * u1 + (w = c2 * u2 / u1) + 1.0 / w > c4 && c3 * FastMath.log(u1) - FastMath.log(w) + w > 1.0);
            x = c1 * w;
        }
        return x;
    }

    public static double chisqRand(double df) {
        return 2.0 * ProbUtils.gammaRand(df / 2.0);
    }

    public static double tRand(double df) {
        return ProbUtils.normalRand() / FastMath.sqrt(ProbUtils.chisqRand(df) / df);
    }

    public static double betaRand(double a, double b) {
        double x = ProbUtils.gammaRand(a);
        double y = ProbUtils.gammaRand(b);
        return x / (x + y);
    }

    public static double fRand(double ndf, double ddf) {
        return ddf * ProbUtils.chisqRand(ndf) / (ndf * ProbUtils.chisqRand(ddf));
    }

    public static double biNormalCdf(double ah, double ak, double r) {
        return ProbUtils.biNormalCdf2(-ah, -ak, r);
    }

    private static double biNormalCdf2(double ah, double ak, double r) {
        double gw = 0.0;
        double wh = 0.0;
        double wk = 0.0;
        int is = 0;
        int myflag = 1;
        double con = 3.1415926535897934E-10;
        double temp = -ah;
        double gh = ProbUtils.normalCdf(temp);
        gh /= 2.0;
        temp = -ak;
        double gk = ProbUtils.normalCdf(temp);
        gk /= 2.0;
        double b = 0.0;
        if (r == 0.0) {
            b = 4.0 * gh * gk;
        } else {
            double rr = 1.0 - r * r;
            assert (rr >= 0.0);
            if (rr != 0.0) {
                double sqr = FastMath.sqrt(rr);
                if (ah == 0.0) {
                    if (ak == 0.0) {
                        b = FastMath.atan(r / sqr) / (Math.PI * 2) + 0.25;
                        if (b < 0.0) {
                            b = 0.0;
                        }
                        if (b > 1.0) {
                            b = 1.0;
                        }
                        return b;
                    }
                    b += gk;
                } else {
                    b = gh;
                    if (ah * ak != 0.0) {
                        if (ah * ak < 0.0) {
                            b -= 0.5;
                        }
                        b += gk;
                    }
                    wh = -ah;
                    wk = (ak / ah - r) / sqr;
                    gw = 2.0 * gh;
                    is = -1;
                    myflag = -1;
                }
                do {
                    if (myflag == -1) {
                        myflag = 1;
                    } else {
                        wh = -ak;
                        wk = (ah / ak - r) / sqr;
                        gw = 2.0 * gk;
                        is = 1;
                    }
                    double sgn = -1.0;
                    double t = 0.0;
                    if (wk == 0.0) continue;
                    if (FastMath.abs(wk) != 1.0) {
                        double s1;
                        if (FastMath.abs(wk) > 1.0) {
                            sgn = -sgn;
                            double g2 = ProbUtils.normalCdf(wh *= wk);
                            if ((wk = 1.0 / wk) < 0.0) {
                                b += 0.5;
                            }
                            b = b - (gw + g2) / 2.0 + gw * g2;
                        }
                        double h2 = wh * wh;
                        double a2 = wk * wk;
                        double h4 = h2 * 0.5;
                        double ex = 0.0;
                        if (h4 < 150.0) {
                            ex = FastMath.exp(-h4);
                        }
                        double w2 = h4 * ex;
                        double ap = 1.0;
                        double s2 = ap - ex;
                        double sp = ap;
                        double sn = s1 = 0.0;
                        double conex = FastMath.abs(3.1415926535897934E-10 / wk);
                        while (true) {
                            double cn = ap * s2 / (sn + sp);
                            s1 += cn;
                            if (FastMath.abs(cn) <= conex) break;
                            sn = sp;
                            s2 -= w2;
                            w2 = w2 * h4 / (sp += 1.0);
                            ap = -ap * a2;
                        }
                        t = (FastMath.atan(wk) - wk * s1) / (Math.PI * 2);
                    } else {
                        t = wk * gw * (1.0 - gw) / 2.0;
                    }
                    b += sgn * t;
                } while (is < 0 && ak != 0.0);
            } else if (r >= 0.0) {
                b = ah >= ak ? 2.0 * gh : 2.0 * gk;
            } else if (ah + ak < 0.0) {
                b = 2.0 * (gh + gk) - 1.0;
            }
        }
        if (b < 0.0) {
            b = 0.0;
        }
        if (b > 1.0) {
            b = 1.0;
        }
        return b;
    }

    public static double multinormalProb(double[] a, double[] b, double[][] cov) {
        double error;
        assert (a.length == b.length);
        for (int i = 0; i < a.length; ++i) {
            assert (a[i] <= b[i]);
        }
        ProbUtils.orderIntegral(a, b, cov);
        double[][] c = MatrixUtils.cholesky(new Matrix(cov)).toArray();
        double[] d = new double[a.length];
        double[] e = new double[a.length];
        double[] f = new double[a.length];
        double[] w = new double[a.length - 1];
        double[] y = new double[a.length - 1];
        double intSum = 0.0;
        double varSum = 0.0;
        int n = 0;
        RandomUtil r = RandomUtil.getInstance();
        d[0] = a[0] == Double.NEGATIVE_INFINITY ? 0.0 : ProbUtils.normalCdf(a[0] / c[0][0]);
        e[0] = b[0] == Double.POSITIVE_INFINITY ? 1.0 : ProbUtils.normalCdf(b[0] / c[0][0]);
        f[0] = e[0] - d[0];
        do {
            int i;
            for (i = 0; i < w.length; ++i) {
                w[i] = r.nextDouble();
            }
            for (i = 1; i < a.length; ++i) {
                double quant = d[i - 1] + w[i - 1] * (e[i - 1] - d[i - 1]);
                y[i - 1] = quant == 1.0 ? Double.MAX_VALUE : (quant == 0.0 ? -1.7976931348623157E308 : ProbUtils.normalQuantile(d[i - 1] + w[i - 1] * (e[i - 1] - d[i - 1])));
                double auxSum = 0.0;
                for (int j = 0; j < i; ++j) {
                    auxSum += c[i][j] * y[j];
                }
                d[i] = a[i] == Double.NEGATIVE_INFINITY ? 0.0 : ProbUtils.normalCdf((a[i] - auxSum) / c[i][i]);
                e[i] = b[i] == Double.POSITIVE_INFINITY ? 1.0 : ProbUtils.normalCdf((b[i] - auxSum) / c[i][i]);
                f[i] = (e[i] - d[i]) * f[i - 1];
            }
            intSum += f[f.length - 1];
            varSum += f[f.length - 1] * f[f.length - 1];
        } while ((error = 2.0) > 1.0E-4 && ++n < 5000 || n < 50);
        return intSum / (double)n;
    }

    private static void orderIntegral(double[] a, double[] b, double[][] cov) {
        for (int i = 0; i < a.length - 1; ++i) {
            int idx2;
            int idx1;
            int j;
            int smallest = i;
            for (j = i + 1; j < a.length; ++j) {
                if (Double.isInfinite(a[j]) && Double.isInfinite(a[smallest])) {
                    if (!(b[j] < b[smallest])) continue;
                    smallest = j;
                    continue;
                }
                if (Double.isInfinite(b[j]) && Double.isInfinite(b[smallest])) {
                    if (!(a[j] > a[smallest])) continue;
                    smallest = j;
                    continue;
                }
                if (Double.isInfinite(a[smallest]) && Double.isInfinite(b[j])) {
                    if (b[smallest] <= 0.0 && a[j] >= 0.0 && a[j] > -b[smallest]) {
                        smallest = j;
                        continue;
                    }
                    if (b[smallest] >= 0.0 && a[j] >= 0.0) {
                        smallest = j;
                        continue;
                    }
                    if (!(b[smallest] >= 0.0) || !(a[j] <= 0.0) || !(-a[j] < b[smallest])) continue;
                    smallest = j;
                    continue;
                }
                if (Double.isInfinite(b[smallest]) && Double.isInfinite(a[j])) {
                    if (a[smallest] <= 0.0 && b[j] >= 0.0 && b[j] < -a[smallest]) {
                        smallest = j;
                        continue;
                    }
                    if (a[smallest] <= 0.0 && b[j] <= 0.0) {
                        smallest = j;
                        continue;
                    }
                    if (!(a[smallest] >= 0.0) || !(b[j] <= 0.0) || !(-b[j] > a[smallest])) continue;
                    smallest = j;
                    continue;
                }
                if ((Double.isInfinite(a[smallest]) || Double.isInfinite(b[smallest])) && !Double.isInfinite(a[j]) && !Double.isInfinite(b[j])) {
                    smallest = j;
                    continue;
                }
                if (Double.isInfinite(a[smallest]) || Double.isInfinite(b[smallest]) || Double.isInfinite(a[j]) || Double.isInfinite(b[j]) || !(FastMath.abs(b[j] - a[j]) < FastMath.abs(b[smallest] - a[smallest]))) continue;
                smallest = j;
            }
            double temp1 = a[i];
            double temp2 = b[i];
            a[i] = a[smallest];
            b[i] = b[smallest];
            a[smallest] = temp1;
            b[smallest] = temp2;
            if (smallest > i) {
                idx1 = smallest;
                idx2 = i;
            } else {
                if (smallest >= i) continue;
                idx1 = i;
                idx2 = smallest;
            }
            temp1 = cov[idx1][idx2];
            double temp3 = cov[idx1][idx1];
            double temp4 = cov[idx2][idx2];
            for (j = 0; j < cov.length; ++j) {
                temp2 = cov[idx1][j];
                double d = cov[idx2][j];
                cov[idx1][j] = d;
                cov[j][idx1] = d;
                double d2 = temp2;
                cov[idx2][j] = d2;
                cov[j][idx2] = d2;
            }
            double d = temp1;
            cov[idx1][idx2] = d;
            cov[idx2][idx1] = d;
            cov[idx1][idx1] = temp4;
            cov[idx2][idx2] = temp3;
        }
    }
}

