/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.util;

import org.apache.commons.math3.special.Gamma;
import org.apache.commons.math3.util.FastMath;

public final class SublistGenerator {
    private final int a;
    private final int depth;
    private int b;
    private int diff;
    private int[] choiceLocal;
    private int[] choiceReturned;
    private boolean begun;
    private int effectiveDepth;

    public SublistGenerator(int a, int depth) {
        if (a < 0 || depth < -1) {
            throw new IllegalArgumentException();
        }
        this.a = a;
        this.b = 0;
        this.depth = depth;
        this.effectiveDepth = depth;
        if (depth == -1) {
            this.effectiveDepth = a;
        }
        if (depth > a) {
            this.effectiveDepth = a;
        }
        this.initialize();
    }

    public static int getNumCombinations(int a, int b) {
        int numCombinations = 0;
        for (int c = 0; c <= b; ++c) {
            numCombinations += (int)FastMath.round(FastMath.exp(Gamma.logGamma(a + 1) - Gamma.logGamma(c + 1) - Gamma.logGamma(a - c + 1)));
        }
        return numCombinations;
    }

    public static void testPrint(int a, int depth) {
        int[] choice;
        SublistGenerator cg = new SublistGenerator(a, depth);
        System.out.println();
        System.out.println("Printing combinations for " + a + " choose " + depth + ":");
        System.out.println();
        while ((choice = cg.next()) != null) {
            if (choice.length == 0) {
                System.out.println("zero-length array");
                continue;
            }
            for (int aChoice : choice) {
                System.out.print(aChoice + "\t");
            }
            System.out.println();
        }
        System.out.println();
    }

    private void initialize() {
        this.choiceLocal = new int[this.b];
        this.choiceReturned = new int[this.b];
        this.diff = this.a - this.b;
        for (int i = 0; i < this.b - 1; ++i) {
            this.choiceLocal[i] = i;
        }
        if (this.b > 0) {
            this.choiceLocal[this.b - 1] = this.b - 2;
        }
        this.begun = false;
    }

    public synchronized int[] next() {
        int i = this.getB();
        while (--i > -1) {
            if (this.choiceLocal[i] >= i + this.diff) continue;
            this.fill(i);
            this.begun = true;
            System.arraycopy(this.choiceLocal, 0, this.choiceReturned, 0, this.b);
            return this.choiceReturned;
        }
        if (this.begun) {
            ++this.b;
            if (this.b > this.effectiveDepth) {
                return null;
            }
            this.initialize();
            return this.next();
        }
        this.begun = true;
        System.arraycopy(this.choiceLocal, 0, this.choiceReturned, 0, this.b);
        return this.choiceReturned;
    }

    public String toString() {
        return "Depth choice generator: a = " + this.a + " depth = " + this.depth;
    }

    public int getA() {
        return this.a;
    }

    private int getB() {
        return this.b;
    }

    private void fill(int index) {
        int n = index;
        this.choiceLocal[n] = this.choiceLocal[n] + 1;
        for (int i = index + 1; i < this.getB(); ++i) {
            this.choiceLocal[i] = this.choiceLocal[i - 1] + 1;
        }
    }
}

