/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.util;

import edu.cmu.tetrad.util.DefaultTetradLoggerConfig;
import edu.cmu.tetrad.util.TetradLoggerConfig;
import edu.cmu.tetrad.util.TetradLoggerEvent;
import edu.cmu.tetrad.util.TetradLoggerListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TetradLogger {
    private static final TetradLogger INSTANCE = new TetradLogger();
    private final Map<OutputStream, Writer> writers = new LinkedHashMap<OutputStream, Writer>();
    private final Map<Class, TetradLoggerConfig> classConfigMap = new ConcurrentHashMap<Class, TetradLoggerConfig>();
    private final Map<Object, TetradLoggerConfig> nodeConfigMap = new ConcurrentHashMap<Object, TetradLoggerConfig>();
    private final Map<Object, Object> nodeModelMap = new ConcurrentHashMap<Object, Object>();
    private final List<TetradLoggerListener> listeners = new ArrayList<TetradLoggerListener>();
    private boolean logging = Preferences.userRoot().getBoolean("loggingActivated", true);
    private TetradLoggerConfig config;
    private OutputStream stream;
    private boolean forceLog;
    private String latestFilePath;

    private TetradLogger() {
    }

    public static TetradLogger getInstance() {
        return INSTANCE;
    }

    public void addTetradLoggerListener(TetradLoggerListener l) {
        this.listeners.add(l);
    }

    public void removeTetradLoggerListener(TetradLoggerListener l) {
        this.listeners.remove(l);
    }

    public void setTetradLoggerConfig(TetradLoggerConfig config) {
        TetradLoggerConfig previous = this.config;
        if (config == null) {
            this.config = null;
            if (previous != null) {
                this.fireDeactived();
            }
        } else {
            this.config = config;
            this.fireActived(this.config);
        }
    }

    public void setEventsToLog(String ... events) {
        this.setTetradLoggerConfig(new DefaultTetradLoggerConfig(events));
    }

    public void setForceLog(boolean force) {
        this.forceLog = force;
        if (!force) {
            this.flush();
        }
    }

    public void setConfigForClass(Class model) {
        TetradLoggerConfig config = this.classConfigMap.get(model);
        this.setTetradLoggerConfig(config);
    }

    public void addTetradLoggerConfig(Class model, TetradLoggerConfig config) {
        this.classConfigMap.put(model, config);
    }

    public TetradLoggerConfig getLoggerForClass(Class clazz) {
        TetradLoggerConfig config = this.classConfigMap.get(clazz);
        if (config == null) {
            return null;
        }
        return config.copy();
    }

    public void reset() {
        this.config = null;
        this.flush();
    }

    public boolean isLogging() {
        return this.logging;
    }

    public void setLogging(boolean logging) {
        Preferences.userRoot().putBoolean("loggingActivated", logging);
        this.logging = logging;
    }

    public void flush() {
        if (this.logging) {
            try {
                for (Writer writer : this.writers.values()) {
                    writer.flush();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        for (OutputStream stream : this.writers.keySet()) {
            if (!(stream instanceof LogDisplayOutputStream)) continue;
            LogDisplayOutputStream logStream = (LogDisplayOutputStream)((Object)stream);
            logStream.moveToEnd();
        }
    }

    public void log(String event, String message) {
        boolean eventActive = this.isEventActive(event);
        if (this.logging && eventActive && !this.writers.isEmpty()) {
            try {
                for (Writer writer : this.writers.values()) {
                    writer.write(message);
                    writer.write("\n");
                    writer.flush();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void error(String message) {
        if (this.logging) {
            try {
                for (Writer writer : this.writers.values()) {
                    writer.write(message);
                    writer.write("\n");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void forceLogMessage(String message) {
        System.out.println(message);
        if (this.logging) {
            if (this.config == null) {
                this.fireActived(new EmptyConfig(true));
            }
            try {
                for (Writer writer : this.writers.values()) {
                    writer.write(message);
                    writer.write("\n");
                    writer.flush();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void addOutputStream(OutputStream stream) {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(stream));
        this.writers.put(stream, writer);
    }

    public void removeOutputStream(OutputStream stream) {
        this.writers.remove(stream);
    }

    public void clear() {
        for (OutputStream stream : this.writers.keySet()) {
            if (stream == System.out) continue;
            try {
                stream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.writers.clear();
        this.stream = null;
    }

    public void setNextOutputStream() {
        if (this.logging && this.isFileLoggingEnabled()) {
            File dir = new File(this.getLoggingDirectory());
            if (!dir.exists() && !dir.mkdir()) {
                throw new IllegalStateException("Could not create the output directory " + dir.getAbsolutePath() + ".");
            }
            if (!dir.canWrite()) {
                throw new IllegalStateException("Cannot write to the directory choosen for saving output  logs (" + dir.getAbsolutePath() + "). Please pick another directory.");
            }
            String prefix = this.getLoggingFilePrefix();
            List<String> files = Arrays.asList(dir.list());
            int index = 1;
            String name = prefix + index++ + ".txt";
            while (files.contains(name)) {
                name = prefix + index++ + ".txt";
            }
            String latestFilePath = dir.getAbsolutePath() + "/" + name;
            File logFile = new File(latestFilePath);
            OutputStream old = this.stream;
            try {
                this.stream = new FileOutputStream(logFile);
            }
            catch (FileNotFoundException e) {
                this.stream = old;
                throw new IllegalStateException("Could not create file in output directory (" + dir.getAbsolutePath() + ").");
            }
            if (old != null) {
                this.removeOutputStream(old);
            }
            this.addOutputStream(this.stream);
            this.latestFilePath = latestFilePath;
        }
    }

    public void removeNextOutputStream() {
        this.flush();
        if (this.stream != null) {
            this.removeOutputStream(this.stream);
            try {
                this.stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.stream = null;
        }
    }

    public String getLoggingFilePrefix() {
        return Preferences.userRoot().get("loggingPrefix", "output");
    }

    public void setLoggingFilePrefix(String loggingFilePrefix) {
        if (loggingFilePrefix == null) {
            throw new NullPointerException();
        }
        if ("".equals(loggingFilePrefix)) {
            throw new IllegalArgumentException("Empty prefix name; ignored.");
        }
        Preferences.userRoot().put("loggingPrefix", this.normalize(loggingFilePrefix));
    }

    public boolean isDisplayLogEnabled() {
        return Preferences.userRoot().getBoolean("enableDisplayLogging", true);
    }

    public void setDisplayLogEnabled(boolean enabled) {
        Preferences.userRoot().putBoolean("enableDisplayLogging", enabled);
    }

    public boolean isFileLoggingEnabled() {
        return Preferences.userRoot().getBoolean("enableFileLogging", false);
    }

    public void setFileLoggingEnabled(boolean enabled) {
        Preferences.userRoot().putBoolean("enableFileLogging", enabled);
    }

    public Boolean isAutomaticLogDisplayEnabled() {
        return false;
    }

    public void setAutomaticLogDisplayEnabled(boolean enable) {
        Preferences.userRoot().put("allowAutomaticLogDisplay", enable ? "allow" : "disallow");
    }

    public String getLoggingDirectory() {
        return Preferences.userRoot().get("loggingDirectory", Preferences.userRoot().absolutePath());
    }

    public void setLoggingDirectory(String directory) {
        File selectedFile = new File(directory);
        if (selectedFile.exists() && !selectedFile.isDirectory()) {
            throw new IllegalStateException("That 'output directory' is actually a file, not a directory");
        }
        if (selectedFile.exists() && selectedFile.isDirectory() & !selectedFile.canWrite()) {
            throw new IllegalStateException("The output directory cannot be written to.");
        }
        if (!selectedFile.exists()) {
            boolean created = selectedFile.mkdir();
            if (!created) {
                throw new IllegalStateException("The output directory cannot be created. ");
            }
            if (!selectedFile.canWrite()) {
                throw new IllegalStateException("That output directory cannot be written to. Keeping the old one.");
            }
            selectedFile.delete();
        }
        Preferences.userRoot().put("loggingDirectory", selectedFile.getAbsolutePath());
    }

    public boolean isEventActive(String id) {
        return this.forceLog || this.config != null && this.config.isEventActive(id);
    }

    private String normalize(String prefix) {
        StringBuilder buf = new StringBuilder();
        Pattern pattern = Pattern.compile("[a-zA-Z_]");
        for (int i = 0; i < prefix.length(); ++i) {
            String s = prefix.substring(i, i + 1);
            Matcher matcher = pattern.matcher(s);
            if (!matcher.matches()) continue;
            buf.append(s);
        }
        return buf.toString();
    }

    private void fireActived(TetradLoggerConfig config) {
        if (this.logging && !this.listeners.isEmpty()) {
            TetradLoggerEvent evt = new TetradLoggerEvent(this, config);
            for (TetradLoggerListener l : this.listeners) {
                l.configurationActived(evt);
            }
        }
    }

    private void fireDeactived() {
        if (this.logging && !this.listeners.isEmpty() && this.config == null) {
            TetradLoggerEvent evt = new TetradLoggerEvent(this, null);
            for (TetradLoggerListener l : this.listeners) {
                l.configurationDeactived(evt);
            }
        }
    }

    public String getLatestFilePath() {
        return this.latestFilePath;
    }

    public TetradLoggerConfig getLoggerConfig() {
        return this.config;
    }

    public static interface LogDisplayOutputStream {
        public int getLengthWritten();

        public void moveToEnd();
    }

    public static class EmptyConfig
    implements TetradLoggerConfig {
        private static final long serialVersionUID = 23L;
        private final boolean active;

        public EmptyConfig(boolean active) {
            this.active = active;
        }

        public static EmptyConfig serializableInstance() {
            return new EmptyConfig(true);
        }

        @Override
        public boolean isEventActive(String id) {
            return this.active;
        }

        @Override
        public boolean isActive() {
            return this.active;
        }

        @Override
        public TetradLoggerConfig copy() {
            return new EmptyConfig(this.active);
        }

        @Override
        public List<TetradLoggerConfig.Event> getSupportedEvents() {
            if (!this.active) {
                return Collections.emptyList();
            }
            throw new UnsupportedOperationException("Not supported if active is true");
        }

        @Override
        public void setEventActive(String id, boolean active) {
            throw new UnsupportedOperationException("Can't modify the logger config");
        }
    }
}

