/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class TetradProperties {
    private static final TetradProperties INSTANCE = new TetradProperties();
    private final Map<String, String> props = new HashMap<String, String>();

    private TetradProperties() {
        Properties properties = new Properties();
        try (InputStream inputStream = TetradProperties.class.getResourceAsStream("/tetrad-lib.properties");){
            if (inputStream != null) {
                properties.load(inputStream);
            }
        }
        catch (IOException exception) {
            exception.printStackTrace(System.err);
        }
        properties.stringPropertyNames().forEach(e -> this.props.put((String)e, properties.getProperty((String)e)));
    }

    public static TetradProperties getInstance() {
        return INSTANCE;
    }

    public Set<String> getProperties() {
        return this.props.keySet();
    }

    public String getValue(String property) {
        if (property == null) {
            return null;
        }
        return this.props.get(property);
    }
}

