/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.util;

public class TextTable {
    public static final int LEFT_JUSTIFIED = 0;
    public static final int RIGHT_JUSTIFIED = 1;
    private final String[][] tokens;
    private int justification = 1;
    private int columnSpacing = 2;
    private Delimiter delimiter = Delimiter.JUSTIFIED;

    public TextTable(int rows, int columns) {
        if (rows <= 0 || columns <= 0) {
            throw new IllegalArgumentException();
        }
        this.tokens = new String[rows][columns];
        for (int i = 0; i < this.tokens.length; ++i) {
            for (int j = 0; j < this.tokens[0].length; ++j) {
                this.tokens[i][j] = "";
            }
        }
    }

    public void setToken(int row, int column, String token) {
        if (token == null) {
            throw new NullPointerException();
        }
        if (row >= this.tokens.length) {
            throw new IllegalArgumentException("Row out of bound " + row + " of " + this.tokens.length);
        }
        if (column >= this.tokens[0].length) {
            throw new IllegalArgumentException("Column out of bound " + column + " of " + this.tokens[0].length);
        }
        this.tokens[row][column] = token;
    }

    public String getTokenAt(int row, int column) {
        return this.tokens[row][column];
    }

    public int getNumRows() {
        return this.tokens.length;
    }

    public int getNumColumns() {
        return this.tokens[0].length;
    }

    private int getColumnSpacing() {
        return this.columnSpacing;
    }

    public void setColumnSpacing(int numSpaces) {
        if (numSpaces < 0) {
            throw new IllegalArgumentException();
        }
        this.columnSpacing = numSpaces;
    }

    private int getJustification() {
        return this.justification;
    }

    public void setJustification(int justification) {
        if (justification != 0 && justification != 1) {
            throw new IllegalArgumentException();
        }
        this.justification = justification;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        int[] colWidths = new int[this.tokens[0].length];
        for (int j = 0; j < this.tokens[0].length; ++j) {
            String[][] stringArray = this.tokens;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String[] token = stringArray[i];
                if (token[j].length() <= colWidths[j]) continue;
                colWidths[j] = token[j].length();
            }
        }
        for (String[] token1 : this.tokens) {
            for (int j = 0; j < this.tokens[0].length; ++j) {
                int k;
                if (this.delimiter == Delimiter.TAB) {
                    buffer.append(token1[j]);
                    if (j >= this.tokens[0].length - 1) continue;
                    buffer.append("\t");
                    continue;
                }
                if (this.delimiter == Delimiter.COMMA) {
                    buffer.append(token1[j]);
                    if (j >= this.tokens[0].length - 1) continue;
                    buffer.append(",");
                    continue;
                }
                if (this.delimiter == Delimiter.SPACE) {
                    buffer.append(token1[j]);
                    if (j >= this.tokens[0].length - 1) continue;
                    buffer.append(" ");
                    continue;
                }
                for (int k2 = 0; k2 < this.getColumnSpacing(); ++k2) {
                    buffer.append(' ');
                }
                int numPaddingSpaces = colWidths[j] - token1[j].length();
                if (this.getJustification() == 1) {
                    for (k = 0; k < numPaddingSpaces; ++k) {
                        buffer.append(' ');
                    }
                }
                buffer.append(token1[j]);
                if (this.getJustification() != 0) continue;
                for (k = 0; k < numPaddingSpaces; ++k) {
                    buffer.append(' ');
                }
            }
            buffer.append("\n");
        }
        return buffer.toString();
    }

    public void setDelimiter(Delimiter delimiter) {
        this.delimiter = delimiter;
    }

    public static enum Delimiter {
        JUSTIFIED,
        COMMA,
        TAB,
        SPACE;

    }
}

