/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.distribution.UniformRealDistribution;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.stat.inference.KolmogorovSmirnovTest;

public class UniformityTest {
    public static double getPValue(List<Double> points) {
        double min = points.stream().min(Double::compareTo).orElse(0.0);
        double max = points.stream().max(Double::compareTo).orElse(1.0);
        return UniformityTest.getPValue(points, min, max);
    }

    public static double getPValue(List<Double> points, double min, double max) {
        try {
            double[] data = points.stream().mapToDouble(Double::doubleValue).toArray();
            UniformRealDistribution distribution = new UniformRealDistribution(min, max);
            KolmogorovSmirnovTest test = new KolmogorovSmirnovTest();
            return test.kolmogorovSmirnovTest(distribution, data);
        }
        catch (NumberIsTooLargeException e) {
            e.printStackTrace();
            return Double.NaN;
        }
    }

    public static void main(String[] args) {
        double significanceLevel;
        List<Double> points = UniformityTest.generatePoints();
        double pValue = UniformityTest.getPValue(points);
        if (pValue < (significanceLevel = 0.05)) {
            System.out.println("The distribution is not uniform.");
        } else {
            System.out.println("The distribution is uniform.");
        }
    }

    private static List<Double> generatePoints() {
        ArrayList<Double> points = new ArrayList<Double>();
        points.add(0.1);
        points.add(0.2);
        points.add(0.3);
        points.add(0.4);
        points.add(0.5);
        return points;
    }
}

