/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.util;

import edu.cmu.tetrad.util.Matrix;
import edu.cmu.tetrad.util.MatrixUtils;
import edu.cmu.tetrad.util.TetradSerializable;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.RealVector;

public class Vector
implements TetradSerializable {
    private static final long serialVersionUID = 23L;
    private final RealVector data;

    public Vector(double[] data) {
        this.data = new ArrayRealVector(data);
    }

    public Vector(int size) {
        this.data = new ArrayRealVector(size);
    }

    public static Vector serializableInstance() {
        return new Vector(0);
    }

    public void assign(double value) {
        for (int i = 0; i < this.data.getDimension(); ++i) {
            this.data.setEntry(i, value);
        }
    }

    public void assign(Vector vector) {
        for (int i = 0; i < this.data.getDimension(); ++i) {
            this.data.setEntry(i, vector.get(i));
        }
    }

    public Vector copy() {
        return new Vector(this.data.copy().toArray());
    }

    public Matrix diag() {
        Matrix m = new Matrix(this.data.getDimension(), this.data.getDimension());
        for (int i = 0; i < this.data.getDimension(); ++i) {
            m.set(i, i, this.data.getEntry(i));
        }
        return m;
    }

    public double dotProduct(Vector v2) {
        return this.data.dotProduct(v2.data);
    }

    public double get(int i) {
        return this.data.getEntry(i);
    }

    public Vector like() {
        return new Vector(this.size());
    }

    public Vector minus(Vector mb) {
        return new Vector(this.data.subtract(mb.data).toArray());
    }

    public Vector plus(Vector mb) {
        return new Vector(this.data.add(mb.data).toArray());
    }

    public Vector scalarMult(double scalar) {
        Vector newMatrix = this.copy();
        for (int i = 0; i < this.size(); ++i) {
            newMatrix.set(i, this.get(i) * scalar);
        }
        return newMatrix;
    }

    public void set(int j, double v) {
        this.data.setEntry(j, v);
    }

    public int size() {
        return this.data.getDimension();
    }

    public double[] toArray() {
        return this.data.toArray();
    }

    public String toString() {
        return MatrixUtils.toString(this.data.toArray());
    }

    public Vector viewSelection(int[] selection) {
        double[] _selection = new double[selection.length];
        for (int i = 0; i < selection.length; ++i) {
            _selection[i] = this.data.getEntry(selection[i]);
        }
        return new Vector(_selection);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Vector)) {
            return false;
        }
        Vector v = (Vector)o;
        return MatrixUtils.equals(v.toArray(), this.toArray());
    }

    public double dot(Vector v2) {
        double sum = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            sum += this.get(i) * v2.get(i);
        }
        return sum;
    }
}

