/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.util;

import edu.cmu.tetrad.util.TetradSerializable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Version
implements TetradSerializable {
    private static final long serialVersionUID = 23L;
    private final int majorVersion;
    private final int minorVersion;
    private final int minorSubversion;
    private final int incrementalRelease;

    public Version(String spec) {
        if (spec == null) {
            throw new NullPointerException();
        }
        Pattern pattern2 = Pattern.compile("(\\d*)\\.(\\d*)\\.(\\d*)");
        Matcher matcher2 = pattern2.matcher(spec);
        Pattern pattern3 = Pattern.compile("(\\d*)\\.(\\d*)\\.(\\d*)-(\\d*)");
        Matcher matcher3 = pattern3.matcher(spec);
        Pattern pattern4 = Pattern.compile("(\\d*)\\.(\\d*)\\.(\\d*)(.*)-SNAPSHOT");
        Matcher matcher4 = pattern4.matcher(spec);
        Pattern pattern5 = Pattern.compile("(\\d*)\\.(\\d*)\\.(\\d*)-(\\d*)(.*)-SNAPSHOT");
        Matcher matcher5 = pattern5.matcher(spec);
        if (matcher2.matches()) {
            this.majorVersion = Integer.parseInt(matcher2.group(1));
            this.minorVersion = Integer.parseInt(matcher2.group(2));
            this.minorSubversion = Integer.parseInt(matcher2.group(3));
            this.incrementalRelease = 0;
        } else if (matcher3.matches()) {
            this.majorVersion = Integer.parseInt(matcher3.group(1));
            this.minorVersion = Integer.parseInt(matcher3.group(2));
            this.minorSubversion = Integer.parseInt(matcher3.group(3));
            this.incrementalRelease = Integer.parseInt(matcher3.group(4));
        } else if (matcher4.matches()) {
            this.majorVersion = Integer.parseInt(matcher4.group(1));
            this.minorVersion = Integer.parseInt(matcher4.group(2));
            this.minorSubversion = Integer.parseInt(matcher4.group(3));
            this.incrementalRelease = 0;
        } else if (matcher5.matches()) {
            this.majorVersion = Integer.parseInt(matcher5.group(1));
            this.minorVersion = Integer.parseInt(matcher5.group(2));
            this.minorSubversion = Integer.parseInt(matcher5.group(3));
            this.incrementalRelease = Integer.parseInt(matcher5.group(4));
        } else {
            this.majorVersion = 0;
            this.minorVersion = 0;
            this.minorSubversion = 0;
            this.incrementalRelease = 0;
        }
    }

    private Version(int majorVersion, int minorVersion, int minorSubversion, int incrementalRelease) {
        if (majorVersion < 0) {
            throw new IllegalArgumentException();
        }
        if (minorVersion < 0) {
            throw new IllegalArgumentException();
        }
        if (minorSubversion < 0) {
            throw new IllegalArgumentException();
        }
        if (incrementalRelease < 0) {
            throw new IllegalArgumentException();
        }
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.minorSubversion = minorSubversion;
        this.incrementalRelease = incrementalRelease;
    }

    public static Version currentRepositoryVersion() {
        try {
            File file = new File("project_tetrad/resources/version");
            FileReader fileReader = new FileReader(file);
            BufferedReader bufReader = new BufferedReader(fileReader);
            String spec = bufReader.readLine();
            bufReader.close();
            return new Version(spec);
        }
        catch (IOException e) {
            throw new RuntimeException("Please correct the file project/resources/version \nso that it contains a version number of the form \na.b.c or a.b.c-d or a.b.c-SNAPSHOT or a.b.c-d.e. \nNormally this is set automatically by the Maven build \nsystem.");
        }
    }

    public static Version currentViewableVersion() {
        try {
            String path = "/resources/version";
            URL url = Version.class.getResource("/resources/version");
            if (url == null) {
                throw new RuntimeException("Please correct the file project/resources/version \nso that it contains a version number of the form \na.b.c or a.b.c-d or a.b.c-SNAPSHOT or a.b.c-d.e. \nNormally this is set automatically by the Maven build \nsystem.");
            }
            InputStream inStream = url.openStream();
            InputStreamReader reader = new InputStreamReader(inStream);
            BufferedReader bufReader = new BufferedReader(reader);
            String spec = bufReader.readLine();
            bufReader.close();
            return new Version(spec);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Please correct the file project/resources/version \nso that it contains a version number of the form \na.b.c or a.b.c-d or a.b.c-SNAPSHOT or a.b.c-d.e. \nNormally this is set automatically by the Maven build \nsystem.");
        }
    }

    public static Version serializableInstance() {
        return new Version("1.2.3");
    }

    private int majorVersion() {
        return this.majorVersion;
    }

    private int minorVersion() {
        return this.minorVersion;
    }

    private int minorSubversion() {
        return this.minorSubversion;
    }

    private int incrementalRelease() {
        return this.incrementalRelease;
    }

    public int hashCode() {
        int hashCode = 61;
        hashCode += 61 * this.majorVersion;
        hashCode += 61 * this.minorVersion;
        hashCode += 61 * this.minorSubversion;
        return hashCode += this.incrementalRelease;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Version)) {
            return false;
        }
        Version other = (Version)o;
        if (this.majorVersion != other.majorVersion) {
            return false;
        }
        if (this.minorVersion != other.minorVersion) {
            return false;
        }
        if (this.minorSubversion != other.minorSubversion) {
            return false;
        }
        return this.incrementalRelease == other.incrementalRelease;
    }

    public String toString() {
        return this.majorVersion() + "." + this.minorVersion() + "." + this.minorSubversion() + "-" + this.incrementalRelease();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.majorVersion < 0) {
            throw new IllegalStateException();
        }
        if (this.minorVersion < 0) {
            throw new IllegalStateException();
        }
        if (this.minorSubversion < 0) {
            throw new IllegalStateException();
        }
        if (this.incrementalRelease < 0) {
            throw new IllegalStateException();
        }
    }

    public Version nextMajorVersion() {
        int majorVersion = this.majorVersion + 1;
        boolean minorVersion = false;
        boolean minorSubversion = false;
        boolean incrementalRelease = false;
        return new Version(majorVersion, 0, 0, 0);
    }

    public Version nextMinorVersion() {
        int majorVersion = this.majorVersion;
        int minorVersion = this.minorVersion + 1;
        boolean minorSubversion = false;
        boolean incrementalRelease = false;
        return new Version(majorVersion, minorVersion, 0, 0);
    }

    public Version nextMinorSubversion() {
        int majorVersion = this.majorVersion;
        int minorVersion = this.minorVersion;
        int minorSubversion = this.minorSubversion + 1;
        boolean incrementalRelease = false;
        return new Version(majorVersion, minorVersion, minorSubversion, 0);
    }

    public Version nextIncrementalRelease() {
        int majorVersion = this.majorVersion;
        int minorVersion = this.minorVersion;
        int minorSubversion = this.minorSubversion;
        int incrementalRelease = this.incrementalRelease + 1;
        return new Version(majorVersion, minorVersion, minorSubversion, incrementalRelease);
    }
}

