/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.util.dist;

import edu.cmu.tetrad.util.RandomUtil;
import edu.cmu.tetrad.util.dist.Distribution;

public class Exponential
implements Distribution {
    private static final long serialVersionUID = 23L;
    private double lambda;

    public Exponential(double lambda) {
        this.lambda = lambda;
    }

    public static Exponential serializableInstance() {
        return new Exponential(0.5);
    }

    @Override
    public int getNumParameters() {
        return 1;
    }

    @Override
    public String getName() {
        return "Exponential";
    }

    @Override
    public void setParameter(int index, double value) {
        if (index == 0) {
            this.lambda = value;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public double getParameter(int index) {
        if (index == 0) {
            return this.lambda;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public String getParameterName(int index) {
        if (index == 0) {
            return "Lambda";
        }
        throw new IllegalArgumentException();
    }

    @Override
    public double nextRandom() {
        return RandomUtil.getInstance().nextExponential(this.lambda);
    }

    public String toString() {
        return "Exponential(" + this.lambda + ")";
    }
}

