/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.util.dist;

import edu.cmu.tetrad.util.RandomUtil;
import edu.cmu.tetrad.util.dist.Distribution;

public class Gamma
implements Distribution {
    private static final long serialVersionUID = 23L;
    private double alpha = 0.5;
    private double lambda = 0.7;

    private Gamma() {
    }

    public static Gamma serializableInstance() {
        return new Gamma();
    }

    @Override
    public int getNumParameters() {
        return 2;
    }

    @Override
    public String getName() {
        return "Gamma";
    }

    @Override
    public void setParameter(int index, double value) {
        if (index == 0) {
            this.alpha = value;
        } else if (index == 1) {
            this.lambda = value;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public double getParameter(int index) {
        if (index == 0) {
            return this.alpha;
        }
        if (index == 1) {
            return this.lambda;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public String getParameterName(int index) {
        if (index == 0) {
            return "Alpha";
        }
        if (index == 1) {
            return "Lambda";
        }
        throw new IllegalArgumentException();
    }

    @Override
    public double nextRandom() {
        return RandomUtil.getInstance().nextGamma(this.alpha, this.lambda);
    }

    public String toString() {
        return "Gamma(" + this.alpha + ", " + this.lambda + ")";
    }
}

