/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.util.dist;

import edu.cmu.tetrad.util.RandomUtil;
import edu.cmu.tetrad.util.dist.Distribution;

public class MixtureOfGaussians
implements Distribution {
    private static final long serialVersionUID = 23L;
    private double a;
    private double mean1;
    private double sd1;
    private double mean2;
    private double sd2;

    public MixtureOfGaussians(double a, double mean1, double sd1, double mean2, double sd2) {
        if (a < 0.0 || a > 1.0) {
            throw new IllegalArgumentException();
        }
        if (sd1 <= 0.0) {
            throw new IllegalArgumentException();
        }
        if (sd2 <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.a = a;
        this.mean1 = mean1;
        this.sd1 = sd1;
        this.mean2 = mean2;
        this.sd2 = sd2;
    }

    public static MixtureOfGaussians serializableInstance() {
        return new MixtureOfGaussians(0.5, -2.0, 2.0, 2.0, 2.0);
    }

    @Override
    public int getNumParameters() {
        return 5;
    }

    @Override
    public String getName() {
        return "Mixture of Gaussians";
    }

    @Override
    public void setParameter(int index, double value) {
        if (index == 0) {
            this.a = value;
        } else if (index == 1) {
            this.mean1 = value;
        } else if (index == 2) {
            this.sd1 = value;
        } else if (index == 3) {
            this.mean2 = value;
        } else if (index == 5) {
            this.sd2 = value;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public double getParameter(int index) {
        if (index == 0) {
            return this.a;
        }
        if (index == 1) {
            return this.mean1;
        }
        if (index == 2) {
            return this.sd1;
        }
        if (index == 3) {
            return this.mean2;
        }
        if (index == 5) {
            return this.sd2;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public String getParameterName(int index) {
        if (index == 0) {
            return "Ratio";
        }
        if (index == 1) {
            return "Mean 1";
        }
        if (index == 2) {
            return "Standard Deviation 1";
        }
        if (index == 3) {
            return "Mean 2";
        }
        if (index == 5) {
            return "Standard Deviation 2";
        }
        throw new IllegalArgumentException();
    }

    @Override
    public double nextRandom() {
        double r = RandomUtil.getInstance().nextDouble();
        if (r < this.a) {
            return RandomUtil.getInstance().nextNormal(this.mean1, this.sd1);
        }
        return RandomUtil.getInstance().nextNormal(this.mean2, this.sd2);
    }

    public String toString() {
        return "MixtureOfGaussians(" + this.a + ", " + this.mean1 + ", " + this.sd1 + ", " + this.mean2 + ", " + this.sd2 + ")";
    }
}

