/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.util.dist;

import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetrad.util.RandomUtil;
import edu.cmu.tetrad.util.dist.Distribution;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.NumberFormat;

public class Normal
implements Distribution {
    private static final long serialVersionUID = 23L;
    private double mean;
    private double sd;

    public Normal(double mean, double sd) {
        this.setParameter(0, mean);
        this.setParameter(1, sd);
    }

    public static Normal serializableInstance() {
        return new Normal(0.0, 1.0);
    }

    @Override
    public String getName() {
        return "N";
    }

    @Override
    public void setParameter(int index, double value) {
        if (index == 0) {
            this.mean = value;
        } else if (index == 1 && value >= 0.0) {
            this.sd = value;
        } else {
            throw new IllegalArgumentException("Illegal value for parameter " + index + ": " + value);
        }
    }

    @Override
    public double getParameter(int index) {
        if (index == 0) {
            return this.mean;
        }
        if (index == 1) {
            return this.sd;
        }
        throw new IllegalArgumentException("Illegal index: " + index);
    }

    @Override
    public String getParameterName(int index) {
        if (index == 0) {
            return "Mean";
        }
        if (index == 1) {
            return "Standard Deviation";
        }
        throw new IllegalArgumentException("Not a parameter index: " + index);
    }

    @Override
    public int getNumParameters() {
        return 2;
    }

    @Override
    public double nextRandom() {
        return RandomUtil.getInstance().nextNormal(this.mean, this.sd);
    }

    public String toString() {
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        return "N(" + nf.format(this.mean) + ", " + nf.format(this.sd) + ")";
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.sd <= 0.0) {
            throw new IllegalStateException();
        }
    }
}

