/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.util.dist;

import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetrad.util.RandomUtil;
import edu.cmu.tetrad.util.dist.Distribution;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.NumberFormat;

public class TruncatedNormal
implements Distribution {
    private static final long serialVersionUID = 23L;
    private double mean;
    private double sd;
    private double low;
    private double high;

    private TruncatedNormal() {
        this.setParameter(0, 0.0);
        this.setParameter(1, 1.0);
        this.setParameter(2, Double.NEGATIVE_INFINITY);
        this.setParameter(3, Double.POSITIVE_INFINITY);
    }

    public static TruncatedNormal serializableInstance() {
        return new TruncatedNormal();
    }

    @Override
    public String getName() {
        return "TruncNormal";
    }

    @Override
    public void setParameter(int index, double value) {
        if (index == 0) {
            this.mean = value;
        } else if (index == 1 && value >= 0.0) {
            this.sd = value;
        } else if (index == 2) {
            this.low = value;
        } else if (index == 3) {
            this.high = value;
        } else {
            throw new IllegalArgumentException("Illegal value for parameter " + index + ": " + value);
        }
    }

    @Override
    public double getParameter(int index) {
        if (index == 0) {
            return this.mean;
        }
        if (index == 1) {
            return this.sd;
        }
        throw new IllegalArgumentException("Illegal index: " + index);
    }

    @Override
    public String getParameterName(int index) {
        if (index == 0) {
            return "Mean";
        }
        if (index == 1) {
            return "Standard Deviation";
        }
        if (index == 2) {
            return "Low";
        }
        if (index == 3) {
            return "High";
        }
        throw new IllegalArgumentException("Not a parameter index: " + index);
    }

    @Override
    public int getNumParameters() {
        return 4;
    }

    @Override
    public double nextRandom() {
        return RandomUtil.getInstance().nextTruncatedNormal(this.mean, this.sd, this.low, this.high);
    }

    public String toString() {
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        return "TruncNormal(" + nf.format(this.mean) + ", " + nf.format(this.sd) + ", " + nf.format(this.low) + ", " + nf.format(this.high) + ")";
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.sd <= 0.0) {
            throw new IllegalStateException();
        }
    }
}

