/*
 * Decompiled with CFR 0.152.
 */
package edu.pitt.csb.mgm;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphSaveLoadUtils;
import edu.cmu.tetrad.graph.GraphTransforms;
import edu.cmu.tetrad.search.Pc;
import edu.cmu.tetrad.search.work_in_progress.IndTestMultinomialLogisticRegression;
import edu.cmu.tetrad.util.MillisecondTimes;
import edu.pitt.csb.mgm.ExampleMixedSearch;
import edu.pitt.csb.mgm.IndTestMultinomialLogisticRegressionWald;
import edu.pitt.csb.mgm.MixedUtils;
import java.io.File;

public class ExploreIndepTests {
    public static void main(String[] args) {
        try {
            String path = ExampleMixedSearch.class.getResource("test_data").getPath();
            Graph dag3 = GraphSaveLoadUtils.loadGraphTxt(new File(path, "DAG_0_graph.txt"));
            Graph trueGraph = GraphTransforms.cpdagForDag(dag3);
            DataSet ds = MixedUtils.loadDataSet(path, "DAG_0_data.txt");
            IndTestMultinomialLogisticRegression indMix = new IndTestMultinomialLogisticRegression(ds, 0.05);
            IndTestMultinomialLogisticRegressionWald indWalLin = new IndTestMultinomialLogisticRegressionWald(ds, 0.05, true);
            IndTestMultinomialLogisticRegressionWald indWalLog = new IndTestMultinomialLogisticRegressionWald(ds, 0.05, false);
            Pc s1 = new Pc(indMix);
            Pc s2 = new Pc(indWalLin);
            Pc s3 = new Pc(indWalLog);
            s1.setStable(true);
            s2.setStable(true);
            s3.setStable(true);
            long time = MillisecondTimes.timeMillis();
            Graph dag2 = s1.search();
            Graph g1 = GraphTransforms.cpdagForDag(dag2);
            System.out.println("Mix Time " + (double)(MillisecondTimes.timeMillis() - time) / 1000.0);
            time = MillisecondTimes.timeMillis();
            Graph dag1 = s2.search();
            Graph g2 = GraphTransforms.cpdagForDag(dag1);
            System.out.println("Wald lin Time " + (double)(MillisecondTimes.timeMillis() - time) / 1000.0);
            time = MillisecondTimes.timeMillis();
            Graph dag = s3.search();
            Graph g3 = GraphTransforms.cpdagForDag(dag);
            System.out.println("Wald log Time " + (double)(MillisecondTimes.timeMillis() - time) / 1000.0);
            System.out.println("TD\tTU\tFL\tFD\tFU\tFPD\tFPU\tFND\tFNU\tBidir");
            System.out.println(MixedUtils.stringFrom2dArray(MixedUtils.allEdgeStats(trueGraph, g1)));
            System.out.println(MixedUtils.stringFrom2dArray(MixedUtils.allEdgeStats(trueGraph, g2)));
            System.out.println(MixedUtils.stringFrom2dArray(MixedUtils.allEdgeStats(trueGraph, g3)));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

